# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import datetime
import sys
from typing import Any, Callable, Dict, IO, Optional, TypeVar, Union, cast, overload

from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict

from ...operations._operations import (
    build_metadata_get_request,
    build_metadata_post_request,
    build_query_batch_request,
    build_query_execute_request,
    build_query_get_request,
)

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class QueryOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~monitor_query_client.aio.MonitorQueryClient`'s
        :attr:`query` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace_async
    async def get(
        self, workspace_id: str, *, query: str, timespan: Optional[datetime.timedelta] = None, **kwargs: Any
    ) -> JSON:
        """Execute an Analytics query.

        Executes an Analytics query for data.

        :param workspace_id: ID of the workspace. This is Workspace ID from the Properties blade in the
         Azure portal. Required.
        :type workspace_id: str
        :keyword query: The Analytics query. Learn more about the `Analytics query syntax
         <https://azure.microsoft.com/documentation/articles/app-insights-analytics-reference/>`_.
         Required.
        :paramtype query: str
        :keyword timespan: Optional. The timespan over which to query data. This is an ISO8601 time
         period value.  This timespan is applied in addition to any that are specified in the query
         expression. Default value is None.
        :paramtype timespan: ~datetime.timedelta
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "tables": [
                        {
                            "columns": [
                                {
                                    "name": "str",  # The name of this column.
                                      Required.
                                    "type": "str"  # The data type of this
                                      column. Required. Known values are: "bool", "datetime",
                                      "dynamic", "int", "long", "real", "string", "guid", "decimal",
                                      and "timespan".
                                }
                            ],
                            "name": "str",  # The name of the table. Required.
                            "rows": [
                                [
                                    {}  # The resulting rows from this query.
                                      Required.
                                ]
                            ]
                        }
                    ],
                    "error": {
                        "code": "str",  # A machine readable error code. Required.
                        "message": "str",  # A human readable error message. Required.
                        "details": [
                            {
                                "code": "str",  # The error's code. Required.
                                "message": "str",  # A human readable error message.
                                  Required.
                                "resources": [
                                    "str"  # Optional. Indicates resources which
                                      were responsible for the error.
                                ],
                                "target": "str",  # Optional. Indicates which
                                  property in the request is responsible for the error.
                                "value": "str"  # Optional. Indicates which value in
                                  'target' is responsible for the error.
                            }
                        ],
                        "innererror": ...
                    },
                    "render": {},  # Optional. Visualization data in JSON format.
                    "statistics": {}  # Optional. Statistics represented in JSON format.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        request = build_query_get_request(
            workspace_id=workspace_id,
            query=query,
            timespan=timespan,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @overload
    async def execute(
        self,
        workspace_id: str,
        body: JSON,
        *,
        prefer: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> JSON:
        """Execute an Analytics query.

        Executes an Analytics query for data. `Here
        <https://dev.loganalytics.io/documentation/Using-the-API>`_ is an example for using POST with
        an Analytics query.

        :param workspace_id: ID of the workspace. This is Workspace ID from the Properties blade in the
         Azure portal. Required.
        :type workspace_id: str
        :param body: The Analytics query. Learn more about the `Analytics query syntax
         <https://azure.microsoft.com/documentation/articles/app-insights-analytics-reference/>`_.
         Required.
        :type body: JSON
        :keyword prefer: Optional. The prefer header to set server timeout, query statistics and
         visualization information. Default value is None.
        :paramtype prefer: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "query": "str",  # The query to execute. Required.
                    "timespan": "str",  # Optional. Optional. The timespan over which to query
                      data. This is an ISO8601 time period value.  This timespan is applied in addition
                      to any that are specified in the query expression.
                    "workspaces": [
                        "str"  # Optional. A list of workspaces that are included in the
                          query.
                    ]
                }

                # response body for status code(s): 200
                response == {
                    "tables": [
                        {
                            "columns": [
                                {
                                    "name": "str",  # The name of this column.
                                      Required.
                                    "type": "str"  # The data type of this
                                      column. Required. Known values are: "bool", "datetime",
                                      "dynamic", "int", "long", "real", "string", "guid", "decimal",
                                      and "timespan".
                                }
                            ],
                            "name": "str",  # The name of the table. Required.
                            "rows": [
                                [
                                    {}  # The resulting rows from this query.
                                      Required.
                                ]
                            ]
                        }
                    ],
                    "error": {
                        "code": "str",  # A machine readable error code. Required.
                        "message": "str",  # A human readable error message. Required.
                        "details": [
                            {
                                "code": "str",  # The error's code. Required.
                                "message": "str",  # A human readable error message.
                                  Required.
                                "resources": [
                                    "str"  # Optional. Indicates resources which
                                      were responsible for the error.
                                ],
                                "target": "str",  # Optional. Indicates which
                                  property in the request is responsible for the error.
                                "value": "str"  # Optional. Indicates which value in
                                  'target' is responsible for the error.
                            }
                        ],
                        "innererror": ...
                    },
                    "render": {},  # Optional. Visualization data in JSON format.
                    "statistics": {}  # Optional. Statistics represented in JSON format.
                }
        """

    @overload
    async def execute(
        self,
        workspace_id: str,
        body: IO,
        *,
        prefer: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> JSON:
        """Execute an Analytics query.

        Executes an Analytics query for data. `Here
        <https://dev.loganalytics.io/documentation/Using-the-API>`_ is an example for using POST with
        an Analytics query.

        :param workspace_id: ID of the workspace. This is Workspace ID from the Properties blade in the
         Azure portal. Required.
        :type workspace_id: str
        :param body: The Analytics query. Learn more about the `Analytics query syntax
         <https://azure.microsoft.com/documentation/articles/app-insights-analytics-reference/>`_.
         Required.
        :type body: IO
        :keyword prefer: Optional. The prefer header to set server timeout, query statistics and
         visualization information. Default value is None.
        :paramtype prefer: str
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "tables": [
                        {
                            "columns": [
                                {
                                    "name": "str",  # The name of this column.
                                      Required.
                                    "type": "str"  # The data type of this
                                      column. Required. Known values are: "bool", "datetime",
                                      "dynamic", "int", "long", "real", "string", "guid", "decimal",
                                      and "timespan".
                                }
                            ],
                            "name": "str",  # The name of the table. Required.
                            "rows": [
                                [
                                    {}  # The resulting rows from this query.
                                      Required.
                                ]
                            ]
                        }
                    ],
                    "error": {
                        "code": "str",  # A machine readable error code. Required.
                        "message": "str",  # A human readable error message. Required.
                        "details": [
                            {
                                "code": "str",  # The error's code. Required.
                                "message": "str",  # A human readable error message.
                                  Required.
                                "resources": [
                                    "str"  # Optional. Indicates resources which
                                      were responsible for the error.
                                ],
                                "target": "str",  # Optional. Indicates which
                                  property in the request is responsible for the error.
                                "value": "str"  # Optional. Indicates which value in
                                  'target' is responsible for the error.
                            }
                        ],
                        "innererror": ...
                    },
                    "render": {},  # Optional. Visualization data in JSON format.
                    "statistics": {}  # Optional. Statistics represented in JSON format.
                }
        """

    @distributed_trace_async
    async def execute(
        self, workspace_id: str, body: Union[JSON, IO], *, prefer: Optional[str] = None, **kwargs: Any
    ) -> JSON:
        """Execute an Analytics query.

        Executes an Analytics query for data. `Here
        <https://dev.loganalytics.io/documentation/Using-the-API>`_ is an example for using POST with
        an Analytics query.

        :param workspace_id: ID of the workspace. This is Workspace ID from the Properties blade in the
         Azure portal. Required.
        :type workspace_id: str
        :param body: The Analytics query. Learn more about the `Analytics query syntax
         <https://azure.microsoft.com/documentation/articles/app-insights-analytics-reference/>`_. Is
         either a model type or a IO type. Required.
        :type body: JSON or IO
        :keyword prefer: Optional. The prefer header to set server timeout, query statistics and
         visualization information. Default value is None.
        :paramtype prefer: str
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "tables": [
                        {
                            "columns": [
                                {
                                    "name": "str",  # The name of this column.
                                      Required.
                                    "type": "str"  # The data type of this
                                      column. Required. Known values are: "bool", "datetime",
                                      "dynamic", "int", "long", "real", "string", "guid", "decimal",
                                      and "timespan".
                                }
                            ],
                            "name": "str",  # The name of the table. Required.
                            "rows": [
                                [
                                    {}  # The resulting rows from this query.
                                      Required.
                                ]
                            ]
                        }
                    ],
                    "error": {
                        "code": "str",  # A machine readable error code. Required.
                        "message": "str",  # A human readable error message. Required.
                        "details": [
                            {
                                "code": "str",  # The error's code. Required.
                                "message": "str",  # A human readable error message.
                                  Required.
                                "resources": [
                                    "str"  # Optional. Indicates resources which
                                      were responsible for the error.
                                ],
                                "target": "str",  # Optional. Indicates which
                                  property in the request is responsible for the error.
                                "value": "str"  # Optional. Indicates which value in
                                  'target' is responsible for the error.
                            }
                        ],
                        "innererror": ...
                    },
                    "render": {},  # Optional. Visualization data in JSON format.
                    "statistics": {}  # Optional. Statistics represented in JSON format.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IO, bytes)):
            _content = body
        else:
            _json = body

        request = build_query_execute_request(
            workspace_id=workspace_id,
            prefer=prefer,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @overload
    async def batch(self, body: JSON, *, content_type: str = "application/json", **kwargs: Any) -> JSON:
        """Execute a batch of Analytics queries.

        Executes a batch of Analytics queries for data. `Here
        <https://dev.loganalytics.io/documentation/Using-the-API>`_ is an example for using POST with
        an Analytics query.

        :param body: The batch request body. Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "requests": [
                        {
                            "body": {
                                "query": "str",  # The query to execute. Required.
                                "timespan": "str",  # Optional. Optional. The
                                  timespan over which to query data. This is an ISO8601 time period
                                  value.  This timespan is applied in addition to any that are
                                  specified in the query expression.
                                "workspaces": [
                                    "str"  # Optional. A list of workspaces that
                                      are included in the query.
                                ]
                            },
                            "id": "str",  # The error details. Required.
                            "workspace": "str",  # Workspace Id to be included in the
                              query. Required.
                            "headers": {
                                "str": "str"  # Optional. Dictionary of
                                  :code:`<string>`.
                            },
                            "method": "str",  # Optional. "POST"
                            "path": "str"  # Optional. "/query"
                        }
                    ]
                }

                # response body for status code(s): 200
                response == {
                    "responses": [
                        {
                            "body": {
                                "error": {
                                    "code": "str",  # A machine readable error
                                      code. Required.
                                    "message": "str",  # A human readable error
                                      message. Required.
                                    "details": [
                                        {
                                            "code": "str",  # The error's
                                              code. Required.
                                            "message": "str",  # A human
                                              readable error message. Required.
                                            "resources": [
                                                "str"  # Optional.
                                                  Indicates resources which were responsible for the
                                                  error.
                                            ],
                                            "target": "str",  # Optional.
                                              Indicates which property in the request is responsible
                                              for the error.
                                            "value": "str"  # Optional.
                                              Indicates which value in 'target' is responsible for the
                                              error.
                                        }
                                    ],
                                    "innererror": ...
                                },
                                "render": {},  # Optional. Visualization data in JSON
                                  format.
                                "statistics": {},  # Optional. Statistics represented
                                  in JSON format.
                                "tables": [
                                    {
                                        "columns": [
                                            {
                                                "name": "str",  # The
                                                  name of this column. Required.
                                                "type": "str"  # The
                                                  data type of this column. Required. Known values are:
                                                  "bool", "datetime", "dynamic", "int", "long", "real",
                                                  "string", "guid", "decimal", and "timespan".
                                            }
                                        ],
                                        "name": "str",  # The name of the
                                          table. Required.
                                        "rows": [
                                            [
                                                {}  # The resulting
                                                  rows from this query. Required.
                                            ]
                                        ]
                                    }
                                ]
                            },
                            "headers": {
                                "str": "str"  # Optional. Dictionary of
                                  :code:`<string>`.
                            },
                            "id": "str",  # Optional. An array of responses corresponding
                              to each individual request in a batch.
                            "status": 0  # Optional. An array of responses corresponding
                              to each individual request in a batch.
                        }
                    ]
                }
        """

    @overload
    async def batch(self, body: IO, *, content_type: str = "application/json", **kwargs: Any) -> JSON:
        """Execute a batch of Analytics queries.

        Executes a batch of Analytics queries for data. `Here
        <https://dev.loganalytics.io/documentation/Using-the-API>`_ is an example for using POST with
        an Analytics query.

        :param body: The batch request body. Required.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "responses": [
                        {
                            "body": {
                                "error": {
                                    "code": "str",  # A machine readable error
                                      code. Required.
                                    "message": "str",  # A human readable error
                                      message. Required.
                                    "details": [
                                        {
                                            "code": "str",  # The error's
                                              code. Required.
                                            "message": "str",  # A human
                                              readable error message. Required.
                                            "resources": [
                                                "str"  # Optional.
                                                  Indicates resources which were responsible for the
                                                  error.
                                            ],
                                            "target": "str",  # Optional.
                                              Indicates which property in the request is responsible
                                              for the error.
                                            "value": "str"  # Optional.
                                              Indicates which value in 'target' is responsible for the
                                              error.
                                        }
                                    ],
                                    "innererror": ...
                                },
                                "render": {},  # Optional. Visualization data in JSON
                                  format.
                                "statistics": {},  # Optional. Statistics represented
                                  in JSON format.
                                "tables": [
                                    {
                                        "columns": [
                                            {
                                                "name": "str",  # The
                                                  name of this column. Required.
                                                "type": "str"  # The
                                                  data type of this column. Required. Known values are:
                                                  "bool", "datetime", "dynamic", "int", "long", "real",
                                                  "string", "guid", "decimal", and "timespan".
                                            }
                                        ],
                                        "name": "str",  # The name of the
                                          table. Required.
                                        "rows": [
                                            [
                                                {}  # The resulting
                                                  rows from this query. Required.
                                            ]
                                        ]
                                    }
                                ]
                            },
                            "headers": {
                                "str": "str"  # Optional. Dictionary of
                                  :code:`<string>`.
                            },
                            "id": "str",  # Optional. An array of responses corresponding
                              to each individual request in a batch.
                            "status": 0  # Optional. An array of responses corresponding
                              to each individual request in a batch.
                        }
                    ]
                }
        """

    @distributed_trace_async
    async def batch(self, body: Union[JSON, IO], **kwargs: Any) -> JSON:
        """Execute a batch of Analytics queries.

        Executes a batch of Analytics queries for data. `Here
        <https://dev.loganalytics.io/documentation/Using-the-API>`_ is an example for using POST with
        an Analytics query.

        :param body: The batch request body. Is either a model type or a IO type. Required.
        :type body: JSON or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "responses": [
                        {
                            "body": {
                                "error": {
                                    "code": "str",  # A machine readable error
                                      code. Required.
                                    "message": "str",  # A human readable error
                                      message. Required.
                                    "details": [
                                        {
                                            "code": "str",  # The error's
                                              code. Required.
                                            "message": "str",  # A human
                                              readable error message. Required.
                                            "resources": [
                                                "str"  # Optional.
                                                  Indicates resources which were responsible for the
                                                  error.
                                            ],
                                            "target": "str",  # Optional.
                                              Indicates which property in the request is responsible
                                              for the error.
                                            "value": "str"  # Optional.
                                              Indicates which value in 'target' is responsible for the
                                              error.
                                        }
                                    ],
                                    "innererror": ...
                                },
                                "render": {},  # Optional. Visualization data in JSON
                                  format.
                                "statistics": {},  # Optional. Statistics represented
                                  in JSON format.
                                "tables": [
                                    {
                                        "columns": [
                                            {
                                                "name": "str",  # The
                                                  name of this column. Required.
                                                "type": "str"  # The
                                                  data type of this column. Required. Known values are:
                                                  "bool", "datetime", "dynamic", "int", "long", "real",
                                                  "string", "guid", "decimal", and "timespan".
                                            }
                                        ],
                                        "name": "str",  # The name of the
                                          table. Required.
                                        "rows": [
                                            [
                                                {}  # The resulting
                                                  rows from this query. Required.
                                            ]
                                        ]
                                    }
                                ]
                            },
                            "headers": {
                                "str": "str"  # Optional. Dictionary of
                                  :code:`<string>`.
                            },
                            "id": "str",  # Optional. An array of responses corresponding
                              to each individual request in a batch.
                            "status": 0  # Optional. An array of responses corresponding
                              to each individual request in a batch.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IO, bytes)):
            _content = body
        else:
            _json = body

        request = build_query_batch_request(
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)


class MetadataOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~monitor_query_client.aio.MonitorQueryClient`'s
        :attr:`metadata` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace_async
    async def get(self, workspace_id: str, **kwargs: Any) -> JSON:
        """Gets metadata information.

        Retrieve the metadata information for the workspace, including its schema, functions, workspace
        info, categories etc.

        :param workspace_id: ID of the workspace. This is Workspace ID from the Properties blade in the
         Azure portal. Required.
        :type workspace_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "applications": [
                        {
                            "id": "str",  # The ID of the Application Insights app.
                              Required.
                            "name": "str",  # The name of the Application Insights app.
                              Required.
                            "region": "str",  # The Azure region of the Application
                              Insights app. Required.
                            "resourceId": "str",  # The ARM resource ID of the
                              Application Insights app. Required.
                            "related": {
                                "functions": [
                                    "str"  # Optional. The related functions for
                                      the Application Insights app.
                                ],
                                "tables": [
                                    "str"  # Optional. The related tables for the
                                      Application Insights app.
                                ]
                            }
                        }
                    ],
                    "categories": [
                        {
                            "displayName": "str",  # The display name of the category.
                              Required.
                            "id": "str",  # The ID of the category. Required.
                            "description": "str",  # Optional. The description of the
                              category.
                            "related": {
                                "functions": [
                                    "str"  # Optional. The functions related to
                                      the category.
                                ],
                                "queries": [
                                    "str"  # Optional. The saved queries related
                                      to the category.
                                ],
                                "resourceTypes": [
                                    "str"  # Optional. The resource types related
                                      to the category.
                                ],
                                "solutions": [
                                    "str"  # Optional. The Log Analytics
                                      solutions related to the category.
                                ],
                                "tables": [
                                    "str"  # Optional. The tables related to the
                                      category.
                                ]
                            }
                        }
                    ],
                    "functions": [
                        {
                            "body": "str",  # The KQL body of the function. Required.
                            "id": "str",  # The ID of the function. Required.
                            "name": "str",  # The name of the function, to be used in
                              queries. Required.
                            "description": "str",  # Optional. The description of the
                              function.
                            "displayName": "str",  # Optional. The display name of the
                              function.
                            "parameters": "str",  # Optional. The parameters/arguments of
                              the function, if any.
                            "properties": {},  # Optional. The properties of the
                              function.
                            "related": {
                                "categories": [
                                    "str"  # Optional. The related categories for
                                      the function.
                                ],
                                "resourceTypes": [
                                    "str"  # Optional. The related resource types
                                      for the function.
                                ],
                                "solutions": [
                                    "str"  # Optional. The related Log Analytics
                                      solutions for the function.
                                ],
                                "tables": [
                                    "str"  # Optional. The related tables for the
                                      function.
                                ],
                                "workspaces": [
                                    "str"  # Optional. The related workspaces for
                                      the function.
                                ]
                            },
                            "tags": {}  # Optional. The tags associated with the
                              function.
                        }
                    ],
                    "permissions": [
                        {
                            "workspaces": [
                                {
                                    "resourceId": "str",  # The resource ID on
                                      the permission indication. Required.
                                    "denyTables": [
                                        "str"  # Optional. The list of tables
                                          that were denied access for the resource ID.
                                    ]
                                }
                            ],
                            "applications": [
                                {
                                    "resourceId": "str"  # The resource ID on the
                                      permission indication. Required.
                                }
                            ],
                            "resources": [
                                {
                                    "resourceId": "str",  # The resource ID on
                                      the permission indication. Required.
                                    "denyTables": [
                                        "str"  # Optional. The list of tables
                                          that were denied access for the resource ID.
                                    ]
                                }
                            ]
                        }
                    ],
                    "queries": [
                        {
                            "body": "str",  # The KQL body of the query. Required.
                            "id": "str",  # The ID of the query. Required.
                            "description": "str",  # Optional. The description of the
                              query.
                            "displayName": "str",  # Optional. The display name of the
                              query.
                            "labels": [
                                "str"  # Optional. The user defined labels associated
                                  with the query.
                            ],
                            "properties": {},  # Optional. The properties of the query.
                            "related": {
                                "categories": [
                                    "str"  # Optional. The related categories for
                                      the query.
                                ],
                                "resourceTypes": [
                                    "str"  # Optional. The related resource types
                                      for the query.
                                ],
                                "solutions": [
                                    "str"  # Optional. The related Log Analytics
                                      solutions for the query.
                                ],
                                "tables": [
                                    "str"  # Optional. The related tables for the
                                      query.
                                ]
                            },
                            "tags": {}  # Optional. The tags associated with the query.
                        }
                    ],
                    "resourceTypes": [
                        {
                            "id": "str",  # The ID of the resource-type. Required.
                            "type": "str",  # The type of the resource-type. Required.
                            "description": "str",  # Optional. The description of the
                              resource-type.
                            "displayName": "str",  # Optional. The display name of the
                              resource-type.
                            "labels": [
                                "str"  # Optional. The user-defined labels of the
                                  resource-type.
                            ],
                            "properties": {},  # Optional. The properties of the
                              resource-type.
                            "related": {
                                "categories": [
                                    "str"  # Optional. The categories related to
                                      the resource-type.
                                ],
                                "functions": [
                                    "str"  # Optional. The functions related to
                                      the resource-type.
                                ],
                                "queries": [
                                    "str"  # Optional. The queries related to the
                                      resource-type.
                                ],
                                "resources": [
                                    "str"  # Optional. The Azure resources
                                      related to the resource-type.
                                ],
                                "tables": [
                                    "str"  # Optional. The tables related to the
                                      resource-type.
                                ],
                                "workspaces": [
                                    "str"  # Optional. The Log Analytics
                                      workspaces related to the resource-type.
                                ]
                            },
                            "tags": {}  # Optional. The tags associated with the
                              resource-type.
                        }
                    ],
                    "resources": [
                        {}  # Optional. The list of Azure resources that were referenced in
                          the metadata request.
                    ],
                    "solutions": [
                        {
                            "id": "str",  # The ID of the Log Analytics solution.
                              Required.
                            "name": "str",  # The name of the Log Analytics solution.
                              Required.
                            "related": {
                                "tables": [
                                    "str"  # The tables related to the Log
                                      Analytics solution. Required.
                                ],
                                "categories": [
                                    "str"  # Optional. The categories related to
                                      the Log Analytics solution.
                                ],
                                "functions": [
                                    "str"  # Optional. The functions related to
                                      the Log Analytics solution.
                                ],
                                "queries": [
                                    "str"  # Optional. The saved queries related
                                      to the Log Analytics solution.
                                ],
                                "workspaces": [
                                    "str"  # Optional. The Workspaces referenced
                                      in the metadata request that are related to the Log Analytics
                                      solution.
                                ]
                            },
                            "description": "str",  # Optional. The description of the Log
                              Analytics solution.
                            "displayName": "str",  # Optional. The display name of the
                              Log Analytics solution.
                            "properties": {},  # Optional. The properties of the Log
                              Analytics solution.
                            "tags": {}  # Optional. The tags that are associated with the
                              Log Analytics solution.
                        }
                    ],
                    "tables": [
                        {
                            "id": "str",  # The ID of the table. Required.
                            "name": "str",  # The name of the table. Required.
                            "columns": [
                                {
                                    "name": "str",  # The name of the column.
                                      Required.
                                    "type": "str",  # The data type of the
                                      column. Required. Known values are: "bool", "datetime",
                                      "dynamic", "int", "long", "real", "string", "guid", "decimal",
                                      and "timespan".
                                    "description": "str",  # Optional. The
                                      description of the column.
                                    "isPreferredFacet": bool,  # Optional. A flag
                                      indicating this column is a preferred facet.
                                    "source": {}  # Optional. an indication of
                                      the source of the column, used only when multiple workspaces have
                                      conflicting definition for the column.
                                }
                            ],
                            "description": "str",  # Optional. The description of the
                              table.
                            "labels": [
                                "str"  # Optional. The user defined labels of the
                                  table.
                            ],
                            "properties": {},  # Optional. The properties of the table.
                            "related": {
                                "categories": [
                                    "str"  # Optional. The related categories for
                                      the table.
                                ],
                                "functions": [
                                    "str"  # Optional. The related functions for
                                      the table.
                                ],
                                "queries": [
                                    "str"  # Optional. The related saved queries
                                      for the table.
                                ],
                                "resourceTypes": [
                                    "str"  # Optional. The related resource types
                                      for the table.
                                ],
                                "solutions": [
                                    "str"  # Optional. The related Log Analytics
                                      solutions for the table.
                                ],
                                "workspaces": [
                                    "str"  # Optional. The related Log Analytics
                                      workspaces for the table.
                                ]
                            },
                            "tags": {},  # Optional. The tags associated with the table.
                            "timespanColumn": "str"  # Optional. The column associated
                              with the timespan query parameter for the table.
                        }
                    ],
                    "workspaces": [
                        {
                            "id": "str",  # The ID of the Log Analytics workspace.
                              Required.
                            "name": "str",  # The name of the Log Analytics workspace.
                              Required.
                            "region": "str",  # The Azure region of the Log Analytics
                              workspace. Required.
                            "resourceId": "str",  # The ARM resource ID of the Log
                              Analytics workspace. Required.
                            "related": {
                                "functions": [
                                    "str"  # Optional. The related functions for
                                      the Log Analytics workspace.
                                ],
                                "resourceTypes": [
                                    "str"  # Optional. The related resource types
                                      for the Log Analytics workspace.
                                ],
                                "resources": [
                                    "str"  # Optional. The related Azure
                                      resources for the Log Analytics workspace.
                                ],
                                "solutions": [
                                    "str"  # Optional. The related Log Analytics
                                      solutions for the Log Analytics workspace.
                                ],
                                "tables": [
                                    "str"  # Optional. The related tables for the
                                      Log Analytics workspace.
                                ]
                            }
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        request = build_metadata_get_request(
            workspace_id=workspace_id,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @distributed_trace_async
    async def post(self, workspace_id: str, **kwargs: Any) -> JSON:
        """Gets metadata information.

        Retrieve the metadata information for the workspace, including its schema, functions, workspace
        info, categories etc.

        :param workspace_id: ID of the workspace. This is Workspace ID from the Properties blade in the
         Azure portal. Required.
        :type workspace_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "applications": [
                        {
                            "id": "str",  # The ID of the Application Insights app.
                              Required.
                            "name": "str",  # The name of the Application Insights app.
                              Required.
                            "region": "str",  # The Azure region of the Application
                              Insights app. Required.
                            "resourceId": "str",  # The ARM resource ID of the
                              Application Insights app. Required.
                            "related": {
                                "functions": [
                                    "str"  # Optional. The related functions for
                                      the Application Insights app.
                                ],
                                "tables": [
                                    "str"  # Optional. The related tables for the
                                      Application Insights app.
                                ]
                            }
                        }
                    ],
                    "categories": [
                        {
                            "displayName": "str",  # The display name of the category.
                              Required.
                            "id": "str",  # The ID of the category. Required.
                            "description": "str",  # Optional. The description of the
                              category.
                            "related": {
                                "functions": [
                                    "str"  # Optional. The functions related to
                                      the category.
                                ],
                                "queries": [
                                    "str"  # Optional. The saved queries related
                                      to the category.
                                ],
                                "resourceTypes": [
                                    "str"  # Optional. The resource types related
                                      to the category.
                                ],
                                "solutions": [
                                    "str"  # Optional. The Log Analytics
                                      solutions related to the category.
                                ],
                                "tables": [
                                    "str"  # Optional. The tables related to the
                                      category.
                                ]
                            }
                        }
                    ],
                    "functions": [
                        {
                            "body": "str",  # The KQL body of the function. Required.
                            "id": "str",  # The ID of the function. Required.
                            "name": "str",  # The name of the function, to be used in
                              queries. Required.
                            "description": "str",  # Optional. The description of the
                              function.
                            "displayName": "str",  # Optional. The display name of the
                              function.
                            "parameters": "str",  # Optional. The parameters/arguments of
                              the function, if any.
                            "properties": {},  # Optional. The properties of the
                              function.
                            "related": {
                                "categories": [
                                    "str"  # Optional. The related categories for
                                      the function.
                                ],
                                "resourceTypes": [
                                    "str"  # Optional. The related resource types
                                      for the function.
                                ],
                                "solutions": [
                                    "str"  # Optional. The related Log Analytics
                                      solutions for the function.
                                ],
                                "tables": [
                                    "str"  # Optional. The related tables for the
                                      function.
                                ],
                                "workspaces": [
                                    "str"  # Optional. The related workspaces for
                                      the function.
                                ]
                            },
                            "tags": {}  # Optional. The tags associated with the
                              function.
                        }
                    ],
                    "permissions": [
                        {
                            "workspaces": [
                                {
                                    "resourceId": "str",  # The resource ID on
                                      the permission indication. Required.
                                    "denyTables": [
                                        "str"  # Optional. The list of tables
                                          that were denied access for the resource ID.
                                    ]
                                }
                            ],
                            "applications": [
                                {
                                    "resourceId": "str"  # The resource ID on the
                                      permission indication. Required.
                                }
                            ],
                            "resources": [
                                {
                                    "resourceId": "str",  # The resource ID on
                                      the permission indication. Required.
                                    "denyTables": [
                                        "str"  # Optional. The list of tables
                                          that were denied access for the resource ID.
                                    ]
                                }
                            ]
                        }
                    ],
                    "queries": [
                        {
                            "body": "str",  # The KQL body of the query. Required.
                            "id": "str",  # The ID of the query. Required.
                            "description": "str",  # Optional. The description of the
                              query.
                            "displayName": "str",  # Optional. The display name of the
                              query.
                            "labels": [
                                "str"  # Optional. The user defined labels associated
                                  with the query.
                            ],
                            "properties": {},  # Optional. The properties of the query.
                            "related": {
                                "categories": [
                                    "str"  # Optional. The related categories for
                                      the query.
                                ],
                                "resourceTypes": [
                                    "str"  # Optional. The related resource types
                                      for the query.
                                ],
                                "solutions": [
                                    "str"  # Optional. The related Log Analytics
                                      solutions for the query.
                                ],
                                "tables": [
                                    "str"  # Optional. The related tables for the
                                      query.
                                ]
                            },
                            "tags": {}  # Optional. The tags associated with the query.
                        }
                    ],
                    "resourceTypes": [
                        {
                            "id": "str",  # The ID of the resource-type. Required.
                            "type": "str",  # The type of the resource-type. Required.
                            "description": "str",  # Optional. The description of the
                              resource-type.
                            "displayName": "str",  # Optional. The display name of the
                              resource-type.
                            "labels": [
                                "str"  # Optional. The user-defined labels of the
                                  resource-type.
                            ],
                            "properties": {},  # Optional. The properties of the
                              resource-type.
                            "related": {
                                "categories": [
                                    "str"  # Optional. The categories related to
                                      the resource-type.
                                ],
                                "functions": [
                                    "str"  # Optional. The functions related to
                                      the resource-type.
                                ],
                                "queries": [
                                    "str"  # Optional. The queries related to the
                                      resource-type.
                                ],
                                "resources": [
                                    "str"  # Optional. The Azure resources
                                      related to the resource-type.
                                ],
                                "tables": [
                                    "str"  # Optional. The tables related to the
                                      resource-type.
                                ],
                                "workspaces": [
                                    "str"  # Optional. The Log Analytics
                                      workspaces related to the resource-type.
                                ]
                            },
                            "tags": {}  # Optional. The tags associated with the
                              resource-type.
                        }
                    ],
                    "resources": [
                        {}  # Optional. The list of Azure resources that were referenced in
                          the metadata request.
                    ],
                    "solutions": [
                        {
                            "id": "str",  # The ID of the Log Analytics solution.
                              Required.
                            "name": "str",  # The name of the Log Analytics solution.
                              Required.
                            "related": {
                                "tables": [
                                    "str"  # The tables related to the Log
                                      Analytics solution. Required.
                                ],
                                "categories": [
                                    "str"  # Optional. The categories related to
                                      the Log Analytics solution.
                                ],
                                "functions": [
                                    "str"  # Optional. The functions related to
                                      the Log Analytics solution.
                                ],
                                "queries": [
                                    "str"  # Optional. The saved queries related
                                      to the Log Analytics solution.
                                ],
                                "workspaces": [
                                    "str"  # Optional. The Workspaces referenced
                                      in the metadata request that are related to the Log Analytics
                                      solution.
                                ]
                            },
                            "description": "str",  # Optional. The description of the Log
                              Analytics solution.
                            "displayName": "str",  # Optional. The display name of the
                              Log Analytics solution.
                            "properties": {},  # Optional. The properties of the Log
                              Analytics solution.
                            "tags": {}  # Optional. The tags that are associated with the
                              Log Analytics solution.
                        }
                    ],
                    "tables": [
                        {
                            "id": "str",  # The ID of the table. Required.
                            "name": "str",  # The name of the table. Required.
                            "columns": [
                                {
                                    "name": "str",  # The name of the column.
                                      Required.
                                    "type": "str",  # The data type of the
                                      column. Required. Known values are: "bool", "datetime",
                                      "dynamic", "int", "long", "real", "string", "guid", "decimal",
                                      and "timespan".
                                    "description": "str",  # Optional. The
                                      description of the column.
                                    "isPreferredFacet": bool,  # Optional. A flag
                                      indicating this column is a preferred facet.
                                    "source": {}  # Optional. an indication of
                                      the source of the column, used only when multiple workspaces have
                                      conflicting definition for the column.
                                }
                            ],
                            "description": "str",  # Optional. The description of the
                              table.
                            "labels": [
                                "str"  # Optional. The user defined labels of the
                                  table.
                            ],
                            "properties": {},  # Optional. The properties of the table.
                            "related": {
                                "categories": [
                                    "str"  # Optional. The related categories for
                                      the table.
                                ],
                                "functions": [
                                    "str"  # Optional. The related functions for
                                      the table.
                                ],
                                "queries": [
                                    "str"  # Optional. The related saved queries
                                      for the table.
                                ],
                                "resourceTypes": [
                                    "str"  # Optional. The related resource types
                                      for the table.
                                ],
                                "solutions": [
                                    "str"  # Optional. The related Log Analytics
                                      solutions for the table.
                                ],
                                "workspaces": [
                                    "str"  # Optional. The related Log Analytics
                                      workspaces for the table.
                                ]
                            },
                            "tags": {},  # Optional. The tags associated with the table.
                            "timespanColumn": "str"  # Optional. The column associated
                              with the timespan query parameter for the table.
                        }
                    ],
                    "workspaces": [
                        {
                            "id": "str",  # The ID of the Log Analytics workspace.
                              Required.
                            "name": "str",  # The name of the Log Analytics workspace.
                              Required.
                            "region": "str",  # The Azure region of the Log Analytics
                              workspace. Required.
                            "resourceId": "str",  # The ARM resource ID of the Log
                              Analytics workspace. Required.
                            "related": {
                                "functions": [
                                    "str"  # Optional. The related functions for
                                      the Log Analytics workspace.
                                ],
                                "resourceTypes": [
                                    "str"  # Optional. The related resource types
                                      for the Log Analytics workspace.
                                ],
                                "resources": [
                                    "str"  # Optional. The related Azure
                                      resources for the Log Analytics workspace.
                                ],
                                "solutions": [
                                    "str"  # Optional. The related Log Analytics
                                      solutions for the Log Analytics workspace.
                                ],
                                "tables": [
                                    "str"  # Optional. The related tables for the
                                      Log Analytics workspace.
                                ]
                            }
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        request = build_metadata_post_request(
            workspace_id=workspace_id,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)
