// Copyright (c) 2013-2020, SIB - Swiss Institute of Bioinformatics and
//                          Biozentrum - University of Basel
// 
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// 
//   http://www.apache.org/licenses/LICENSE-2.0
// 
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.


#include <promod3/loop/bb_trace_param.hh>
#include <promod3/core/message.hh>

namespace promod3{ namespace loop{

void BBTraceParam(char olc, Real& n_ca_bond, Real& ca_c_bond,
                  Real& c_n_bond, Real& c_n_ca_angle,
                  Real& n_ca_c_angle, Real& ca_c_n_angle){
  switch(olc){
    case 'A':{
      n_ca_bond = 1.459200;
      ca_c_bond = 1.539000;
      c_n_bond = 1.355800;
      c_n_ca_angle = 2.207667;
      n_ca_c_angle = 1.997355;
      ca_c_n_angle = 2.039243;
      break;
    }
    case 'R':{
      n_ca_bond = 1.454400;
      ca_c_bond = 1.522700;
      c_n_bond = 1.351100;
      c_n_ca_angle = 2.137156;
      n_ca_c_angle = 1.917419;
      ca_c_n_angle = 2.044130;
      break;
    }
    case 'N':{
      n_ca_bond = 1.451000;
      ca_c_bond = 1.524500;
      c_n_bond = 1.346700;
      c_n_ca_angle = 2.165081;
      n_ca_c_angle = 1.836610;
      ca_c_n_angle = 2.048667;
      break;
    }
    case 'D':{
      n_ca_bond = 1.449000;
      ca_c_bond = 1.531500;
      c_n_bond = 1.347800;
      c_n_ca_angle = 2.187072;
      n_ca_c_angle = 1.843591;
      ca_c_n_angle = 2.043082;
      break;
    }
    case 'Q':{
      n_ca_bond = 1.450600;
      ca_c_bond = 1.518000;
      c_n_bond = 1.346300;
      c_n_ca_angle = 2.162987;
      n_ca_c_angle = 1.859997;
      ca_c_n_angle = 2.054602;
      break;
    }
    case 'E':{
      n_ca_bond = 1.451200;
      ca_c_bond = 1.521600;
      c_n_bond = 1.350100;
      c_n_ca_angle = 2.172062;
      n_ca_c_angle = 1.872215;
      ca_c_n_angle = 2.046399;
      break;
    }
    case 'K':{
      n_ca_bond = 1.450400;
      ca_c_bond = 1.518700;
      c_n_bond = 1.347800;
      c_n_ca_angle = 2.156703;
      n_ca_c_angle = 1.872564;
      ca_c_n_angle = 2.046748;
      break;
    }
    case 'S':{
      n_ca_bond = 1.457900;
      ca_c_bond = 1.516600;
      c_n_bond = 1.344800;
      c_n_ca_angle = 2.170666;
      n_ca_c_angle = 1.846733;
      ca_c_n_angle = 2.054602;
      break;
    }
    case 'C':{
      n_ca_bond = 1.453300;
      ca_c_bond = 1.520200;
      c_n_bond = 1.349800;
      c_n_ca_angle = 2.162987;
      n_ca_c_angle = 1.848129;
      ca_c_n_angle = 2.064725;
      break;
    }
    case 'M':{
      n_ca_bond = 1.451000;
      ca_c_bond = 1.519500;
      c_n_bond = 1.347100;
      c_n_ca_angle = 2.167873;
      n_ca_c_angle = 1.855460;
      ca_c_n_angle = 2.054951;
      break;
    }
    case 'W':{
      n_ca_bond = 1.450700;
      ca_c_bond = 1.520200;
      c_n_bond = 1.350500;
      c_n_ca_angle = 2.155656;
      n_ca_c_angle = 1.879545;
      ca_c_n_angle = 2.051984;
      break;
    }
    case 'Y':{
      n_ca_bond = 1.450100;
      ca_c_bond = 1.523200;
      c_n_bond = 1.348400;
      c_n_ca_angle = 2.160892;
      n_ca_c_angle = 1.859125;
      ca_c_n_angle = 2.047795;
      break;
    }
    case 'T':{
      n_ca_bond = 1.460700;
      ca_c_bond = 1.516200;
      c_n_bond = 1.344900;
      c_n_ca_angle = 2.166303;
      n_ca_c_angle = 1.851620;
      ca_c_n_angle = 2.054078;
      break;
    }
    case 'V':{
      n_ca_bond = 1.457000;
      ca_c_bond = 1.518000;
      c_n_bond = 1.347100;
      c_n_ca_angle = 2.174157;
      n_ca_c_angle = 1.842020;
      ca_c_n_angle = 2.056521;
      break;
    }
    case 'I':{
      n_ca_bond = 1.454200;
      ca_c_bond = 1.519000;
      c_n_bond = 1.346500;
      c_n_ca_angle = 2.167001;
      n_ca_c_angle = 1.856158;
      ca_c_n_angle = 2.058965;
      break;
    }
    case 'L':{
      n_ca_bond = 1.450800;
      ca_c_bond = 1.518400;
      c_n_bond = 1.346300;
      c_n_ca_angle = 2.169619;
      n_ca_c_angle = 1.850922;
      ca_c_n_angle = 2.058267;
      break;
    }
    case 'G':{
      n_ca_bond = 1.455300;
      ca_c_bond = 1.497100;
      c_n_bond = 1.347900;
      c_n_ca_angle = 2.143613;
      n_ca_c_angle = 1.901362;
      ca_c_n_angle = 2.052507;
      break;
    }
    case 'P':{
      n_ca_bond = 1.458500;
      ca_c_bond = 1.539900;
      c_n_bond = 1.356900;
      c_n_ca_angle = 2.145708;
      n_ca_c_angle = 1.934872;
      ca_c_n_angle = 2.002765;
      break;
    }
    case 'H':{
      n_ca_bond = 1.453200;
      ca_c_bond = 1.516600;
      c_n_bond = 1.344600;
      c_n_ca_angle = 2.167001;
      n_ca_c_angle = 1.857554;
      ca_c_n_angle = 2.041512;
      break;
    }
    case 'F':{
      n_ca_bond = 1.450400;
      ca_c_bond = 1.522900;
      c_n_bond = 1.348300;
      c_n_ca_angle = 2.162288;
      n_ca_c_angle = 1.856681;
      ca_c_n_angle = 2.053380;
      break;
    }
    default:{
      throw promod3::Error("Invalid OneLetterCode observed!");
    }
  }
}

}}
