/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules.migration;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.ast.ASTCastExpression;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.ast.ASTLocalVariableDeclaration;
import net.sourceforge.pmd.ast.ASTName;
import net.sourceforge.pmd.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.symboltable.NameOccurrence;

public class UnnecessaryCast
extends AbstractRule {
    private static Set<String> implClassNames = new HashSet<String>();

    public Object visit(ASTLocalVariableDeclaration node, Object data) {
        return this.process(node, data);
    }

    public Object visit(ASTFieldDeclaration node, Object data) {
        return this.process(node, data);
    }

    private Object process(SimpleNode node, Object data) {
        ASTClassOrInterfaceType cit = node.getFirstChildOfType(ASTClassOrInterfaceType.class);
        if (cit == null || !implClassNames.contains(cit.getImage())) {
            return data;
        }
        if ((cit = cit.getFirstChildOfType(ASTClassOrInterfaceType.class)) == null) {
            return data;
        }
        ASTVariableDeclaratorId decl = node.getFirstChildOfType(ASTVariableDeclaratorId.class);
        List<NameOccurrence> usages = decl.getUsages();
        for (NameOccurrence no : usages) {
            ASTName name = (ASTName)no.getLocation();
            SimpleNode n = (SimpleNode)name.jjtGetParent().jjtGetParent().jjtGetParent();
            if (!ASTCastExpression.class.equals(n.getClass())) continue;
            this.addViolation(data, n);
        }
        return null;
    }

    static {
        implClassNames.add("List");
        implClassNames.add("Set");
        implClassNames.add("Map");
        implClassNames.add("java.util.List");
        implClassNames.add("java.util.Set");
        implClassNames.add("java.util.Map");
        implClassNames.add("ArrayList");
        implClassNames.add("HashSet");
        implClassNames.add("HashMap");
        implClassNames.add("LinkedHashMap");
        implClassNames.add("LinkedHashSet");
        implClassNames.add("TreeSet");
        implClassNames.add("TreeMap");
        implClassNames.add("Vector");
        implClassNames.add("java.util.ArrayList");
        implClassNames.add("java.util.HashSet");
        implClassNames.add("java.util.HashMap");
        implClassNames.add("java.util.LinkedHashMap");
        implClassNames.add("java.util.LinkedHashSet");
        implClassNames.add("java.util.TreeSet");
        implClassNames.add("java.util.TreeMap");
        implClassNames.add("java.util.Vector");
    }
}

