/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.ast;

import net.sourceforge.pmd.ast.AccessNodeInterface;
import net.sourceforge.pmd.ast.JavaParser;
import net.sourceforge.pmd.ast.SimpleJavaNode;

public class SimpleJavaAccessNode
extends SimpleJavaNode
implements AccessNodeInterface {
    private int modifiers;

    public SimpleJavaAccessNode(int i) {
        super(i);
    }

    public SimpleJavaAccessNode(JavaParser parser, int i) {
        super(parser, i);
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public void setModifiers(int modifiers) {
        this.modifiers = modifiers;
    }

    public boolean isPublic() {
        return this.isModifier(1);
    }

    public void setPublic() {
        this.setPublic(true);
    }

    public void setPublic(boolean isPublic) {
        this.setModifier(isPublic, 1);
    }

    public boolean isProtected() {
        return this.isModifier(2);
    }

    public void setProtected() {
        this.setProtected(true);
    }

    public void setProtected(boolean isProtected) {
        this.setModifier(isProtected, 2);
    }

    public boolean isPrivate() {
        return this.isModifier(4);
    }

    public void setPrivate() {
        this.setPrivate(true);
    }

    public void setPrivate(boolean isPrivate) {
        this.setModifier(isPrivate, 4);
    }

    public boolean isAbstract() {
        return this.isModifier(8);
    }

    public void setAbstract() {
        this.setAbstract(true);
    }

    public void setAbstract(boolean isAbstract) {
        this.setModifier(isAbstract, 8);
    }

    public boolean isStatic() {
        return this.isModifier(16);
    }

    public void setStatic() {
        this.setStatic(true);
    }

    public void setStatic(boolean isStatic) {
        this.setModifier(isStatic, 16);
    }

    public boolean isFinal() {
        return this.isModifier(32);
    }

    public void setFinal() {
        this.setFinal(true);
    }

    public void setFinal(boolean isFinal) {
        this.setModifier(isFinal, 32);
    }

    public boolean isSynchronized() {
        return this.isModifier(64);
    }

    public void setSynchronized() {
        this.setSynchronized(true);
    }

    public void setSynchronized(boolean isSynchronized) {
        this.setModifier(isSynchronized, 64);
    }

    public boolean isNative() {
        return this.isModifier(128);
    }

    public void setNative() {
        this.setNative(true);
    }

    public void setNative(boolean isNative) {
        this.setModifier(isNative, 128);
    }

    public boolean isTransient() {
        return this.isModifier(256);
    }

    public void setTransient() {
        this.setTransient(true);
    }

    public void setTransient(boolean isTransient) {
        this.setModifier(isTransient, 256);
    }

    public boolean isVolatile() {
        return this.isModifier(512);
    }

    public void setVolatile() {
        this.setVolatile(true);
    }

    public void setVolatile(boolean isVolative) {
        this.setModifier(isVolative, 512);
    }

    public boolean isStrictfp() {
        return this.isModifier(4096);
    }

    public void setStrictfp() {
        this.setStrictfp(true);
    }

    public void setStrictfp(boolean isStrictfp) {
        this.setModifier(isStrictfp, 4096);
    }

    private final boolean isModifier(int mask) {
        return (this.modifiers & mask) == mask;
    }

    private void setModifier(boolean enable, int mask) {
        this.modifiers = enable ? (this.modifiers |= mask) : (this.modifiers &= ~mask);
    }

    public boolean isPackagePrivate() {
        return !this.isPrivate() && !this.isPublic() && !this.isProtected();
    }

    public String collectDumpedModifiers(String prefix) {
        String out = this.toString(prefix) + ":";
        if (this.isPackagePrivate()) {
            out = out + "(package private)";
        }
        if (this.isPrivate()) {
            out = out + "(private)";
        }
        if (this.isPublic()) {
            out = out + "(public)";
        }
        if (this.isProtected()) {
            out = out + "(protected)";
        }
        if (this.isAbstract()) {
            out = out + "(abstract)";
        }
        if (this.isStatic()) {
            out = out + "(static)";
        }
        if (this.isFinal()) {
            out = out + "(final)";
        }
        if (this.isSynchronized()) {
            out = out + "(synchronized)";
        }
        if (this.isNative()) {
            out = out + "(native)";
        }
        if (this.isStrictfp()) {
            out = out + "(strict)";
        }
        if (this.isTransient()) {
            out = out + "(transient)";
        }
        return out;
    }
}

