!--
! *** Caution!! ***
! 
! This file is generated from "sysdeparg.rb2f90" by Ruby 1.8.5.
! Please do not edit this file directly.
!
! [JAPANESE]
!
! ※※※ 注意!!! ※※※
!
! このファイルは "sysdeparg.rb2f90" から Ruby 1.8.5
! によって自動生成されたファイルです.
! このファイルを直接編集しませんようお願い致します.
!
!
!++
!
!== SysdepArg - 環境依存性ルーチン (コマンドライン取得)
!
! Authors::   Eizi TOYODA, Yasuhiro MORIKAWA
! Version::   $Id: sysdeparg-nostd.f90,v 1.1 2009-03-20 09:09:49 morikawa Exp $
! Tag Name::  $Name:  $
! Copyright:: Copyright (C) GFD Dennou Club, 2000-2005. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
! Fortran 95 以前の大抵の処理系では IARGC, GETARG というサービスサブルーチンが
! 用意されている (これらは Fortran90/95 の規格には含まれていない). 
! Fortran 2003 規格には COMMAND_ARGUMENT_COUNT, GET_COMMAND_ARGUMENT
! というサブルーチンが規定されている. 
! これを使えない処理系では適宜対処が必要である。
! 日立コンパイラでは上記サービスサブルーチンの挙動が違うので注意。
!

integer function SysdepArgCount() result(result)
  !
  ! この手続きは, コマンドライン引数の数を返します. 
  ! F95 以前の処理系では Fortran90/95 規格外の <b>IARGC()</b>
  ! 関数により実装され, F2003 に対応する処理系では 
  ! COMMAND_ARGUMENT_COUNT 関数によって実装されます. 
  !
  ! Get the number of commandline arguments.
  ! In F95, it is implemented by nonstandard built-in
  ! function <b>IARGC()</b>. 
  ! In F2003, it is implemented by standard built-in
  ! function <b>COMMAND_ARGUMENT_COUNT()</b>. 
  !
  implicit none
  !
  ! Selected by Makefile using Ruby
  !
  interface
    integer function iargc()
    end function iargc
  end interface
  result = iargc()
end function SysdepArgCount

subroutine SysdepArgGet(idx_given, result)
  !
  ! この手続きはコマンドライン引数のうち、*index* (*idx_given*)
  ! 番目の値を *value* (*result*) に返します。
  !
  ! *index* が引数の数よりも大きい場合、*value* には空文字
  ! が返ります。*index* が負の場合には、後方からの順番になります。
  ! すなわち、-1 ならば最後の引数が返ります。
  !
  ! ほとんどの処理系では Fortran90/95 規格外の <b>GETARGC()</b>
  ! 関数により実装されます。
  !
  ! gets the *index*th (*idx_given*th) commandline argument
  ! to *value* (*result*).
  !
  ! If *index* is more than the number of arguments,
  ! *value* will be filled with blank.
  ! If *index* is negative, *index*th argument in reverse
  ! is return to *value*. In other words, if *index* = -1,
  ! the last argument is returned.
  !
  ! Most typically, it is implemented by nonstandard built-in
  ! subroutine <b>GETARG()</b>.
  !
  implicit none
  integer, intent(in):: idx_given
  character(len = *), intent(out):: result
  integer:: idx
  integer:: argc
  interface
    integer function SysdepArgCount()
    end function SysdepArgCount
  end interface
continue
  argc = SysdepArgCount()
  if (idx_given < 0) then
    idx = argc + 1 + idx_given
  else
    idx = idx_given
  endif
  if (idx > argc) then
    result = ""
  else
  !
  ! Selected by Makefile using Ruby
  !
  call getarg(idx, result)
  endif
end subroutine SysdepArgGet

!--
! vi:set readonly sw=4 ts=8:
!
!Local Variables:
!mode: f90
!buffer-read-only: t
!End:
!
!++
