/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.adde;

import edu.wisc.ssec.mcidas.adde.AddeException;
import edu.wisc.ssec.mcidas.adde.AddePointDataReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
import thredds.catalog.InvAccess;
import thredds.catalog.InvDataset;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.ThreddsMetadata;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.ma2.StructureData;
import ucar.ma2.StructureMembers;
import ucar.nc2.Attribute;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.dt.DataIterator;
import ucar.nc2.dt.point.StationObsDatasetImpl;
import ucar.nc2.dt.point.StationObsDatatypeImpl;
import ucar.nc2.iosp.adde.ArrayStructureAdde;
import ucar.nc2.iosp.adde.StationDB;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.units.DateRange;
import ucar.nc2.units.DateUnit;
import ucar.nc2.util.CancelTask;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.Station;
import visad.jmet.MetUnits;

public class AddeStationObsDataset
extends StationObsDatasetImpl {
    private String addeURL;
    private StationDB stationDB;
    private String stationDBlocation;
    private GregorianCalendar calendar;
    private double[] scaleFactor;
    private StructureMembers members;
    private boolean debugHead = false;
    private boolean debugAddeCall = false;

    static AddePointDataReader callAdde(String request) throws IOException {
        try {
            System.out.println("Call ADDE request= " + request);
            long start = System.currentTimeMillis();
            AddePointDataReader reader = new AddePointDataReader(request);
            System.out.println(" took= " + (System.currentTimeMillis() - start) + " msec");
            return reader;
        }
        catch (AddeException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
    }

    public AddeStationObsDataset(InvAccess access, CancelTask cancelTask) throws IOException {
        InvDataset invDs = access.getDataset();
        this.location = invDs.getID() != null ? "thredds:" + access.getDataset().getCatalogUrl() : access.getStandardUrlName();
        this.addeURL = access.getStandardUrlName();
        InvDataset invds = access.getDataset();
        String pv = invds.findProperty("_StationDBlocation");
        if (pv != null) {
            this.stationDBlocation = InvDatasetImpl.resolve(invds, pv);
        }
        this.init();
        ThreddsMetadata.GeospatialCoverage geoCoverage = invds.getGeospatialCoverage();
        this.boundingBox = null != geoCoverage ? geoCoverage.getBoundingBox() : this.stationHelper.getBoundingBox();
        CalendarDateRange timeCoverage = invds.getCalendarDateCoverage();
        if (timeCoverage != null) {
            DateRange dr = timeCoverage.toDateRange();
            this.startDate = dr.getStart().getDate();
            this.endDate = dr.getEnd().getDate();
        } else {
            this.startDate = new Date(0L);
            this.endDate = new Date();
        }
    }

    public AddeStationObsDataset(String location, CancelTask cancelTask) throws IOException {
        this.location = location;
        this.addeURL = location;
        this.init();
        this.startDate = new Date(0L);
        this.endDate = new Date();
        this.boundingBox = this.stationHelper.getBoundingBox();
    }

    private void init() throws IOException {
        this.members = new StructureMembers("stationObs");
        this.calendar = new GregorianCalendar();
        this.calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.timeUnit = DateUnit.getUnixDateUnit();
        try {
            AddePointDataReader reader = AddeStationObsDataset.callAdde(this.addeURL);
            String[] params = reader.getParams();
            String[] units = reader.getUnits();
            int[] scales = reader.getScales();
            this.scaleFactor = new double[params.length];
            if (this.debugHead) {
                System.out.println(" Param  Unit Scale");
            }
            for (int paramNo = 0; paramNo < params.length; ++paramNo) {
                if (this.debugHead) {
                    System.out.println(" " + params[paramNo] + " " + units[paramNo] + " " + scales[paramNo]);
                }
                if (scales[paramNo] != 0) {
                    this.scaleFactor[paramNo] = 1.0 / Math.pow(10.0, scales[paramNo]);
                }
                DataType dt = null;
                dt = "CHAR".equals(units[paramNo]) ? DataType.STRING : (this.scaleFactor[paramNo] == 0.0 ? DataType.INT : DataType.DOUBLE);
                String unitString = null;
                if (units[paramNo] != null && units[paramNo].length() > 0) {
                    unitString = MetUnits.makeSymbol((String)units[paramNo]);
                }
                AddeTypedDataVariable tdv = new AddeTypedDataVariable(params[paramNo], unitString, dt);
                this.dataVariables.add(tdv);
                StructureMembers.Member m = this.members.addMember(tdv.getShortName(), tdv.getDescription(), tdv.getUnitsString(), tdv.getDataType(), tdv.getShape());
                m.setDataParam(paramNo);
                this.members.addMember(m);
            }
        }
        catch (AddeException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
    }

    @Override
    protected void setTimeUnits() {
    }

    @Override
    protected void setStartDate() {
    }

    @Override
    protected void setEndDate() {
    }

    @Override
    protected void setBoundingBox() {
    }

    private ArrayStructureAdde readData(String selectClause, CancelTask cancel) {
        try {
            String urlString = selectClause == null ? this.addeURL + "&num=all" : this.addeURL + "&num=all&select='" + selectClause + "'";
            AddePointDataReader reader = AddeStationObsDataset.callAdde(urlString);
            int[][] stationObsData = reader.getData();
            int nparams = stationObsData.length;
            int nobs = stationObsData[0].length;
            if (this.debugAddeCall) {
                System.out.println("CALL ADDE= " + urlString);
                System.out.println(" nparams= " + nparams + " nobs=" + nobs);
                System.out.println(" size= " + nparams * nobs * 4 + " bytes");
            }
            return new ArrayStructureAdde(this.members, new int[]{nobs}, stationObsData, this.scaleFactor);
        }
        catch (AddeException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    public List getStations(CancelTask cancel) throws IOException {
        if (this.stationDB == null) {
            this.readStations(cancel);
        }
        return this.stationDB.getStations();
    }

    @Override
    public int getStationDataCount(Station s) {
        return -1;
    }

    @Override
    public List getData(CancelTask cancel) throws IOException {
        return null;
    }

    @Override
    public int getDataCount() {
        return -1;
    }

    @Override
    public List getData(Station s, CancelTask cancel) throws IOException {
        ArrayStructureAdde stationData = this.readData("ID " + s.getName(), cancel);
        ArrayList<StationObs> stationObs = new ArrayList<StationObs>();
        IndexIterator ii = stationData.getIndexIterator();
        while (ii.hasNext()) {
            stationObs.add(new StationObs(s, (StructureData)ii.getObjectNext()));
        }
        return stationObs;
    }

    @Override
    public List getData(Station s, Date start, Date end, CancelTask cancel) throws IOException {
        double startTime = this.timeUnit.makeValue(start);
        double endTime = this.timeUnit.makeValue(end);
        return this.stationHelper.getStationObs(s, startTime, endTime, cancel);
    }

    public List getData(List stations, CancelTask cancel) throws IOException {
        return this.stationHelper.getStationObs(stations, cancel);
    }

    public List getData(List stations, Date start, Date end, CancelTask cancel) throws IOException {
        double startTime = this.timeUnit.makeValue(start);
        double endTime = this.timeUnit.makeValue(end);
        return this.stationHelper.getStationObs(stations, startTime, endTime, cancel);
    }

    @Override
    public List getData(LatLonRect boundingBox, CancelTask cancel) throws IOException {
        return this.stationHelper.getStationObs(boundingBox, cancel);
    }

    @Override
    public List getData(LatLonRect boundingBox, Date start, Date end, CancelTask cancel) throws IOException {
        double startTime = this.timeUnit.makeValue(start);
        double endTime = this.timeUnit.makeValue(end);
        return this.stationHelper.getStationObs(boundingBox, startTime, endTime, cancel);
    }

    private static void makeSelectBB(StringBuffer sbuff, LatLonRect bb) {
        LatLonPointImpl ll = bb.getLowerLeftPoint();
        LatLonPointImpl ur = bb.getUpperRightPoint();
        sbuff.append("LAT ");
        sbuff.append(ll.getLatitude());
        sbuff.append(" ");
        sbuff.append(ur.getLatitude());
        sbuff.append(";LON ");
        sbuff.append(ll.getLongitude());
        sbuff.append(" ");
        sbuff.append(ur.getLongitude());
    }

    private void makeSelectTime(StringBuffer sbuff, Date begin, Date end) {
        sbuff.append("DAY ");
    }

    private void makeSelectStations(StringBuffer sbuff, List stations) {
        sbuff.append("ID ");
        for (int i = 0; i < stations.size(); ++i) {
            Station s = (Station)stations.get(i);
            if (i > 0) {
                sbuff.append(",");
            }
            sbuff.append(s.getName());
        }
    }

    private void readStations(CancelTask cancel) throws IOException {
        try {
            if (this.stationDBlocation != null) {
                this.stationDB = new StationDB(this.stationDBlocation);
            }
        }
        catch (IOException ioe) {
            System.out.println("++ AddeStationDataset cant find stationDBlocation= " + this.stationDBlocation);
        }
        if (this.stationDB == null) {
            this.stationDB = new StationDB(this.location, cancel);
        }
    }

    static void test(String urlString) {
        try {
            long start = System.currentTimeMillis();
            System.out.println(" get " + urlString);
            AddePointDataReader reader = new AddePointDataReader(urlString);
            System.out.println(" took= " + (System.currentTimeMillis() - start) + " msec");
            System.out.println(reader.toString());
            System.out.println(" Param  Unit Scale");
            String[] params = reader.getParams();
            String[] units = reader.getUnits();
            int[] scales = reader.getScales();
            for (int i = 0; i < params.length; ++i) {
                System.out.println(" " + params[i] + " " + units[i] + " " + scales[i]);
            }
            int[][] data = reader.getData();
            System.out.println(" nparams= " + params.length);
            System.out.println(" n= " + data.length);
            System.out.println(" m= " + data[0].length);
        }
        catch (AddeException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        String loc = "adde://adde.ucar.edu/point?group=rtptsrc&descr=sfchourly&num=10";
        StringBuffer sbuff = new StringBuffer();
        sbuff.append(loc);
        sbuff.append("&num=all&select='");
        AddeStationObsDataset.makeSelectBB(sbuff, new LatLonRect(new LatLonPointImpl(10.0, 10.0), new LatLonPointImpl(20.0, 20.0)));
        sbuff.append("'");
        AddeStationObsDataset.test(sbuff.toString());
        try {
            AddeStationObsDataset ads = new AddeStationObsDataset(loc, null);
            System.out.println(loc + " =\n" + ads);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public DataIterator getDataIterator(int bufferSize) throws IOException {
        return null;
    }

    private class StationObs
    extends StationObsDatatypeImpl {
        private StructureData data;

        StationObs(Station s, StructureData data) {
            this.station = s;
            this.data = data;
            int cyd = data.getScalarInt("DAY");
            int year = cyd / 1000;
            int doy = cyd % 1000;
            int hms = data.getScalarInt("TIME");
            int hour = hms / 10000;
            int min = (hms %= 10000) / 100;
            int sec = hms % 100;
            AddeStationObsDataset.this.calendar.clear();
            AddeStationObsDataset.this.calendar.set(1, year);
            AddeStationObsDataset.this.calendar.set(6, doy);
            AddeStationObsDataset.this.calendar.set(11, hour);
            AddeStationObsDataset.this.calendar.set(12, min);
            AddeStationObsDataset.this.calendar.set(13, sec);
            this.nomTime = this.obsTime = (double)AddeStationObsDataset.this.calendar.getTimeInMillis() / 1000.0;
        }

        @Override
        public StructureData getData() throws IOException {
            return this.data;
        }

        @Override
        public Date getNominalTimeAsDate() {
            return AddeStationObsDataset.this.timeUnit.makeDate(this.getNominalTime());
        }

        @Override
        public Date getObservationTimeAsDate() {
            return AddeStationObsDataset.this.timeUnit.makeDate(this.getObservationTime());
        }
    }

    private class AddeTypedDataVariable
    implements VariableSimpleIF {
        String name;
        String units;
        DataType dt;

        AddeTypedDataVariable(String name, String units, DataType dt) {
            this.name = name;
            this.units = units;
            this.dt = dt;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getFullName() {
            return this.name;
        }

        @Override
        public String getShortName() {
            return this.name;
        }

        @Override
        public String getDescription() {
            return null;
        }

        @Override
        public String getUnitsString() {
            return this.units;
        }

        @Override
        public int getRank() {
            return 0;
        }

        @Override
        public int[] getShape() {
            return new int[0];
        }

        public List getDimensions() {
            return new ArrayList();
        }

        @Override
        public DataType getDataType() {
            return this.dt;
        }

        public List getAttributes() {
            return new ArrayList();
        }

        @Override
        public Attribute findAttributeIgnoreCase(String name) {
            return null;
        }

        @Override
        public int compareTo(VariableSimpleIF o) {
            return this.getShortName().compareTo(o.getShortName());
        }
    }
}

