/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.writer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ucar.ma2.Array;
import ucar.ma2.ArrayDouble;
import ucar.ma2.ArrayInt;
import ucar.ma2.ArrayObject;
import ucar.ma2.ArrayStructureW;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.StructureData;
import ucar.ma2.StructureMembers;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFileWriter;
import ucar.nc2.Variable;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.constants.CF;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.ft.FeatureDataset;
import ucar.nc2.ft.FeatureDatasetFactoryManager;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.point.writer.CFPointWriter;
import ucar.nc2.ft.point.writer.CFPointWriterUtils;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.units.DateUnit;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.Station;

public class WriterCFStationCollection
extends CFPointWriter {
    private static final String stationDimName = "station";
    private static final String idName = "station_id";
    private static final String descName = "station_description";
    private static final String wmoName = "wmo_id";
    private static final String stationIndexName = "stationIndex";
    private static final boolean debug = false;
    private int name_strlen = 1;
    private int desc_strlen = 1;
    private int wmo_strlen = 1;
    private Variable lat;
    private Variable lon;
    private Variable alt;
    private Variable time;
    private Variable id;
    private Variable wmoId;
    private Variable desc;
    private Variable stationIndex;
    private Variable record;
    private List<Dimension> stationDims = new ArrayList<Dimension>(1);
    private Dimension recordDim;
    private boolean useAlt = false;
    private boolean useWmoId = false;
    int countDim = 0;
    private final Map<String, Dimension> gdimHash = new HashMap<String, Dimension>();
    private HashMap<String, Integer> stationMap;
    private int recno = 0;
    private ArrayDouble.D1 timeArray = new ArrayDouble.D1(1);
    private ArrayInt.D1 parentArray = new ArrayInt.D1(1);
    private int[] origin = new int[1];

    public WriterCFStationCollection(String fileOut, String title) throws IOException {
        this(null, fileOut, Arrays.asList(new Attribute("title", title)));
    }

    public WriterCFStationCollection(NetcdfFileWriter.Version version, String fileOut, List<Attribute> atts) throws IOException {
        super(fileOut, atts, version);
        this.writer.addGroupAttribute(null, new Attribute("featureType", CF.FeatureType.timeSeries.name()));
    }

    public void writeHeader(List<Station> stns, List<VariableSimpleIF> vars, DateUnit timeUnit, String altUnits) throws IOException {
        this.altUnits = altUnits;
        this.createStations(stns);
        this.createCoordVariables(timeUnit);
        this.createDataVariables(vars);
        this.writer.create();
        this.record = this.writer.addRecordStructure();
        this.writeStationData(stns);
    }

    private void createStations(List<Station> stnList) throws IOException {
        int nstns = stnList.size();
        for (Station stn : stnList) {
            if (!Double.isNaN(stn.getAltitude())) {
                this.useAlt = true;
            }
            if (stn.getWmoId() == null || stn.getWmoId().trim().length() <= 0) continue;
            this.useWmoId = true;
        }
        for (Station station : stnList) {
            this.name_strlen = Math.max(this.name_strlen, station.getName().length());
            this.desc_strlen = Math.max(this.desc_strlen, station.getDescription().length());
            if (!this.useWmoId) continue;
            this.wmo_strlen = Math.max(this.wmo_strlen, station.getWmoId().length());
        }
        this.llbb = this.getBoundingBox(stnList);
        this.recordDim = this.writer.addUnlimitedDimension("obs");
        Dimension stationDim = this.writer.addDimension(null, stationDimName, nstns);
        this.stationDims.add(stationDim);
        this.lat = this.writer.addVariable(null, "latitude", DataType.DOUBLE, stationDimName);
        this.writer.addVariableAttribute(this.lat, new Attribute("units", "degrees_north"));
        this.writer.addVariableAttribute(this.lat, new Attribute("long_name", "station latitude"));
        this.lon = this.writer.addVariable(null, "longitude", DataType.DOUBLE, stationDimName);
        this.writer.addVariableAttribute(this.lon, new Attribute("units", "degrees_east"));
        this.writer.addVariableAttribute(this.lon, new Attribute("long_name", "station longitude"));
        if (this.useAlt) {
            this.alt = this.writer.addVariable(null, "altitude", DataType.DOUBLE, stationDimName);
            this.writer.addVariableAttribute(this.alt, new Attribute("units", "meters"));
            this.writer.addVariableAttribute(this.alt, new Attribute("positive", "up"));
            this.writer.addVariableAttribute(this.alt, new Attribute("long_name", "station altitude"));
            this.writer.addVariableAttribute(this.alt, new Attribute("standard_name", "surface_altitude"));
        }
        this.id = this.writer.addStringVariable(null, idName, this.stationDims, this.name_strlen);
        this.writer.addVariableAttribute(this.id, new Attribute("long_name", "station identifier"));
        this.writer.addVariableAttribute(this.id, new Attribute("cf_role", "timeseries_id"));
        this.desc = this.writer.addStringVariable(null, descName, this.stationDims, this.desc_strlen);
        this.writer.addVariableAttribute(this.desc, new Attribute("long_name", "station description"));
        this.writer.addVariableAttribute(this.desc, new Attribute("standard_name", "platform_name"));
        if (this.useWmoId) {
            this.wmoId = this.writer.addStringVariable(null, wmoName, this.stationDims, this.wmo_strlen);
            this.writer.addVariableAttribute(this.wmoId, new Attribute("long_name", "station WMO id"));
            this.writer.addVariableAttribute(this.wmoId, new Attribute("standard_name", "platform_id"));
        }
    }

    private void createCoordVariables(DateUnit timeUnit) throws IOException {
        this.time = this.writer.addVariable(null, "time", DataType.DOUBLE, "obs");
        this.writer.addVariableAttribute(this.time, new Attribute("units", timeUnit.getUnitsString()));
        this.writer.addVariableAttribute(this.time, new Attribute("long_name", "time of measurement"));
        this.stationIndex = this.writer.addVariable(null, stationIndexName, DataType.INT, "obs");
        this.writer.addVariableAttribute(this.stationIndex, new Attribute("long_name", "station index for this observation record"));
        this.writer.addVariableAttribute(this.stationIndex, new Attribute("instance_dimension", stationDimName));
    }

    private void createDataVariables(List<VariableSimpleIF> dataVars) throws IOException {
        String coordNames = "latitude longitude altitude time";
        if (!this.useAlt) {
            coordNames = "latitude longitude time";
        }
        ArrayList<VariableSimpleIF> useDataVars = new ArrayList<VariableSimpleIF>(dataVars.size());
        for (VariableSimpleIF var : dataVars) {
            if (this.writer.findVariable(var.getShortName()) != null) continue;
            useDataVars.add(var);
        }
        for (VariableSimpleIF oldVar : useDataVars) {
            List<Dimension> dims = this.getNewDimensions(oldVar);
            dims.add(0, this.recordDim);
            Variable newVar = oldVar.getDataType().equals((Object)DataType.STRING) ? this.writer.addStringVariable(null, oldVar.getShortName(), dims, 10) : this.writer.addVariable(null, oldVar.getShortName(), oldVar.getDataType(), dims);
            List<Attribute> atts = oldVar.getAttributes();
            for (Attribute att : atts) {
                if (reservedVariableAtts.contains(att.getShortName())) continue;
                newVar.addAttribute(att);
            }
            newVar.addAttribute(new Attribute("coordinates", coordNames));
        }
    }

    private List<Dimension> getNewDimensions(VariableSimpleIF oldVar) {
        ArrayList<Dimension> result = new ArrayList<Dimension>(oldVar.getRank());
        for (Dimension oldD : oldVar.getDimensions()) {
            Dimension newD = this.gdimHash.get(oldD.getShortName());
            if (newD != null) continue;
            if (oldD.isShared()) {
                newD = this.writer.addDimension(null, oldD.getShortName(), oldD.isUnlimited() ? 0 : oldD.getLength(), oldD.isShared(), oldD.isUnlimited(), oldD.isVariableLength());
                this.gdimHash.put(oldD.getShortName(), newD);
                result.add(newD);
                continue;
            }
            String dimName = oldVar.getDataType() == DataType.CHAR ? oldVar.getShortName() + "_strlen" : "dim" + this.countDim++;
            newD = this.writer.addDimension(null, dimName, oldD.isUnlimited() ? 0 : oldD.getLength());
            this.gdimHash.put(dimName, newD);
            result.add(newD);
        }
        return result;
    }

    private void writeStationData(List<Station> stnList) throws IOException {
        int nstns = stnList.size();
        this.stationMap = new HashMap(2 * nstns);
        ArrayDouble.D1 latArray = new ArrayDouble.D1(nstns);
        ArrayDouble.D1 lonArray = new ArrayDouble.D1(nstns);
        ArrayDouble.D1 altArray = new ArrayDouble.D1(nstns);
        ArrayObject.D1 idArray = new ArrayObject.D1(String.class, nstns);
        ArrayObject.D1 descArray = new ArrayObject.D1(String.class, nstns);
        ArrayObject.D1 wmoArray = new ArrayObject.D1(String.class, nstns);
        for (int i = 0; i < stnList.size(); ++i) {
            Station stn = stnList.get(i);
            this.stationMap.put(stn.getName(), i);
            latArray.set(i, stn.getLatitude());
            lonArray.set(i, stn.getLongitude());
            if (this.useAlt) {
                altArray.set(i, stn.getAltitude());
            }
            idArray.set(i, stn.getName());
            descArray.set(i, stn.getDescription());
            if (!this.useWmoId) continue;
            wmoArray.set(i, stn.getWmoId());
        }
        try {
            this.writer.write(this.lat, latArray);
            this.writer.write(this.lon, lonArray);
            if (this.useAlt) {
                this.writer.write(this.alt, altArray);
            }
            this.writer.writeStringData(this.id, idArray);
            this.writer.writeStringData(this.desc, descArray);
            if (this.useWmoId) {
                this.writer.writeStringData(this.wmoId, wmoArray);
            }
        }
        catch (InvalidRangeException e) {
            e.printStackTrace();
            throw new IllegalStateException(e);
        }
    }

    public void writeRecord(Station s, PointFeature sobs, StructureData sdata) throws IOException {
        this.writeRecord(s.getName(), sobs.getObservationTime(), sobs.getObservationTimeAsCalendarDate(), sdata);
    }

    public void writeRecord(String stnName, double timeCoordValue, CalendarDate obsDate, StructureData sdata) throws IOException {
        this.trackBB(null, obsDate);
        Integer parentIndex = this.stationMap.get(stnName);
        if (parentIndex == null) {
            throw new RuntimeException("Cant find station " + stnName);
        }
        ArrayStructureW sArray = new ArrayStructureW(sdata.getStructureMembers(), new int[]{1});
        sArray.setStructureData(sdata, 0);
        this.timeArray.set(0, timeCoordValue);
        this.parentArray.set(0, (int)parentIndex);
        this.origin[0] = this.recno++;
        try {
            this.writer.write(this.record, this.origin, sArray);
            this.writer.write(this.time, this.origin, this.timeArray);
            this.writer.write(this.stationIndex, this.origin, this.parentArray);
        }
        catch (InvalidRangeException e) {
            e.printStackTrace();
            throw new IllegalStateException(e);
        }
    }

    public void writeStructure(Station s, PointFeature sobs, StructureData sdata) throws IOException {
        String stnName = s.getName();
        double timeCoordValue = sobs.getObservationTime();
        CalendarDate obsDate = sobs.getNominalTimeAsCalendarDate();
        this.trackBB(null, obsDate);
        Integer parentIndex = this.stationMap.get(stnName);
        if (parentIndex == null) {
            throw new RuntimeException("Cant find station " + stnName);
        }
        ArrayStructureW sArray = new ArrayStructureW(sdata.getStructureMembers(), new int[]{1});
        sArray.setStructureData(sdata, 0);
        this.timeArray.set(0, timeCoordValue);
        this.parentArray.set(0, (int)parentIndex);
        this.origin[0] = this.recno;
        try {
            this.writer.write(this.time, this.origin, this.timeArray);
            this.writer.write(this.stationIndex, this.origin, this.parentArray);
            StructureMembers sm = sdata.getStructureMembers();
            for (StructureMembers.Member m : sm.getMembers()) {
                Variable v = this.writer.findVariable(m.getName());
                if (v == null || v.getDataType() == DataType.CHAR || !v.getDimensionsString().equals("obs")) continue;
                Array arr = CFPointWriterUtils.getArrayFromMember(v, m);
                this.writer.write(v, this.origin, arr);
            }
        }
        catch (InvalidRangeException e) {
            e.printStackTrace();
            throw new IllegalStateException(e);
        }
        ++this.recno;
    }

    private LatLonRect getBoundingBox(List stnList) {
        Station s = (Station)stnList.get(0);
        LatLonPointImpl llpt = new LatLonPointImpl();
        llpt.set(s.getLatitude(), s.getLongitude());
        LatLonRect rect = new LatLonRect(llpt, 0.001, 0.001);
        for (int i = 1; i < stnList.size(); ++i) {
            s = (Station)stnList.get(i);
            llpt.set(s.getLatitude(), s.getLongitude());
            rect.extend(llpt);
        }
        return rect;
    }

    public static void main(String[] args) throws IOException {
        long start = System.currentTimeMillis();
        String outputFile = "G:/work/manross/split/872d794d.bufr.nc";
        String fDataset = "G:/work/manross/split/872d794d.bufr";
        System.out.println("WriterCFStationCollection from " + fDataset + " to " + outputFile);
        Formatter out = new Formatter();
        FeatureDataset fdataset = FeatureDatasetFactoryManager.open(FeatureType.ANY_POINT, fDataset, null, out);
        if (fdataset == null) {
            System.out.printf("**failed on %s %n --> %s %n", fDataset, out);
            assert (false);
        }
        assert (fdataset instanceof FeatureDatasetPoint);
        FeatureDatasetPoint fdpoint = (FeatureDatasetPoint)fdataset;
        int count = CFPointWriter.writeFeatureCollection(fdpoint, outputFile, null);
        System.out.printf(" nrecords written = %d%n%n", count);
        long took = System.currentTimeMillis() - start;
        System.out.println("That took = " + took);
    }
}

