/*
 * Decompiled with CFR 0.152.
 */
package ucar.ma2;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Formatter;
import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.ArrayObject;
import ucar.ma2.ArraySequence;
import ucar.ma2.ArrayStructureW;
import ucar.ma2.DataType;
import ucar.ma2.ForbiddenConversionException;
import ucar.ma2.Index;
import ucar.ma2.IndexIterator;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.ma2.StructureMembers;
import ucar.nc2.util.Indent;

public abstract class ArrayStructure
extends Array {
    protected StructureMembers members;
    protected int nelems;
    protected StructureData[] sdata;

    protected ArrayStructure(StructureMembers members, int[] shape) {
        super(shape);
        this.members = members;
        this.nelems = (int)this.indexCalc.getSize();
    }

    protected ArrayStructure(StructureMembers members, Index ima) {
        super(ima);
        this.members = members;
        this.nelems = (int)this.indexCalc.getSize();
    }

    @Override
    protected void copyFrom1DJavaArray(IndexIterator iter, Object javaArray) {
        Object[] ja;
        for (Object aJa : ja = (Object[])javaArray) {
            iter.setObjectNext(aJa);
        }
    }

    @Override
    protected void copyTo1DJavaArray(IndexIterator iter, Object javaArray) {
        Object[] ja = (Object[])javaArray;
        for (int i = 0; i < ja.length; ++i) {
            ja[i] = iter.getObjectNext();
        }
    }

    @Override
    public Class getElementType() {
        return StructureData.class;
    }

    public StructureMembers getStructureMembers() {
        return this.members;
    }

    public List<StructureMembers.Member> getMembers() {
        return this.members.getMembers();
    }

    public List<String> getStructureMemberNames() {
        return this.members.getMemberNames();
    }

    public StructureMembers.Member findMember(String memberName) {
        return this.members.findMember(memberName);
    }

    @Override
    public long getSizeBytes() {
        return this.indexCalc.getSize() * (long)this.members.getStructureSize();
    }

    @Override
    public Object getObject(Index i) {
        return this.getObject(i.currentElement());
    }

    @Override
    public void setObject(Index i, Object value) {
        this.setObject(i.currentElement(), value);
    }

    @Override
    public Object getObject(int index) {
        return this.getStructureData(index);
    }

    @Override
    public void setObject(int index, Object value) {
        if (this.sdata == null) {
            this.sdata = new StructureData[this.nelems];
        }
        this.sdata[index] = (StructureData)value;
    }

    public StructureData getStructureData(Index i) {
        return this.getStructureData(i.currentElement());
    }

    public StructureData getStructureData(int index) {
        if (this.sdata == null) {
            this.sdata = new StructureData[this.nelems];
        }
        if (index >= this.sdata.length) {
            throw new IllegalArgumentException(index + " > " + this.sdata.length);
        }
        if (this.sdata[index] == null) {
            this.sdata[index] = this.makeStructureData(this, index);
        }
        return this.sdata[index];
    }

    @Override
    public Object getStorage() {
        for (int i = 0; i < this.nelems; ++i) {
            this.getStructureData(i);
        }
        return this.sdata;
    }

    protected abstract StructureData makeStructureData(ArrayStructure var1, int var2);

    public int getStructureSize() {
        return this.members.getStructureSize();
    }

    public StructureDataIterator getStructureDataIterator() {
        return new ArrayStructureIterator();
    }

    public Array getArray(int recno, StructureMembers.Member m) {
        DataType dataType = m.getDataType();
        if (dataType == DataType.DOUBLE) {
            double[] pa = this.getJavaArrayDouble(recno, m);
            return Array.factory(Double.TYPE, m.getShape(), (Object)pa);
        }
        if (dataType == DataType.FLOAT) {
            float[] pa = this.getJavaArrayFloat(recno, m);
            return Array.factory(Float.TYPE, m.getShape(), (Object)pa);
        }
        if (dataType == DataType.BYTE || dataType == DataType.ENUM1) {
            byte[] pa = this.getJavaArrayByte(recno, m);
            return Array.factory(Byte.TYPE, m.getShape(), (Object)pa);
        }
        if (dataType == DataType.SHORT || dataType == DataType.ENUM2) {
            short[] pa = this.getJavaArrayShort(recno, m);
            return Array.factory(Short.TYPE, m.getShape(), (Object)pa);
        }
        if (dataType == DataType.INT || dataType == DataType.ENUM4) {
            int[] pa = this.getJavaArrayInt(recno, m);
            return Array.factory(Integer.TYPE, m.getShape(), (Object)pa);
        }
        if (dataType == DataType.LONG) {
            long[] pa = this.getJavaArrayLong(recno, m);
            return Array.factory(Long.TYPE, m.getShape(), (Object)pa);
        }
        if (dataType == DataType.CHAR) {
            char[] pa = this.getJavaArrayChar(recno, m);
            return Array.factory(Character.TYPE, m.getShape(), (Object)pa);
        }
        if (dataType == DataType.STRING) {
            String[] pa = this.getJavaArrayString(recno, m);
            return Array.factory(String.class, m.getShape(), (Object)pa);
        }
        if (dataType == DataType.STRUCTURE) {
            return this.getArrayStructure(recno, m);
        }
        if (dataType == DataType.SEQUENCE) {
            return this.getArraySequence(recno, m);
        }
        if (dataType == DataType.OPAQUE) {
            return this.getArrayObject(recno, m);
        }
        throw new RuntimeException("Dont have implemenation for " + (Object)((Object)dataType));
    }

    public void setMemberArray(StructureMembers.Member m, Array memberArray) {
        m.setDataArray(memberArray);
        if (memberArray instanceof ArrayStructure) {
            ArrayStructure as = (ArrayStructure)memberArray;
            m.setStructureMembers(as.getStructureMembers());
        }
    }

    public Array extractMemberArray(StructureMembers.Member m) throws IOException {
        Array result;
        block14: {
            IndexIterator resultIter;
            DataType dataType;
            block22: {
                block21: {
                    block20: {
                        block19: {
                            block18: {
                                block17: {
                                    block16: {
                                        block15: {
                                            block13: {
                                                if (m.getDataArray() != null) {
                                                    return m.getDataArray();
                                                }
                                                dataType = m.getDataType();
                                                int[] mshape = m.getShape();
                                                int rrank = this.rank + mshape.length;
                                                int[] rshape = new int[rrank];
                                                System.arraycopy(this.getShape(), 0, rshape, 0, this.rank);
                                                System.arraycopy(mshape, 0, rshape, this.rank, mshape.length);
                                                if (dataType == DataType.STRUCTURE) {
                                                    StructureMembers membersw = new StructureMembers(m.getStructureMembers());
                                                    result = new ArrayStructureW(membersw, rshape);
                                                } else {
                                                    result = dataType == DataType.OPAQUE ? new ArrayObject(ByteBuffer.class, rshape) : Array.factory(dataType.getPrimitiveClassType(), rshape);
                                                }
                                                resultIter = result.getIndexIterator();
                                                if (dataType != DataType.DOUBLE) break block13;
                                                int recno = 0;
                                                while ((long)recno < this.getSize()) {
                                                    this.copyDoubles(recno, m, resultIter);
                                                    ++recno;
                                                }
                                                break block14;
                                            }
                                            if (dataType != DataType.FLOAT) break block15;
                                            int recno = 0;
                                            while ((long)recno < this.getSize()) {
                                                this.copyFloats(recno, m, resultIter);
                                                ++recno;
                                            }
                                            break block14;
                                        }
                                        if (dataType != DataType.BYTE && dataType != DataType.ENUM1) break block16;
                                        int recno = 0;
                                        while ((long)recno < this.getSize()) {
                                            this.copyBytes(recno, m, resultIter);
                                            ++recno;
                                        }
                                        break block14;
                                    }
                                    if (dataType != DataType.SHORT && dataType != DataType.ENUM2) break block17;
                                    int recno = 0;
                                    while ((long)recno < this.getSize()) {
                                        this.copyShorts(recno, m, resultIter);
                                        ++recno;
                                    }
                                    break block14;
                                }
                                if (dataType != DataType.INT && dataType != DataType.ENUM4) break block18;
                                int recno = 0;
                                while ((long)recno < this.getSize()) {
                                    this.copyInts(recno, m, resultIter);
                                    ++recno;
                                }
                                break block14;
                            }
                            if (dataType != DataType.LONG) break block19;
                            int recno = 0;
                            while ((long)recno < this.getSize()) {
                                this.copyLongs(recno, m, resultIter);
                                ++recno;
                            }
                            break block14;
                        }
                        if (dataType != DataType.CHAR) break block20;
                        int recno = 0;
                        while ((long)recno < this.getSize()) {
                            this.copyChars(recno, m, resultIter);
                            ++recno;
                        }
                        break block14;
                    }
                    if (dataType != DataType.STRING && dataType != DataType.OPAQUE) break block21;
                    int recno = 0;
                    while ((long)recno < this.getSize()) {
                        this.copyObjects(recno, m, resultIter);
                        ++recno;
                    }
                    break block14;
                }
                if (dataType != DataType.STRUCTURE) break block22;
                int recno = 0;
                while ((long)recno < this.getSize()) {
                    this.copyStructures(recno, m, resultIter);
                    ++recno;
                }
                break block14;
            }
            if (dataType != DataType.SEQUENCE) break block14;
            int recno = 0;
            while ((long)recno < this.getSize()) {
                this.copySequences(recno, m, resultIter);
                ++recno;
            }
        }
        return result;
    }

    protected void copyChars(int recnum, StructureMembers.Member m, IndexIterator result) {
        IndexIterator dataIter = this.getArray(recnum, m).getIndexIterator();
        while (dataIter.hasNext()) {
            result.setCharNext(dataIter.getCharNext());
        }
    }

    protected void copyDoubles(int recnum, StructureMembers.Member m, IndexIterator result) {
        IndexIterator dataIter = this.getArray(recnum, m).getIndexIterator();
        while (dataIter.hasNext()) {
            result.setDoubleNext(dataIter.getDoubleNext());
        }
    }

    protected void copyFloats(int recnum, StructureMembers.Member m, IndexIterator result) {
        IndexIterator dataIter = this.getArray(recnum, m).getIndexIterator();
        while (dataIter.hasNext()) {
            result.setFloatNext(dataIter.getFloatNext());
        }
    }

    protected void copyBytes(int recnum, StructureMembers.Member m, IndexIterator result) {
        IndexIterator dataIter = this.getArray(recnum, m).getIndexIterator();
        while (dataIter.hasNext()) {
            result.setByteNext(dataIter.getByteNext());
        }
    }

    protected void copyShorts(int recnum, StructureMembers.Member m, IndexIterator result) {
        IndexIterator dataIter = this.getArray(recnum, m).getIndexIterator();
        while (dataIter.hasNext()) {
            result.setShortNext(dataIter.getShortNext());
        }
    }

    protected void copyInts(int recnum, StructureMembers.Member m, IndexIterator result) {
        IndexIterator dataIter = this.getArray(recnum, m).getIndexIterator();
        while (dataIter.hasNext()) {
            result.setIntNext(dataIter.getIntNext());
        }
    }

    protected void copyLongs(int recnum, StructureMembers.Member m, IndexIterator result) {
        IndexIterator dataIter = this.getArray(recnum, m).getIndexIterator();
        while (dataIter.hasNext()) {
            result.setLongNext(dataIter.getLongNext());
        }
    }

    protected void copyObjects(int recnum, StructureMembers.Member m, IndexIterator result) {
        IndexIterator dataIter = this.getArray(recnum, m).getIndexIterator();
        while (dataIter.hasNext()) {
            result.setObjectNext(dataIter.getObjectNext());
        }
    }

    protected void copyStructures(int recnum, StructureMembers.Member m, IndexIterator result) {
        Array data = this.getArray(recnum, m);
        IndexIterator dataIter = data.getIndexIterator();
        while (dataIter.hasNext()) {
            result.setObjectNext(dataIter.getObjectNext());
        }
    }

    protected void copySequences(int recnum, StructureMembers.Member m, IndexIterator result) {
        Array data = this.getArray(recnum, m);
        result.setObjectNext(data);
    }

    public Object getScalarObject(int recno, StructureMembers.Member m) {
        DataType dataType = m.getDataType();
        if (dataType == DataType.DOUBLE) {
            return this.getScalarDouble(recno, m);
        }
        if (dataType == DataType.FLOAT) {
            return Float.valueOf(this.getScalarFloat(recno, m));
        }
        if (dataType == DataType.BYTE || dataType == DataType.ENUM1) {
            return this.getScalarByte(recno, m);
        }
        if (dataType == DataType.SHORT || dataType == DataType.ENUM2) {
            return this.getScalarShort(recno, m);
        }
        if (dataType == DataType.INT || dataType == DataType.ENUM4) {
            return this.getScalarInt(recno, m);
        }
        if (dataType == DataType.LONG) {
            return this.getScalarLong(recno, m);
        }
        if (dataType == DataType.CHAR) {
            return this.getScalarString(recno, m);
        }
        if (dataType == DataType.STRING) {
            return this.getScalarString(recno, m);
        }
        if (dataType == DataType.STRUCTURE) {
            return this.getScalarStructure(recno, m);
        }
        if (dataType == DataType.OPAQUE) {
            ArrayObject data = (ArrayObject)m.getDataArray();
            return data.getObject(recno * m.getSize());
        }
        throw new RuntimeException("Dont have implementation for " + (Object)((Object)dataType));
    }

    public float convertScalarFloat(int recnum, StructureMembers.Member m) {
        if (m.getDataType() == DataType.FLOAT) {
            return this.getScalarFloat(recnum, m);
        }
        if (m.getDataType() == DataType.DOUBLE) {
            return (float)this.getScalarDouble(recnum, m);
        }
        Object o = this.getScalarObject(recnum, m);
        if (o instanceof Number) {
            return ((Number)o).floatValue();
        }
        throw new ForbiddenConversionException("Type is " + (Object)((Object)m.getDataType()) + ", not convertible to float");
    }

    public double convertScalarDouble(int recnum, StructureMembers.Member m) {
        if (m.getDataType() == DataType.DOUBLE) {
            return this.getScalarDouble(recnum, m);
        }
        if (m.getDataType() == DataType.FLOAT) {
            return this.getScalarFloat(recnum, m);
        }
        Object o = this.getScalarObject(recnum, m);
        if (o instanceof Number) {
            return ((Number)o).doubleValue();
        }
        throw new ForbiddenConversionException("Type is " + (Object)((Object)m.getDataType()) + ", not convertible to double");
    }

    public int convertScalarInt(int recnum, StructureMembers.Member m) {
        if (m.getDataType() == DataType.INT) {
            return this.getScalarInt(recnum, m);
        }
        if (m.getDataType() == DataType.SHORT) {
            return this.getScalarShort(recnum, m);
        }
        if (m.getDataType() == DataType.BYTE) {
            return this.getScalarByte(recnum, m);
        }
        if (m.getDataType() == DataType.LONG) {
            return (int)this.getScalarLong(recnum, m);
        }
        Object o = this.getScalarObject(recnum, m);
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        throw new ForbiddenConversionException("Type is " + (Object)((Object)m.getDataType()) + ", not convertible to int");
    }

    public long convertScalarLong(int recnum, StructureMembers.Member m) {
        if (m.getDataType() == DataType.LONG) {
            return this.getScalarLong(recnum, m);
        }
        if (m.getDataType() == DataType.INT) {
            return this.getScalarInt(recnum, m);
        }
        if (m.getDataType() == DataType.SHORT) {
            return this.getScalarShort(recnum, m);
        }
        if (m.getDataType() == DataType.BYTE) {
            return this.getScalarByte(recnum, m);
        }
        Object o = this.getScalarObject(recnum, m);
        if (o instanceof Number) {
            return ((Number)o).longValue();
        }
        throw new ForbiddenConversionException("Type is " + (Object)((Object)m.getDataType()) + ", not convertible to int");
    }

    public double getScalarDouble(int recnum, StructureMembers.Member m) {
        if (m.getDataType() != DataType.DOUBLE) {
            throw new IllegalArgumentException("Type is " + (Object)((Object)m.getDataType()) + ", must be double");
        }
        Array data = m.getDataArray();
        return data.getDouble(recnum * m.getSize());
    }

    public double[] getJavaArrayDouble(int recnum, StructureMembers.Member m) {
        if (m.getDataType() != DataType.DOUBLE) {
            throw new IllegalArgumentException("Type is " + (Object)((Object)m.getDataType()) + ", must be double");
        }
        int count = m.getSize();
        Array data = m.getDataArray();
        double[] pa = new double[count];
        for (int i = 0; i < count; ++i) {
            pa[i] = data.getDouble(recnum * count + i);
        }
        return pa;
    }

    public float getScalarFloat(int recnum, StructureMembers.Member m) {
        if (m.getDataType() != DataType.FLOAT) {
            throw new IllegalArgumentException("Type is " + (Object)((Object)m.getDataType()) + ", must be float");
        }
        Array data = m.getDataArray();
        return data.getFloat(recnum * m.getSize());
    }

    public float[] getJavaArrayFloat(int recnum, StructureMembers.Member m) {
        if (m.getDataType() != DataType.FLOAT) {
            throw new IllegalArgumentException("Type is " + (Object)((Object)m.getDataType()) + ", must be float");
        }
        int count = m.getSize();
        Array data = m.getDataArray();
        float[] pa = new float[count];
        for (int i = 0; i < count; ++i) {
            pa[i] = data.getFloat(recnum * count + i);
        }
        return pa;
    }

    public byte getScalarByte(int recnum, StructureMembers.Member m) {
        if (m.getDataType() != DataType.BYTE && m.getDataType() != DataType.ENUM1) {
            throw new IllegalArgumentException("Type is " + (Object)((Object)m.getDataType()) + ", must be byte");
        }
        Array data = m.getDataArray();
        return data.getByte(recnum * m.getSize());
    }

    public byte[] getJavaArrayByte(int recnum, StructureMembers.Member m) {
        if (m.getDataType() != DataType.BYTE && m.getDataType() != DataType.ENUM1) {
            throw new IllegalArgumentException("Type is " + (Object)((Object)m.getDataType()) + ", must be byte");
        }
        int count = m.getSize();
        Array data = m.getDataArray();
        byte[] pa = new byte[count];
        for (int i = 0; i < count; ++i) {
            pa[i] = data.getByte(recnum * count + i);
        }
        return pa;
    }

    public short getScalarShort(int recnum, StructureMembers.Member m) {
        if (m.getDataType() != DataType.SHORT && m.getDataType() != DataType.ENUM2) {
            throw new IllegalArgumentException("Type is " + (Object)((Object)m.getDataType()) + ", must be short");
        }
        Array data = m.getDataArray();
        return data.getShort(recnum * m.getSize());
    }

    public short[] getJavaArrayShort(int recnum, StructureMembers.Member m) {
        if (m.getDataType() != DataType.SHORT && m.getDataType() != DataType.ENUM2) {
            throw new IllegalArgumentException("Type is " + (Object)((Object)m.getDataType()) + ", must be short");
        }
        int count = m.getSize();
        Array data = m.getDataArray();
        short[] pa = new short[count];
        for (int i = 0; i < count; ++i) {
            pa[i] = data.getShort(recnum * count + i);
        }
        return pa;
    }

    public int getScalarInt(int recnum, StructureMembers.Member m) {
        if (m.getDataType() != DataType.INT && m.getDataType() != DataType.ENUM4) {
            throw new IllegalArgumentException("Type is " + (Object)((Object)m.getDataType()) + ", must be int");
        }
        Array data = m.getDataArray();
        return data.getInt(recnum * m.getSize());
    }

    public int[] getJavaArrayInt(int recnum, StructureMembers.Member m) {
        if (m.getDataType() != DataType.INT && m.getDataType() != DataType.ENUM4) {
            throw new IllegalArgumentException("Type is " + (Object)((Object)m.getDataType()) + ", must be int");
        }
        int count = m.getSize();
        Array data = m.getDataArray();
        int[] pa = new int[count];
        for (int i = 0; i < count; ++i) {
            pa[i] = data.getInt(recnum * count + i);
        }
        return pa;
    }

    public long getScalarLong(int recnum, StructureMembers.Member m) {
        if (m.getDataType() != DataType.LONG) {
            throw new IllegalArgumentException("Type is " + (Object)((Object)m.getDataType()) + ", must be long");
        }
        Array data = m.getDataArray();
        return data.getLong(recnum * m.getSize());
    }

    public long[] getJavaArrayLong(int recnum, StructureMembers.Member m) {
        if (m.getDataType() != DataType.LONG) {
            throw new IllegalArgumentException("Type is " + (Object)((Object)m.getDataType()) + ", must be long");
        }
        int count = m.getSize();
        Array data = m.getDataArray();
        long[] pa = new long[count];
        for (int i = 0; i < count; ++i) {
            pa[i] = data.getLong(recnum * count + i);
        }
        return pa;
    }

    public char getScalarChar(int recnum, StructureMembers.Member m) {
        if (m.getDataType() != DataType.CHAR) {
            throw new IllegalArgumentException("Type is " + (Object)((Object)m.getDataType()) + ", must be char");
        }
        Array data = m.getDataArray();
        return data.getChar(recnum * m.getSize());
    }

    public char[] getJavaArrayChar(int recnum, StructureMembers.Member m) {
        if (m.getDataType() != DataType.CHAR) {
            throw new IllegalArgumentException("Type is " + (Object)((Object)m.getDataType()) + ", must be char");
        }
        int count = m.getSize();
        Array data = m.getDataArray();
        char[] pa = new char[count];
        for (int i = 0; i < count; ++i) {
            pa[i] = data.getChar(recnum * count + i);
        }
        return pa;
    }

    public String getScalarString(int recnum, StructureMembers.Member m) {
        if (m.getDataType() == DataType.CHAR) {
            ArrayChar data = (ArrayChar)m.getDataArray();
            return data.getString(recnum);
        }
        if (m.getDataType() == DataType.STRING) {
            Array data = m.getDataArray();
            return (String)data.getObject(recnum);
        }
        throw new IllegalArgumentException("Type is " + (Object)((Object)m.getDataType()) + ", must be String or char");
    }

    public String[] getJavaArrayString(int recnum, StructureMembers.Member m) {
        if (m.getDataType() == DataType.STRING) {
            int n = m.getSize();
            String[] result = new String[n];
            Array data = m.getDataArray();
            for (int i = 0; i < n; ++i) {
                result[i] = (String)data.getObject(recnum * n + i);
            }
            return result;
        }
        if (m.getDataType() == DataType.CHAR) {
            int strlen = this.indexCalc.getShape(this.rank - 1);
            int n = m.getSize() / strlen;
            String[] result = new String[n];
            ArrayChar data = (ArrayChar)m.getDataArray();
            for (int i = 0; i < n; ++i) {
                result[i] = data.getString((recnum * n + i) * strlen);
            }
            return result;
        }
        throw new IllegalArgumentException("Type is " + (Object)((Object)m.getDataType()) + ", must be String or char");
    }

    public StructureData getScalarStructure(int recnum, StructureMembers.Member m) {
        if (m.getDataType() != DataType.STRUCTURE) {
            throw new IllegalArgumentException("Type is " + (Object)((Object)m.getDataType()) + ", must be Structure");
        }
        ArrayStructure data = (ArrayStructure)m.getDataArray();
        return data.getStructureData(recnum * m.getSize());
    }

    public ArrayStructure getArrayStructure(int recnum, StructureMembers.Member m) {
        if (m.getDataType() != DataType.STRUCTURE && m.getDataType() != DataType.SEQUENCE) {
            throw new IllegalArgumentException("Type is " + (Object)((Object)m.getDataType()) + ", must be Structure or Sequence");
        }
        if (m.getDataType() == DataType.SEQUENCE) {
            return this.getArraySequence(recnum, m);
        }
        ArrayStructure array = (ArrayStructure)m.getDataArray();
        int count = m.getSize();
        StructureData[] this_sdata = new StructureData[count];
        for (int i = 0; i < count; ++i) {
            this_sdata[i] = array.getStructureData(recnum * count + i);
        }
        StructureMembers membersw = new StructureMembers(array.getStructureMembers());
        return new ArrayStructureW(membersw, m.getShape(), this_sdata);
    }

    public ArraySequence getArraySequence(int recnum, StructureMembers.Member m) {
        if (m.getDataType() != DataType.SEQUENCE) {
            throw new IllegalArgumentException("Type is " + (Object)((Object)m.getDataType()) + ", must be Sequence");
        }
        ArrayObject array = (ArrayObject)m.getDataArray();
        return (ArraySequence)array.getObject(recnum);
    }

    public ArrayObject getArrayObject(int recnum, StructureMembers.Member m) {
        if (m.getDataType() != DataType.OPAQUE) {
            throw new IllegalArgumentException("Type is " + (Object)((Object)m.getDataType()) + ", must be Sequence");
        }
        ArrayObject array = (ArrayObject)m.getDataArray();
        return (ArrayObject)array.getObject(recnum);
    }

    public void showInternal(Formatter f, Indent indent) {
        f.format("%sArrayStructure %s size=%d class=%s hash=0x%x%n", indent, this.members.getName(), this.getSize(), this.getClass().getName(), this.hashCode());
    }

    public void showInternalMembers(Formatter f, Indent indent) {
        f.format("%sArrayStructure %s class=%s hash=0x%x%n", indent, this.members.getName(), this.getClass().getName(), this.hashCode());
        indent.incr();
        for (StructureMembers.Member m : this.getMembers()) {
            m.showInternal(f, indent);
        }
        indent.incr();
    }

    @Override
    public Array createView(Index index) {
        if (index.getSize() == this.getSize()) {
            return this;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public Array copy() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getDouble(Index i) {
        throw new ForbiddenConversionException();
    }

    @Override
    public void setDouble(Index i, double value) {
        throw new ForbiddenConversionException();
    }

    @Override
    public float getFloat(Index i) {
        throw new ForbiddenConversionException();
    }

    @Override
    public void setFloat(Index i, float value) {
        throw new ForbiddenConversionException();
    }

    @Override
    public long getLong(Index i) {
        throw new ForbiddenConversionException();
    }

    @Override
    public void setLong(Index i, long value) {
        throw new ForbiddenConversionException();
    }

    @Override
    public int getInt(Index i) {
        throw new ForbiddenConversionException();
    }

    @Override
    public void setInt(Index i, int value) {
        throw new ForbiddenConversionException();
    }

    @Override
    public short getShort(Index i) {
        throw new ForbiddenConversionException();
    }

    @Override
    public void setShort(Index i, short value) {
        throw new ForbiddenConversionException();
    }

    @Override
    public byte getByte(Index i) {
        throw new ForbiddenConversionException();
    }

    @Override
    public void setByte(Index i, byte value) {
        throw new ForbiddenConversionException();
    }

    @Override
    public boolean getBoolean(Index i) {
        throw new ForbiddenConversionException();
    }

    @Override
    public void setBoolean(Index i, boolean value) {
        throw new ForbiddenConversionException();
    }

    @Override
    public char getChar(Index i) {
        throw new ForbiddenConversionException();
    }

    @Override
    public void setChar(Index i, char value) {
        throw new ForbiddenConversionException();
    }

    @Override
    public double getDouble(int index) {
        throw new ForbiddenConversionException();
    }

    @Override
    public void setDouble(int index, double value) {
        throw new ForbiddenConversionException();
    }

    @Override
    public float getFloat(int index) {
        throw new ForbiddenConversionException();
    }

    @Override
    public void setFloat(int index, float value) {
        throw new ForbiddenConversionException();
    }

    @Override
    public long getLong(int index) {
        throw new ForbiddenConversionException();
    }

    @Override
    public void setLong(int index, long value) {
        throw new ForbiddenConversionException();
    }

    @Override
    public int getInt(int index) {
        throw new ForbiddenConversionException();
    }

    @Override
    public void setInt(int index, int value) {
        throw new ForbiddenConversionException();
    }

    @Override
    public short getShort(int index) {
        throw new ForbiddenConversionException();
    }

    @Override
    public void setShort(int index, short value) {
        throw new ForbiddenConversionException();
    }

    @Override
    public byte getByte(int index) {
        throw new ForbiddenConversionException();
    }

    @Override
    public void setByte(int index, byte value) {
        throw new ForbiddenConversionException();
    }

    @Override
    public char getChar(int index) {
        throw new ForbiddenConversionException();
    }

    @Override
    public void setChar(int index, char value) {
        throw new ForbiddenConversionException();
    }

    @Override
    public boolean getBoolean(int index) {
        throw new ForbiddenConversionException();
    }

    @Override
    public void setBoolean(int index, boolean value) {
        throw new ForbiddenConversionException();
    }

    public class ArrayStructureIterator
    implements StructureDataIterator {
        private int count = 0;
        private int size = (int)ArrayStructure.this.getSize();

        @Override
        public boolean hasNext() throws IOException {
            return this.count < this.size;
        }

        @Override
        public StructureData next() throws IOException {
            return ArrayStructure.this.getStructureData(this.count++);
        }

        @Override
        public void setBufferSize(int bytes) {
        }

        @Override
        public StructureDataIterator reset() {
            this.count = 0;
            return this;
        }

        @Override
        public int getCurrentRecno() {
            return this.count - 1;
        }

        @Override
        public void finish() {
        }

        public ArrayStructure getArrayStructure() {
            return ArrayStructure.this;
        }
    }
}

