/*
 * Decompiled with CFR 0.152.
 */
package thredds.inventory;

import java.util.Date;
import net.jcip.annotations.ThreadSafe;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.inventory.CollectionManager;

@ThreadSafe
public enum CollectionUpdater {
    INSTANCE;

    private static final Logger startupLogger;
    private static final String DCM_NAME = "dcm";
    private static final String LOGGER = "logger";
    private static final long startupWait = 10000L;
    private static boolean disabled;
    private Scheduler scheduler = null;
    private boolean failed = false;
    private boolean isTdm = false;

    public void setTdm(boolean tdm) {
        this.isTdm = tdm;
    }

    public boolean isTdm() {
        return this.isTdm;
    }

    private CollectionUpdater() {
        try {
            this.scheduler = StdSchedulerFactory.getDefaultScheduler();
            this.scheduler.start();
        }
        catch (SchedulerException e) {
            this.failed = true;
            throw new RuntimeException("quartz scheduler failed to initialize", e);
        }
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public void scheduleTasks(FeatureCollectionConfig config, CollectionManager manager, Logger logger) {
        FeatureCollectionConfig.UpdateConfig updateConfig;
        if (disabled || this.failed) {
            return;
        }
        FeatureCollectionConfig.UpdateConfig updateConfig2 = updateConfig = this.isTdm ? config.tdmConfig : config.updateConfig;
        if (updateConfig == null) {
            return;
        }
        String jobName = manager.getCollectionName();
        JobDataMap map = new JobDataMap();
        map.put(DCM_NAME, (Object)manager);
        map.put(LOGGER, (Object)logger);
        JobDetail updateJob = JobBuilder.newJob(UpdateCollectionJob.class).withIdentity(jobName, "UpdateCollection").storeDurably().usingJobData(map).build();
        try {
            if (!this.scheduler.checkExists(updateJob.getKey())) {
                this.scheduler.addJob(updateJob, false);
            } else {
                logger.warn("cronExecutor failed to add updateJob for " + updateJob.getKey() + ". Another Job exists with that identification.");
            }
        }
        catch (SchedulerException e) {
            logger.error("cronExecutor failed to add updateJob for " + config, e);
            return;
        }
        if (updateConfig.startup) {
            Date runTime = new Date(new Date().getTime() + 10000L);
            SimpleTrigger startupTrigger = (SimpleTrigger)TriggerBuilder.newTrigger().withIdentity(jobName, updateConfig.startupForce.toString()).startAt(runTime).forJob(updateJob).build();
            try {
                this.scheduler.scheduleJob(startupTrigger);
                logger.info("Schedule startup scan force={} for '{}' at {}", updateConfig.startupForce.toString(), config.name, runTime);
            }
            catch (SchedulerException e) {
                logger.error("cronExecutor failed to schedule startup Job for " + config, e);
                return;
            }
        }
        if (updateConfig.rescan != null) {
            CronTrigger rescanTrigger = TriggerBuilder.newTrigger().withIdentity(jobName, "rescan").withSchedule(CronScheduleBuilder.cronSchedule(updateConfig.rescan)).forJob(updateJob).build();
            try {
                this.scheduler.scheduleJob(rescanTrigger);
                logger.info("Schedule recurring scan for '{}' cronExpr={}", (Object)config.name, (Object)updateConfig.rescan);
            }
            catch (SchedulerException e) {
                logger.error("cronExecutor failed to schedule cron Job", e);
            }
        }
        FeatureCollectionConfig.ProtoConfig pconfig = config.protoConfig;
        if (pconfig.change != null) {
            JobDataMap pmap = new JobDataMap();
            pmap.put(DCM_NAME, (Object)manager);
            map.put(LOGGER, (Object)LoggerFactory.getLogger("fc." + manager.getCollectionName()));
            JobDetail protoJob = JobBuilder.newJob(ChangeProtoJob.class).withIdentity(jobName, "UpdateProto").usingJobData(pmap).storeDurably().build();
            try {
                CronTrigger protoTrigger = TriggerBuilder.newTrigger().withIdentity(jobName, "rereadProto").withSchedule(CronScheduleBuilder.cronSchedule(pconfig.change)).build();
                this.scheduler.scheduleJob(protoJob, protoTrigger);
                logger.info("Schedule proto update for '{}' cronExpr={}", (Object)config.name, (Object)pconfig.change);
            }
            catch (SchedulerException e) {
                logger.error("cronExecutor failed to schedule RereadProtoJob", e);
            }
        }
    }

    public void shutdown() {
        if (this.scheduler == null) {
            return;
        }
        try {
            this.scheduler.shutdown(true);
            Logger logServerStartup = LoggerFactory.getLogger("serverStartup");
            logServerStartup.info("Scheduler shutdown");
        }
        catch (SchedulerException e) {
            startupLogger.error("Scheduler failed to shutdown", e);
            this.scheduler = null;
        }
    }

    public void triggerUpdate(String collectionName, String triggerType) {
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity(collectionName + "-trigger", triggerType).forJob(collectionName, "UpdateCollection").startNow().build();
        try {
            this.scheduler.scheduleJob(trigger);
        }
        catch (SchedulerException e) {
            startupLogger.error("triggerUpdate failed", e);
        }
    }

    static {
        startupLogger = LoggerFactory.getLogger(CollectionUpdater.class);
        disabled = false;
    }

    public static class ChangeProtoJob
    implements Job {
        @Override
        public void execute(JobExecutionContext context) throws JobExecutionException {
            CollectionManager manager = (CollectionManager)context.getJobDetail().getJobDataMap().get(CollectionUpdater.DCM_NAME);
            Logger loggerfc = (Logger)context.getJobDetail().getJobDataMap().get(CollectionUpdater.LOGGER);
            if (manager == null) {
                loggerfc.error("Update resetProto failed: no manager object on {}", (Object)context);
                return;
            }
            try {
                loggerfc.info("ResetProto for {}", (Object)manager.getCollectionName());
                manager.resetProto();
            }
            catch (Throwable e) {
                loggerfc.error("ChangeProtoJob.execute failed collection=" + manager.getCollectionName(), e);
            }
        }
    }

    public static class UpdateCollectionJob
    implements Job {
        @Override
        public void execute(JobExecutionContext context) throws JobExecutionException {
            CollectionManager manager = (CollectionManager)context.getJobDetail().getJobDataMap().get(CollectionUpdater.DCM_NAME);
            Logger loggerfc = (Logger)context.getJobDetail().getJobDataMap().get(CollectionUpdater.LOGGER);
            if (manager == null) {
                loggerfc.error("UpdateCollection failed: no manager object on {}", (Object)context);
                return;
            }
            try {
                String groupName = context.getTrigger().getKey().getGroup();
                if (groupName.equals("nocheck")) {
                    loggerfc.info("UpdateCollection {} nocheck", (Object)manager.getCollectionName());
                    manager.updateNocheck();
                } else {
                    loggerfc.debug("UpdateCollection {} scan(true)", (Object)manager.getCollectionName());
                    manager.scan(true);
                }
            }
            catch (Throwable e) {
                loggerfc.error("UpdateCollectionJob.execute failed collection=" + manager.getCollectionName(), e);
            }
        }
    }
}

