/*
 * Decompiled with CFR 0.152.
 */
package thredds.cataloggen;

import java.io.IOException;
import org.jdom.Document;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvService;
import thredds.cataloggen.CatalogBuilder;
import thredds.cataloggen.CatalogBuilderHelper;
import thredds.cataloggen.CollectionLevelScanner;
import thredds.cataloggen.ProxyDatasetHandler;
import thredds.crawlabledataset.CrawlableDataset;

public class SimpleCatalogBuilder
implements CatalogBuilder {
    private String collectionPath;
    private CrawlableDataset collectionCrDs;
    private InvService service;

    public SimpleCatalogBuilder(String collectionPath, CrawlableDataset collectionCrDs, String serviceName, String serviceTypeName, String serviceURL) {
        this.collectionPath = collectionPath == null ? collectionCrDs.getName() : collectionPath;
        this.collectionCrDs = collectionCrDs;
        this.service = new InvService(serviceName, serviceTypeName, serviceURL, null, null);
    }

    @Override
    public CrawlableDataset requestCrawlableDataset(String path) {
        return CatalogBuilderHelper.verifyDescendantDataset(this.collectionCrDs, path, null);
    }

    @Override
    public InvCatalogImpl generateCatalog(CrawlableDataset catalogCrDs) throws IOException {
        CollectionLevelScanner scanner = new CollectionLevelScanner(this.collectionPath, this.collectionCrDs, catalogCrDs, null, null, this.service);
        scanner.scan();
        return scanner.generateCatalog();
    }

    @Override
    public InvCatalogImpl generateProxyDsResolverCatalog(CrawlableDataset catalogCrDs, ProxyDatasetHandler pdh) throws IOException {
        throw new UnsupportedOperationException("This method not supported by SimpleCatalogBuilder.");
    }

    @Override
    public Document generateCatalogAsDocument(CrawlableDataset catalogCrDs) throws IOException {
        return CatalogBuilderHelper.convertCatalogToDocument(this.generateCatalog(catalogCrDs));
    }

    @Override
    public String generateCatalogAsString(CrawlableDataset catalogCrDs) throws IOException {
        return CatalogBuilderHelper.convertCatalogToString(this.generateCatalog(catalogCrDs));
    }
}

