/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.utilint;

import com.sleepycat.je.DbInternal;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.ExceptionListener;
import com.sleepycat.je.dbi.EnvironmentFailureReason;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.utilint.ExceptionListenerUser;
import com.sleepycat.je.utilint.LoggerUtils;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class StoppableThread
extends Thread
implements ExceptionListenerUser {
    private ExceptionListener exceptionListener;
    protected final EnvironmentImpl envImpl;
    private final AtomicBoolean shutdown = new AtomicBoolean(false);
    private Exception savedShutdownException = null;

    protected StoppableThread() {
        this((EnvironmentImpl)null);
    }

    protected StoppableThread(EnvironmentImpl envImpl) {
        this(envImpl, null);
    }

    protected StoppableThread(EnvironmentImpl envImpl, Thread.UncaughtExceptionHandler handler) {
        this.envImpl = envImpl;
        this.setDaemon(true);
        if (envImpl != null) {
            envImpl.registerExceptionListenerUser(this);
        }
        this.setUncaughtExceptionHandler(handler == null ? new UncaughtHandler() : handler);
    }

    protected abstract Logger getLogger();

    public Exception getSavedShutdownException() {
        return this.savedShutdownException;
    }

    public void saveShutdownException(Exception shutdownException) {
        this.savedShutdownException = shutdownException;
    }

    public boolean isShutdown() {
        return this.shutdown.get();
    }

    public void setExceptionListener(ExceptionListener exceptionListener) {
        this.exceptionListener = exceptionListener;
    }

    protected boolean shutdownDone() {
        return !this.shutdown.compareAndSet(false, true);
    }

    protected void cleanup() {
        if (this.envImpl != null) {
            this.envImpl.unregisterExceptionListenerUser(this);
        }
    }

    private class UncaughtHandler
    implements Thread.UncaughtExceptionHandler {
        private UncaughtHandler() {
        }

        public void uncaughtException(Thread t, Throwable e) {
            Logger useLogger = StoppableThread.this.getLogger();
            if (useLogger != null) {
                String envName = StoppableThread.this.envImpl == null ? "" : StoppableThread.this.envImpl.getName();
                String message = envName + ":" + t.getName() + " exited unexpectedly with exception " + e;
                if (e != null) {
                    message = message + LoggerUtils.getStackTrace(e);
                }
                if (StoppableThread.this.envImpl != null) {
                    LoggerUtils.severe(useLogger, StoppableThread.this.envImpl, message);
                } else {
                    useLogger.log(Level.SEVERE, message);
                }
            }
            if (StoppableThread.this.exceptionListener != null && e instanceof Exception) {
                StoppableThread.this.exceptionListener.exceptionThrown(DbInternal.makeExceptionEvent((Exception)e, t.getName()));
            }
            if (StoppableThread.this.envImpl == null) {
                return;
            }
            if (StoppableThread.this.envImpl.isValid()) {
                new EnvironmentFailureException(StoppableThread.this.envImpl, EnvironmentFailureReason.UNCAUGHT_EXCEPTION, e);
            }
        }
    }
}

