/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.utilint;

import com.sleepycat.je.TransactionStats;
import com.sleepycat.je.utilint.ActiveTxnArrayStat;
import com.sleepycat.je.utilint.AtomicLongStat;
import com.sleepycat.je.utilint.IntStat;
import com.sleepycat.je.utilint.LongArrayStat;
import com.sleepycat.je.utilint.LongStat;
import com.sleepycat.je.utilint.Stat;
import com.sleepycat.je.utilint.StatDefinition;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatGroup {
    private final String groupName;
    private final String groupDescription;
    private final Map<StatDefinition, Stat<?>> stats;

    public StatGroup(String groupName, String groupDescription) {
        this(groupName, groupDescription, new HashMap());
    }

    private StatGroup(String groupName, String groupDescription, Map<StatDefinition, Stat<?>> values) {
        this.groupName = groupName;
        this.groupDescription = groupDescription;
        this.stats = values;
    }

    void register(Stat<?> oneStat) {
        Stat<?> prev = this.stats.put(oneStat.getDefinition(), oneStat);
        assert (prev == null) : "prev = " + prev;
    }

    public void addAll(StatGroup other) {
        for (Map.Entry<StatDefinition, Stat<?>> entry : other.stats.entrySet()) {
            StatDefinition definition = entry.getKey();
            Stat<?> localStat = this.stats.get(definition);
            if (localStat == null) {
                this.stats.put(definition, entry.getValue());
                continue;
            }
            Stat<?> additionalValue = entry.getValue();
            localStat.add(additionalValue);
        }
    }

    public void clear() {
        for (Stat<?> s : this.stats.values()) {
            s.clear();
        }
    }

    public String getName() {
        return this.groupName;
    }

    public String getDescription() {
        return this.groupDescription;
    }

    public StatGroup cloneGroup(boolean clear) {
        HashMap copyValues = new HashMap();
        for (Stat<?> s : this.stats.values()) {
            if (clear) {
                copyValues.put(s.getDefinition(), s.copyAndClear());
                continue;
            }
            copyValues.put(s.getDefinition(), s.copy());
        }
        return new StatGroup(this.groupName, this.groupDescription, copyValues);
    }

    public int getInt(StatDefinition definition) {
        IntStat s = (IntStat)this.stats.get(definition);
        if (s == null) {
            return 0;
        }
        return s.get();
    }

    public long getLong(StatDefinition definition) {
        LongStat s = (LongStat)this.stats.get(definition);
        if (s == null) {
            return 0L;
        }
        return s.get();
    }

    public Long getAtomicLong(StatDefinition definition) {
        AtomicLongStat s = (AtomicLongStat)this.stats.get(definition);
        if (s == null) {
            return 0L;
        }
        return s.get();
    }

    public TransactionStats.Active[] getActiveTxnArray(StatDefinition definition) {
        ActiveTxnArrayStat s = (ActiveTxnArrayStat)this.stats.get(definition);
        if (s == null) {
            return null;
        }
        return s.get();
    }

    public long[] getLongArray(StatDefinition definition) {
        LongArrayStat s = (LongArrayStat)this.stats.get(definition);
        if (s == null) {
            return null;
        }
        return s.get();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.groupName).append(": ");
        sb.append(this.groupDescription).append("\n");
        TreeMap sortedStats = new TreeMap(this.stats);
        for (Stat s : sortedStats.values()) {
            sb.append("\t").append(s).append("\n");
        }
        return sb.toString();
    }

    public String toStringVerbose() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.groupName).append(": ");
        sb.append(this.groupDescription).append("\n");
        TreeMap sortedStats = new TreeMap(this.stats);
        for (Stat s : sortedStats.values()) {
            sb.append("\t").append(s.toStringVerbose()).append("\n");
        }
        return sb.toString();
    }
}

