/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.util;

import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.EnvironmentStats;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.utilint.CmdUtil;
import java.io.File;
import java.io.PrintStream;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.util.Random;

public class DbCacheSize {
    private static final NumberFormat INT_FORMAT = NumberFormat.getIntegerInstance();
    private static final String HEADER = "    Cache Size      Btree Size  Description\n--------------  --------------  -----------";
    private static final int COLUMN_WIDTH = 14;
    private static final int COLUMN_SEPARATOR = 2;
    private long records;
    private int keySize;
    private int dataSize;
    private int nodeMax;
    private int density;
    private long overhead;
    private long minInBtreeSize;
    private long maxInBtreeSize;
    private long minInCacheSize;
    private long maxInCacheSize;
    private long maxInBtreeSizeWithData;
    private long maxInCacheSizeWithData;
    private long minInBtreeSizeWithData;
    private long minInCacheSizeWithData;
    private int nLevels = 1;

    public DbCacheSize(long records, int keySize, int dataSize, int nodeMax, int density, long overhead) {
        this.records = records;
        this.keySize = keySize;
        this.dataSize = dataSize;
        this.nodeMax = nodeMax;
        this.density = density;
        this.overhead = overhead;
    }

    public long getMinCacheSizeInternalNodesOnly() {
        return this.minInCacheSize;
    }

    public long getMaxCacheSizeInternalNodesOnly() {
        return this.maxInCacheSize;
    }

    public long getMinBtreeSizeInternalNodesOnly() {
        return this.minInBtreeSize;
    }

    public long getMaxBtreeSizeInternalNodesOnly() {
        return this.maxInBtreeSize;
    }

    public long getMinCacheSizeWithData() {
        return this.minInCacheSizeWithData;
    }

    public long getMaxCacheSizeWithData() {
        return this.maxInCacheSizeWithData;
    }

    public long getMinBtreeSizeWithData() {
        return this.minInBtreeSizeWithData;
    }

    public long getMaxBtreeSizeWithData() {
        return this.maxInBtreeSizeWithData;
    }

    public int getNLevels() {
        return this.nLevels;
    }

    public static void main(String[] args) {
        try {
            long records = 0L;
            int keySize = 0;
            int dataSize = -1;
            int nodeMax = 128;
            int density = 80;
            long overhead = 0L;
            File measureDir = null;
            boolean measureRandom = false;
            for (int i = 0; i < args.length; ++i) {
                String name = args[i];
                String val = null;
                if (i < args.length - 1 && !args[i + 1].startsWith("-")) {
                    val = args[++i];
                }
                if (name.equals("-records")) {
                    if (val == null) {
                        DbCacheSize.usage("No value after -records");
                    }
                    try {
                        records = Long.parseLong(val);
                    }
                    catch (NumberFormatException e) {
                        DbCacheSize.usage(val + " is not a number");
                    }
                    if (records > 0L) continue;
                    DbCacheSize.usage(val + " is not a positive integer");
                    continue;
                }
                if (name.equals("-key")) {
                    if (val == null) {
                        DbCacheSize.usage("No value after -key");
                    }
                    try {
                        keySize = Integer.parseInt(val);
                    }
                    catch (NumberFormatException e) {
                        DbCacheSize.usage(val + " is not a number");
                    }
                    if (keySize > 0) continue;
                    DbCacheSize.usage(val + " is not a positive integer");
                    continue;
                }
                if (name.equals("-data")) {
                    if (val == null) {
                        DbCacheSize.usage("No value after -data");
                    }
                    try {
                        dataSize = Integer.parseInt(val);
                    }
                    catch (NumberFormatException e) {
                        DbCacheSize.usage(val + " is not a number");
                    }
                    if (dataSize >= 0) continue;
                    DbCacheSize.usage(val + " is not a non-negative integer");
                    continue;
                }
                if (name.equals("-nodemax")) {
                    if (val == null) {
                        DbCacheSize.usage("No value after -nodemax");
                    }
                    try {
                        nodeMax = Integer.parseInt(val);
                    }
                    catch (NumberFormatException e) {
                        DbCacheSize.usage(val + " is not a number");
                    }
                    if (nodeMax > 0) continue;
                    DbCacheSize.usage(val + " is not a positive integer");
                    continue;
                }
                if (name.equals("-density")) {
                    if (val == null) {
                        DbCacheSize.usage("No value after -density");
                    }
                    try {
                        density = Integer.parseInt(val);
                    }
                    catch (NumberFormatException e) {
                        DbCacheSize.usage(val + " is not a number");
                    }
                    if (density >= 1 && density <= 100) continue;
                    DbCacheSize.usage(val + " is not betwen 1 and 100");
                    continue;
                }
                if (name.equals("-overhead")) {
                    if (val == null) {
                        DbCacheSize.usage("No value after -overhead");
                    }
                    try {
                        overhead = Long.parseLong(val);
                    }
                    catch (NumberFormatException e) {
                        DbCacheSize.usage(val + " is not a number");
                    }
                    if (overhead >= 0L) continue;
                    DbCacheSize.usage(val + " is not a non-negative integer");
                    continue;
                }
                if (name.equals("-measure")) {
                    if (val == null) {
                        DbCacheSize.usage("No value after -measure");
                    }
                    measureDir = new File(val);
                    continue;
                }
                if (name.equals("-measurerandom")) {
                    measureRandom = true;
                    continue;
                }
                DbCacheSize.usage("Unknown arg: " + name);
            }
            if (records == 0L) {
                DbCacheSize.usage("-records not specified");
            }
            if (keySize == 0) {
                DbCacheSize.usage("-key not specified");
            }
            DbCacheSize dbCacheSize = new DbCacheSize(records, keySize, dataSize, nodeMax, density, overhead);
            dbCacheSize.caclulateCacheSizes();
            dbCacheSize.printCacheSizes(System.out);
            if (measureDir != null) {
                DbCacheSize.measure(System.out, measureDir, records, keySize, dataSize, nodeMax, measureRandom);
            }
        }
        catch (Throwable e) {
            e.printStackTrace(System.out);
        }
    }

    private static void usage(String msg) {
        if (msg != null) {
            System.out.println(msg);
        }
        System.out.println("usage:\njava " + CmdUtil.getJavaCommand(DbCacheSize.class) + "\n   -records <count>" + "\n      # Total records (key/data pairs); required" + "\n   -key <bytes> " + "\n      # Average key bytes per record; required" + "\n  [-data <bytes>]" + "\n      # Average data bytes per record; if omitted no leaf" + "\n      # node sizes are included in the output" + "\n  [-nodemax <entries>]" + "\n      # Number of entries per Btree node; default: 128" + "\n  [-density <percentage>]" + "\n      # Percentage of node entries occupied; default: 80" + "\n  [-overhead <bytes>]" + "\n      # Overhead of non-Btree objects (log buffers, locks," + "\n      # etc); default: 10% of total cache size" + "\n  [-measure <environmentHomeDirectory>]" + "\n      # An empty directory used to write a database to find" + "\n      # the actual cache size; default: do not measure" + "\n  [-measurerandom" + "\n      # With -measure insert randomly generated keys;" + "\n      # default: insert sequential keys");
        System.exit(2);
    }

    private void caclulateCacheSizes() {
        int nodeAvg = this.nodeMax * this.density / 100;
        long nBinEntries = this.records * (long)this.nodeMax / (long)nodeAvg;
        long nBinNodes = (nBinEntries + (long)this.nodeMax - 1L) / (long)this.nodeMax;
        long nInNodes = 0L;
        long lnSize = 0L;
        for (long n = nBinNodes; n > 0L; n /= (long)this.nodeMax) {
            nInNodes += n;
            ++this.nLevels;
        }
        this.minInBtreeSize = nInNodes * (long)this.calcInSize(this.nodeMax, nodeAvg, this.keySize, true);
        this.maxInBtreeSize = nInNodes * (long)this.calcInSize(this.nodeMax, nodeAvg, this.keySize, false);
        this.minInCacheSize = this.calculateOverhead(this.minInBtreeSize, this.overhead);
        this.maxInCacheSize = this.calculateOverhead(this.maxInBtreeSize, this.overhead);
        if (this.dataSize >= 0) {
            lnSize = this.records * (long)this.calcLnSize(this.dataSize);
        }
        this.maxInBtreeSizeWithData = this.maxInBtreeSize + lnSize;
        this.maxInCacheSizeWithData = this.calculateOverhead(this.maxInBtreeSizeWithData, this.overhead);
        this.minInBtreeSizeWithData = this.minInBtreeSize + lnSize;
        this.minInCacheSizeWithData = this.calculateOverhead(this.minInBtreeSizeWithData, this.overhead);
    }

    private void printCacheSizes(PrintStream out) {
        out.println("Inputs: records=" + this.records + " keySize=" + this.keySize + " dataSize=" + this.dataSize + " nodeMax=" + this.nodeMax + " density=" + this.density + '%' + " overhead=" + (this.overhead > 0L ? this.overhead : 10L) + "%");
        out.println();
        out.println(HEADER);
        out.println(this.line(this.minInBtreeSize, this.minInCacheSize, "Minimum, internal nodes only"));
        out.println(this.line(this.maxInBtreeSize, this.maxInCacheSize, "Maximum, internal nodes only"));
        if (this.dataSize >= 0) {
            out.println(this.line(this.minInBtreeSizeWithData, this.minInCacheSizeWithData, "Minimum, internal nodes and leaf nodes"));
            out.println(this.line(this.maxInBtreeSizeWithData, this.maxInCacheSizeWithData, "Maximum, internal nodes and leaf nodes"));
        } else {
            out.println("\nTo get leaf node sizing specify -data");
        }
        out.println("\nBtree levels: " + this.nLevels);
    }

    private int calcInSize(int nodeMax, int nodeAvg, int keySize, boolean lsnCompression) {
        int size = MemoryBudget.IN_FIXED_OVERHEAD;
        size += MemoryBudget.byteArraySize(nodeMax) + nodeMax * (2 * MemoryBudget.OBJECT_ARRAY_ITEM_OVERHEAD);
        size = lsnCompression ? (size += MemoryBudget.byteArraySize(nodeMax * 2)) : (size += MemoryBudget.ARRAY_OVERHEAD + nodeMax * MemoryBudget.LONG_OVERHEAD);
        return size += (nodeAvg + 1) * MemoryBudget.byteArraySize(keySize);
    }

    private int calcLnSize(int dataSize) {
        return MemoryBudget.LN_OVERHEAD + MemoryBudget.byteArraySize(dataSize);
    }

    private long calculateOverhead(long btreeSize, long overhead) {
        long cacheSize = overhead == 0L ? 100L * btreeSize / 90L : btreeSize + overhead;
        return cacheSize;
    }

    private String line(long btreeSize, long cacheSize, String comment) {
        StringBuffer buf = new StringBuffer(100);
        this.column(buf, INT_FORMAT.format(cacheSize));
        this.column(buf, INT_FORMAT.format(btreeSize));
        this.column(buf, comment);
        return buf.toString();
    }

    private void column(StringBuffer buf, String str) {
        int start = buf.length();
        while (buf.length() - start + str.length() < 14) {
            buf.append(' ');
        }
        buf.append(str);
        for (int i = 0; i < 2; ++i) {
            buf.append(' ');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void measure(PrintStream out, File dir, long records, int keySize, int dataSize, int nodeMax, boolean randomKeys) throws Exception {
        String[] fileNames = dir.list();
        if (fileNames != null && fileNames.length > 0) {
            DbCacheSize.usage("Directory is not empty: " + dir);
        }
        Environment env = DbCacheSize.openEnvironment(dir, true);
        Database db = DbCacheSize.openDatabase(env, nodeMax, true);
        try {
            out.println("\nMeasuring with cache size: " + INT_FORMAT.format(env.getConfig().getCacheSize()));
            DbCacheSize.insertRecords(out, env, db, records, keySize, dataSize, randomKeys);
            DbCacheSize.printStats(out, env, "Stats for internal and leaf nodes (after insert)");
            db.close();
            env.close();
            env = DbCacheSize.openEnvironment(dir, false);
            db = DbCacheSize.openDatabase(env, nodeMax, false);
            out.println("\nPreloading with cache size: " + INT_FORMAT.format(env.getConfig().getCacheSize()));
            DbCacheSize.preloadRecords(out, db);
            DbCacheSize.printStats(out, env, "Stats for internal nodes only (after preload)");
            Object var12_10 = null;
        }
        catch (Throwable throwable) {
            Object var12_11 = null;
            try {
                db.close();
                env.close();
            }
            catch (Exception e) {
                out.println("During close: " + e);
            }
            throw throwable;
        }
        try {
            db.close();
            env.close();
        }
        catch (Exception e) {
            out.println("During close: " + e);
        }
    }

    private static Environment openEnvironment(File dir, boolean allowCreate) throws Exception {
        EnvironmentConfig envConfig = new EnvironmentConfig();
        envConfig.setAllowCreate(allowCreate);
        envConfig.setCachePercent(90);
        return new Environment(dir, envConfig);
    }

    private static Database openDatabase(Environment env, int nodeMax, boolean allowCreate) throws Exception {
        DatabaseConfig dbConfig = new DatabaseConfig();
        dbConfig.setAllowCreate(allowCreate);
        dbConfig.setNodeMaxEntries(nodeMax);
        return env.openDatabase(null, "foo", dbConfig);
    }

    private static void insertRecords(PrintStream out, Environment env, Database db, long records, int keySize, int dataSize, boolean randomKeys) throws Exception {
        DatabaseEntry key = new DatabaseEntry();
        DatabaseEntry data = new DatabaseEntry(new byte[dataSize]);
        BigInteger bigInt = BigInteger.ZERO;
        Random rnd = new Random(123L);
        int i = 0;
        while ((long)i < records) {
            byte[] a;
            if (randomKeys) {
                a = new byte[keySize];
                rnd.nextBytes(a);
                key.setData(a);
            } else {
                a = (bigInt = bigInt.add(BigInteger.ONE)).toByteArray();
                if (a.length < keySize) {
                    byte[] a2 = new byte[keySize];
                    System.arraycopy(a, 0, a2, a2.length - a.length, a.length);
                    a = a2;
                } else if (a.length > keySize) {
                    out.println("*** Key doesn't fit value=" + bigInt + " byte length=" + a.length);
                    return;
                }
                key.setData(a);
            }
            OperationStatus status = db.putNoOverwrite(null, key, data);
            if (status == OperationStatus.KEYEXIST && randomKeys) {
                --i;
                out.println("Random key already exists -- retrying");
            } else {
                if (status != OperationStatus.SUCCESS) {
                    out.println("*** " + (Object)((Object)status));
                    return;
                }
                if (i % 10000 == 0) {
                    EnvironmentStats stats = env.getStats(null);
                    if (stats.getNNodesScanned() > 0L) {
                        out.println("*** Ran out of cache memory at record " + i + " -- try increasing the Java heap size ***");
                        return;
                    }
                    out.print(".");
                    out.flush();
                }
            }
            ++i;
        }
    }

    private static void preloadRecords(final PrintStream out, Database db) throws Exception {
        Thread thread = new Thread(){

            public void run() {
                try {
                    while (true) {
                        out.print(".");
                        out.flush();
                        Thread.sleep(5000L);
                    }
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        };
        thread.start();
        db.preload(null);
        thread.interrupt();
        try {
            thread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace(out);
        }
    }

    private static void printStats(PrintStream out, Environment env, String msg) throws Exception {
        out.println();
        out.println(msg + ':');
        EnvironmentStats stats = env.getStats(null);
        out.println("CacheSize=" + INT_FORMAT.format(stats.getCacheTotalBytes()) + " BtreeSize=" + INT_FORMAT.format(stats.getDataBytes()) + " NCacheMiss=" + INT_FORMAT.format(stats.getNCacheMiss()));
        if (stats.getNNodesScanned() > 0L) {
            out.println("*** All records did not fit in the cache ***");
        }
    }
}

