/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.stream;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.entry.LogEntry;
import com.sleepycat.je.recovery.CheckpointEnd;
import com.sleepycat.je.rep.impl.node.NameIdPair;
import com.sleepycat.je.rep.stream.OutputWireRecord;
import com.sleepycat.je.rep.stream.VLSNReader;
import com.sleepycat.je.rep.vlsn.VLSNIndex;
import com.sleepycat.je.rep.vlsn.VLSNRange;
import com.sleepycat.je.utilint.VLSN;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ReplicaSyncupReader
extends VLSNReader {
    private boolean syncableSearch;
    private final byte CKPT_END = LogEntryType.LOG_CKPT_END.getTypeNum();
    private final LogEntry logEntry = LogEntryType.LOG_CKPT_END.getNewLogEntry();
    private boolean passedCheckpointEnd = false;

    public ReplicaSyncupReader(EnvironmentImpl envImpl, VLSNIndex vlsnIndex, long endOfLogLsn, int readBufferSize, NameIdPair nameIdPair, VLSN startVLSN, long finishLsn) throws IOException, DatabaseException {
        super(envImpl, vlsnIndex, false, endOfLogLsn, readBufferSize, nameIdPair, finishLsn);
        this.initScan(startVLSN, endOfLogLsn);
    }

    private void initScan(VLSN startVLSN, long endOfLogLsn) throws IOException {
        if (startVLSN.equals(VLSN.NULL_VLSN)) {
            throw EnvironmentFailureException.unexpectedState("ReplicaSyncupReader start can't be NULL_VLSN");
        }
        this.startLsn = endOfLogLsn;
        assert (this.startLsn != -1L);
        this.envImpl.getLogManager().flush();
        this.window.initAtFileStart(this.startLsn);
        this.currentEntryPrevOffset = this.window.getEndOffset();
        this.currentEntryOffset = this.window.getEndOffset();
        this.currentVLSN = startVLSN;
    }

    public OutputWireRecord scanBackwards(VLSN vlsn) throws DatabaseException {
        this.syncableSearch = false;
        VLSNRange range = this.vlsnIndex.getRange();
        if (vlsn.compareTo(range.getFirst()) < 0) {
            return null;
        }
        this.currentVLSN = vlsn;
        if (this.readNextEntry()) {
            return this.currentFeedRecord;
        }
        return null;
    }

    public OutputWireRecord findPrevSyncEntry() throws DatabaseException {
        this.currentFeedRecord = null;
        this.syncableSearch = true;
        this.currentVLSN = this.currentVLSN.getPrev();
        VLSNRange range = this.vlsnIndex.getRange();
        if (this.currentVLSN.compareTo(range.getFirst()) < 0) {
            return null;
        }
        if (!this.readNextEntry()) {
            return null;
        }
        assert (LogEntryType.isSyncPoint(this.currentFeedRecord.getEntryType())) : "Unexpected log type= " + this.currentFeedRecord;
        return this.currentFeedRecord;
    }

    private void checkForPassingTarget(int compareResult) {
        if (compareResult < 0) {
            throw EnvironmentFailureException.unexpectedState("want to read " + this.currentVLSN + " but reader at " + this.currentEntryHeader.getVLSN());
        }
    }

    protected boolean isTargetEntry() throws DatabaseException {
        ++this.nScanned;
        if (this.currentEntryHeader.isInvisible()) {
            return false;
        }
        if (this.entryIsReplicated()) {
            VLSN entryVLSN = this.currentEntryHeader.getVLSN();
            if (this.syncableSearch) {
                if (LogEntryType.isSyncPoint(this.currentEntryHeader.getType())) {
                    return true;
                }
                this.currentVLSN = entryVLSN.getPrev();
            } else {
                int compareResult = entryVLSN.compareTo(this.currentVLSN);
                this.checkForPassingTarget(compareResult);
                return compareResult == 0;
            }
        }
        return this.currentEntryHeader.getType() == this.CKPT_END;
    }

    protected boolean processEntry(ByteBuffer entryBuffer) {
        if (this.currentEntryHeader.getType() == this.CKPT_END) {
            this.logEntry.readEntry(this.currentEntryHeader, entryBuffer, true);
            if (((CheckpointEnd)this.logEntry.getMainItem()).getCleanedFilesToDelete()) {
                this.passedCheckpointEnd = true;
            }
            return false;
        }
        ByteBuffer buffer = entryBuffer.slice();
        buffer.limit(this.currentEntryHeader.getItemSize());
        this.currentFeedRecord = new OutputWireRecord(this.currentEntryHeader, buffer);
        entryBuffer.position(entryBuffer.position() + this.currentEntryHeader.getItemSize());
        return true;
    }

    boolean getPassedCheckpointEnd() {
        return this.passedCheckpointEnd;
    }
}

