/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.monitor;

import com.sleepycat.je.rep.impl.RepGroupImpl;
import com.sleepycat.je.rep.impl.RepImpl;
import com.sleepycat.je.rep.impl.RepParams;
import com.sleepycat.je.rep.impl.TextProtocol;
import com.sleepycat.je.rep.impl.node.NameIdPair;

public class Protocol
extends TextProtocol {
    public static final String VERSION = "1.0";
    public final TextProtocol.MessageOp GROUP_CHANGE_REQ = new TextProtocol.MessageOp("GCHG", GroupChange.class);

    public Protocol(String groupName, NameIdPair nameIdPair, RepImpl repImpl) {
        super(VERSION, groupName, nameIdPair, repImpl);
        this.initializeMessageOps(new TextProtocol.MessageOp[]{this.GROUP_CHANGE_REQ});
        this.setTimeouts(repImpl, RepParams.MONITOR_OPEN_TIMEOUT, RepParams.MONITOR_READ_TIMEOUT);
    }

    public class GroupChange
    extends TextProtocol.RequestMessage {
        final RepGroupImpl group;

        public GroupChange(RepGroupImpl group) {
            this.group = group;
        }

        public GroupChange(String line, String[] tokens) throws TextProtocol.InvalidMessageException {
            super(line, tokens);
            this.group = RepGroupImpl.deserializeHex(tokens, TextProtocol.TOKENS.FIRST_PAYLOAD_TOKEN.ordinal());
        }

        public RepGroupImpl getGroup() {
            return this.group;
        }

        public TextProtocol.MessageOp getOp() {
            return Protocol.this.GROUP_CHANGE_REQ;
        }

        protected String getMessagePrefix() {
            return Protocol.this.messagePrefixNocheck;
        }

        public String wireFormat() {
            return this.wireFormatPrefix() + "|" + this.group.serializeHex();
        }
    }
}

