/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.monitor;

import com.sleepycat.je.rep.ReplicationGroup;
import com.sleepycat.je.rep.impl.TextProtocol;
import com.sleepycat.je.rep.monitor.Monitor;
import com.sleepycat.je.rep.monitor.Protocol;
import com.sleepycat.je.rep.utilint.ReplicationFormatter;
import com.sleepycat.je.rep.utilint.ServiceDispatcher;
import com.sleepycat.je.utilint.LoggerUtils;
import java.io.IOException;
import java.nio.channels.SocketChannel;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MonitorService
extends ServiceDispatcher.ExecutingService {
    private final Monitor monitor;
    private final Protocol protocol;
    private final Logger logger;
    private final Formatter formatter;
    public static final String SERVICE_NAME = "Monitor";

    public MonitorService(Monitor monitor, ServiceDispatcher dispatcher) {
        super(SERVICE_NAME, dispatcher);
        this.monitor = monitor;
        this.protocol = new Protocol(monitor.getGroupName(), monitor.getMonitorNameIdPair(), null);
        this.logger = LoggerUtils.getLoggerFormatterNeeded(this.getClass());
        this.formatter = new ReplicationFormatter(monitor.getMonitorNameIdPair());
    }

    public TextProtocol.ResponseMessage process(Protocol.GroupChange groupChange) {
        this.monitor.notify(new ReplicationGroup(groupChange.getGroup()));
        return null;
    }

    public Runnable getRunnable(SocketChannel socketChannel) {
        return new MonitorServiceRunnable(socketChannel);
    }

    class MonitorServiceRunnable
    implements Runnable {
        final SocketChannel channel;

        MonitorServiceRunnable(SocketChannel socketChannel) {
            this.channel = socketChannel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block12: {
                block11: {
                    try {
                        try {
                            this.channel.configureBlocking(true);
                            TextProtocol.RequestMessage requestMessage = MonitorService.this.protocol.getRequestMessage(this.channel);
                            if (requestMessage == null) {
                                Object var4_3 = null;
                                break block11;
                            }
                            TextProtocol.ResponseMessage responseMessage = MonitorService.this.protocol.process(MonitorService.this, requestMessage);
                            assert (responseMessage == null);
                            break block12;
                        }
                        catch (IOException e) {
                            LoggerUtils.logMsg(MonitorService.this.logger, MonitorService.this.formatter, Level.WARNING, "IO error on socket: " + e.getMessage());
                            Object var4_5 = null;
                            if (!this.channel.isOpen()) return;
                            try {
                                this.channel.close();
                                return;
                            }
                            catch (IOException e2) {
                                LoggerUtils.logMsg(MonitorService.this.logger, MonitorService.this.formatter, Level.WARNING, "IO error on channel close: " + e2.getMessage());
                                return;
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        Object var4_6 = null;
                        if (!this.channel.isOpen()) throw throwable;
                        try {}
                        catch (IOException e2) {
                            LoggerUtils.logMsg(MonitorService.this.logger, MonitorService.this.formatter, Level.WARNING, "IO error on channel close: " + e2.getMessage());
                            return;
                        }
                        this.channel.close();
                        throw throwable;
                    }
                }
                if (!this.channel.isOpen()) return;
                try {}
                catch (IOException e2) {
                    LoggerUtils.logMsg(MonitorService.this.logger, MonitorService.this.formatter, Level.WARNING, "IO error on channel close: " + e2.getMessage());
                    return;
                }
                this.channel.close();
                return;
            }
            Object var4_4 = null;
            if (!this.channel.isOpen()) return;
            try {}
            catch (IOException e2) {
                LoggerUtils.logMsg(MonitorService.this.logger, MonitorService.this.formatter, Level.WARNING, "IO error on channel close: " + e2.getMessage());
                return;
            }
            this.channel.close();
        }
    }
}

