/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.bufr.tables;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.unidata.util.StringUtil;

public class CodeFlagTables {
    private static Logger log = LoggerFactory.getLogger(CodeFlagTables.class);
    static Map<Short, CodeFlagTables> tableMap;
    private static boolean showReadErrs;
    private static boolean showNameDiff;
    private short fxy;
    private String name;
    private Map<Integer, String> map;

    public static CodeFlagTables getTable(short id) {
        if (tableMap == null) {
            CodeFlagTables.init();
        }
        return tableMap.get(id);
    }

    public static boolean hasTable(short id) {
        CodeFlagTables result;
        if (tableMap == null) {
            CodeFlagTables.init();
        }
        return (result = tableMap.get(id)) != null;
    }

    private static void init() {
        tableMap = new HashMap<Short, CodeFlagTables>(300);
        CodeFlagTables.init2(tableMap);
    }

    private static void initOld(Map<Short, CodeFlagTables> table) {
        String filename = "/resources/bufrTables/wmo/Code-FlagTables.xml";
        InputStream is = CodeFlagTables.class.getResourceAsStream(filename);
        try {
            SAXBuilder builder = new SAXBuilder();
            Document tdoc = builder.build(is);
            Element root = tdoc.getRootElement();
            for (Element elem : root.getChildren("table")) {
                List cElems;
                String kind = elem.getAttributeValue("kind");
                if (kind == null || !kind.equals("code") || (cElems = elem.getChildren("code")).size() == 0) continue;
                String name = elem.getAttributeValue("name");
                String desc = elem.getAttributeValue("desc");
                CodeFlagTables ct = new CodeFlagTables(CodeFlagTables.getFxy(name), desc);
                table.put(ct.fxy, ct);
                for (Element cElem : cElems) {
                    String valueS = cElem.getAttributeValue("value").trim();
                    String text = cElem.getText();
                    if (text.toLowerCase().startsWith("reserved") || text.toLowerCase().startsWith("not used")) continue;
                    try {
                        int value = Integer.parseInt(valueS);
                        ct.addValue(value, text);
                    }
                    catch (NumberFormatException e) {
                        log.warn("NumberFormatException on '" + valueS + "' for CodeTable " + name + " in " + filename);
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("Can't read BUFR code table " + filename, (Throwable)e);
        }
    }

    private static short getFxy(String name) {
        try {
            String[] tok = name.split(" ");
            int f = tok.length > 0 ? Integer.parseInt(tok[0]) : 0;
            int x = tok.length > 1 ? Integer.parseInt(tok[1]) : 0;
            int y = tok.length > 2 ? Integer.parseInt(tok[2]) : 0;
            return (short)((f << 14) + (x << 8) + y);
        }
        catch (NumberFormatException e) {
            log.warn("Illegal table name=" + name);
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void init2(Map<Short, CodeFlagTables> table) {
        String filename = "/resources/bufrTables/wmo/BC_CodeFlagTable.csv";
        BufferedReader dataIS = null;
        try {
            String line;
            InputStream is = CodeFlagTables.class.getResourceAsStream(filename);
            dataIS = new BufferedReader(new InputStreamReader(is, Charset.forName("UTF8")));
            int count = 0;
            while ((line = dataIS.readLine()) != null) {
                String[] flds;
                if (line.startsWith("#")) continue;
                if (++count == 1) {
                    if (!showReadErrs) continue;
                    System.out.println("header line == " + line);
                    continue;
                }
                int pos1 = line.indexOf(34);
                if (pos1 >= 0) {
                    int pos2 = line.indexOf(34, pos1 + 1);
                    StringBuffer sb = new StringBuffer(line);
                    for (int i = pos1; i < pos2; ++i) {
                        if (sb.charAt(i) != ',') continue;
                        sb.setCharAt(i, ' ');
                    }
                    line = sb.toString();
                }
                if ((flds = line.split(",")).length < 4) {
                    if (!showReadErrs) continue;
                    System.out.printf("%d BAD split == %s%n", count, line);
                    continue;
                }
                int fldidx = 0;
                try {
                    String name;
                    String nameLow;
                    int sno = Integer.parseInt(flds[fldidx++].trim());
                    int xy = Integer.parseInt(flds[fldidx++].trim());
                    int no = -1;
                    try {
                        no = Integer.parseInt(flds[fldidx++].trim());
                    }
                    catch (Exception e) {
                        if (!showReadErrs) continue;
                        System.out.printf("%d skip == %s%n", count, line);
                        continue;
                    }
                    if ((nameLow = (name = StringUtil.remove((String)flds[fldidx++], (int)34)).toLowerCase()).startsWith("reserved") || nameLow.startsWith("not used")) continue;
                    int x = xy / 1000;
                    int y = xy % 1000;
                    int fxy = (x << 8) + y;
                    CodeFlagTables ct = table.get((short)fxy);
                    if (ct == null) {
                        ct = new CodeFlagTables((short)fxy, null);
                        table.put(ct.fxy, ct);
                    }
                    ct.addValue(no, name);
                }
                catch (Exception e) {
                    if (!showReadErrs) continue;
                    System.out.printf("%d %d BAD line == %s%n", count, fldidx, line);
                }
            }
        }
        catch (Exception e) {
            log.error("Can't read BUFR code table " + filename, (Throwable)e);
        }
        finally {
            if (dataIS != null) {
                try {
                    dataIS.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void main(String[] arg) throws IOException {
        CodeFlagTables t;
        HashMap<Short, CodeFlagTables> tableMap1 = new HashMap<Short, CodeFlagTables>(300);
        CodeFlagTables.initOld(tableMap1);
        HashMap<Short, CodeFlagTables> tableMap2 = new HashMap<Short, CodeFlagTables>(300);
        CodeFlagTables.init2(tableMap2);
        System.out.printf("Compare 1 with 2%n", new Object[0]);
        for (Short key : tableMap1.keySet()) {
            t = tableMap1.get(key);
            CodeFlagTables t2 = tableMap2.get(key);
            if (t2 == null) {
                System.out.printf(" NOT FOUND in 2: %s (%d)%n", t.fxy(), t.fxy);
                continue;
            }
            for (Integer no : t.map.keySet()) {
                String name1 = t.map.get(no);
                String name2 = t2.map.get(no);
                if (name2 == null) {
                    System.out.printf(" %s val %d name '%s' missing%n", t.fxy(), no, name1);
                    continue;
                }
                if (!showNameDiff || name1.equals(name2)) continue;
                System.out.printf(" %s names different%n  %s%n  %s%n", t.fxy(), name1, name2);
            }
        }
        System.out.printf("Compare 2 with 1%n", new Object[0]);
        for (Short key : tableMap2.keySet()) {
            t = tableMap2.get(key);
            CodeFlagTables t1 = tableMap1.get(key);
            if (t1 == null) {
                System.out.printf(" NOT FOUND in 1: %s (%d)%n", t.fxy(), t.fxy);
                continue;
            }
            for (Integer no : t.map.keySet()) {
                String name = t.map.get(no);
                String name1 = t1.map.get(no);
                if (name1 == null) {
                    System.out.printf(" %s val %d name '%s' missing%n", t.fxy(), no, name);
                    continue;
                }
                if (!showNameDiff || name.equals(name1)) continue;
                System.out.printf(" %s names different%n  %s%n  %s%n", t.fxy(), name, name1);
            }
        }
    }

    private CodeFlagTables(short fxy, String name) {
        this.fxy = fxy;
        this.name = name == null ? this.fxy() : StringUtil.replace((String)name, (char)' ', (String)"_") + "(" + this.fxy() + ")";
        this.map = new HashMap<Integer, String>(20);
    }

    public String getName() {
        return this.name;
    }

    public Map<Integer, String> getMap() {
        return this.map;
    }

    private void addValue(int value, String text) {
        this.map.put(value, text);
    }

    String fxy() {
        int f = this.fxy >> 16;
        int x = (this.fxy & 0xFF00) >> 8;
        int y = this.fxy & 0xFF;
        return f + "-" + x + "-" + y;
    }

    public String toString() {
        return this.name;
    }

    static {
        showReadErrs = false;
        showNameDiff = false;
    }
}

