/*
 * Decompiled with CFR 0.152.
 */
package opendap.servlet;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.zip.DeflaterOutputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import opendap.Server.CEEvaluator;
import opendap.Server.ServerDDS;
import opendap.dap.DAP2Exception;
import opendap.dap.DAS;
import opendap.dap.parsers.ParseException;
import opendap.servlet.AsciiWriter;
import opendap.servlet.BadURLException;
import opendap.servlet.GetDirHandler;
import opendap.servlet.GetHTMLInterfaceHandler;
import opendap.servlet.GetInfoHandler;
import opendap.servlet.GuardedDataset;
import opendap.servlet.Log;
import opendap.servlet.ReqState;
import opendap.util.Debug;
import ucar.unidata.util.EscapeStrings;

public abstract class AbstractServlet
extends HttpServlet {
    protected boolean allowDeflate = true;
    private boolean track = false;
    private Object syncLock = new Object();
    private int HitCounter = 0;
    private ArrayList prArr = null;

    public abstract String getServerVersion();

    protected abstract GuardedDataset getDataset(ReqState var1) throws DAP2Exception, IOException, ParseException;

    public void init() throws ServletException {
        super.init();
        String debugOn = this.getInitParameter("DebugOn");
        if (debugOn != null) {
            StringTokenizer toker = new StringTokenizer(debugOn);
            while (toker.hasMoreTokens()) {
                Debug.set(toker.nextToken(), true);
            }
        }
    }

    public void parseExceptionHandler(ParseException pe, HttpServletResponse response) {
        if (Debug.isSet("showException")) {
            System.out.println(pe);
            pe.printStackTrace();
            Log.printThrowable(pe);
        }
        try {
            BufferedOutputStream eOut = new BufferedOutputStream((OutputStream)response.getOutputStream());
            response.setHeader("Content-Description", "dods-error");
            response.setHeader("Content-Encoding", "");
            String msg = pe.getMessage().replace('\"', '\'');
            DAP2Exception de2 = new DAP2Exception(5, msg);
            de2.print(eOut);
        }
        catch (IOException ioe) {
            System.out.println("Cannot respond to client! IO Error: " + ioe.getMessage());
        }
    }

    public void dap2ExceptionHandler(DAP2Exception de, HttpServletResponse response) {
        if (Debug.isSet("showException")) {
            de.print(System.out);
            de.printStackTrace();
            Log.printDODSException(de);
        }
        try {
            BufferedOutputStream eOut = new BufferedOutputStream((OutputStream)response.getOutputStream());
            response.setHeader("Content-Description", "dods-error");
            response.setHeader("Content-Encoding", "");
            de.print(eOut);
        }
        catch (IOException ioe) {
            System.out.println("Cannot respond to client! IO Error: " + ioe.getMessage());
        }
    }

    public void IOExceptionHandler(IOException e, HttpServletResponse response, ReqState rs) {
        try {
            BufferedOutputStream eOut = new BufferedOutputStream((OutputStream)response.getOutputStream());
            response.setHeader("Content-Description", "dods-error");
            response.setHeader("Content-Encoding", "");
            String msg = e.getMessage();
            if (msg != null) {
                msg = msg.replace('\"', '\'');
            }
            DAP2Exception de2 = new DAP2Exception(5, msg);
            de2.print(eOut);
            if (Debug.isSet("showException")) {
                System.out.println("DODServlet ERROR (IOExceptionHandler): " + e);
                System.out.println(rs);
                if (this.track) {
                    RequestDebug reqD = (RequestDebug)rs.getUserObject();
                    System.out.println("  request number: " + reqD.reqno + " thread: " + reqD.threadDesc);
                }
                e.printStackTrace();
                Log.printThrowable(e);
            }
        }
        catch (IOException ioe) {
            System.out.println("Cannot respond to client! IO Error: " + ioe.getMessage());
        }
    }

    public void anyExceptionHandler(Throwable e, HttpServletResponse response, ReqState rs) {
        try {
            System.out.println("DODServlet ERROR (anyExceptionHandler): " + e);
            System.out.println(rs);
            if (this.track) {
                RequestDebug reqD = (RequestDebug)rs.getUserObject();
                System.out.println("  request number: " + reqD.reqno + " thread: " + reqD.threadDesc);
            }
            e.printStackTrace();
            Log.printThrowable(e);
            BufferedOutputStream eOut = new BufferedOutputStream((OutputStream)response.getOutputStream());
            response.setHeader("Content-Description", "dods-error");
            response.setHeader("Content-Encoding", "");
            String msg = e.getMessage();
            if (msg != null) {
                msg = msg.replace('\"', '\'');
            }
            DAP2Exception de2 = new DAP2Exception(-1, msg);
            de2.print(eOut);
        }
        catch (IOException ioe) {
            System.out.println("Cannot respond to client! IO Error: " + ioe.getMessage());
        }
    }

    public void sendDODSError(HttpServletRequest request, HttpServletResponse response, String clientMsg, String serverMsg) throws IOException, ServletException {
        response.setContentType("text/plain");
        response.setHeader("XDODS-Server", this.getServerVersion());
        response.setHeader("Content-Description", "dods-error");
        ServletOutputStream Out = response.getOutputStream();
        DAP2Exception de = new DAP2Exception(0, clientMsg);
        de.print((OutputStream)Out);
        response.setStatus(200);
        System.out.println(serverMsg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGetDAS(HttpServletRequest request, HttpServletResponse response, ReqState rs) throws IOException, ServletException {
        if (Debug.isSet("showResponse")) {
            System.out.println("doGetDAS for dataset: " + rs.getDataSet());
        }
        GuardedDataset ds = null;
        try {
            ds = this.getDataset(rs);
            if (ds == null) {
                return;
            }
            response.setContentType("text/plain");
            response.setHeader("XDODS-Server", this.getServerVersion());
            response.setHeader("Content-Description", "dods-das");
            BufferedOutputStream Out = new BufferedOutputStream((OutputStream)response.getOutputStream());
            DAS myDAS = ds.getDAS();
            myDAS.print(Out);
            response.setStatus(200);
            if (Debug.isSet("showResponse")) {
                System.out.println("DAS=\n");
                myDAS.print(System.out);
            }
        }
        catch (DAP2Exception de) {
            this.dap2ExceptionHandler(de, response);
        }
        catch (ParseException pe) {
            this.parseExceptionHandler(pe, response);
        }
        catch (Throwable t) {
            this.anyExceptionHandler(t, response, rs);
        }
        finally {
            if (ds != null) {
                ds.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGetDDS(HttpServletRequest request, HttpServletResponse response, ReqState rs) throws IOException, ServletException {
        if (Debug.isSet("showResponse")) {
            System.out.println("doGetDDS for dataset: " + rs.getDataSet());
        }
        GuardedDataset ds = null;
        try {
            ds = this.getDataset(rs);
            if (null == ds) {
                return;
            }
            response.setContentType("text/plain");
            response.setHeader("XDODS-Server", this.getServerVersion());
            response.setHeader("Content-Description", "dods-dds");
            BufferedOutputStream Out = new BufferedOutputStream((OutputStream)response.getOutputStream());
            ServerDDS myDDS = ds.getDDS();
            if (rs.getConstraintExpression().equals("")) {
                myDDS.print(Out);
                ((OutputStream)Out).flush();
            } else {
                CEEvaluator ce = new CEEvaluator(myDDS);
                ce.parseConstraint(rs);
                PrintWriter pw = new PrintWriter(new OutputStreamWriter(Out));
                myDDS.printConstrained(pw);
                pw.flush();
            }
            response.setStatus(200);
            if (Debug.isSet("showResponse")) {
                if (rs.getConstraintExpression().equals("")) {
                    System.out.println("Unconstrained DDS=\n");
                    myDDS.print(System.out);
                } else {
                    System.out.println("Constrained DDS=\n");
                    myDDS.printConstrained(System.out);
                }
            }
        }
        catch (ParseException pe) {
            this.parseExceptionHandler(pe, response);
        }
        catch (DAP2Exception de) {
            this.dap2ExceptionHandler(de, response);
        }
        catch (IOException pe) {
            this.IOExceptionHandler(pe, response, rs);
        }
        catch (Throwable t) {
            this.anyExceptionHandler(t, response, rs);
        }
        finally {
            if (ds != null) {
                ds.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGetDDX(HttpServletRequest request, HttpServletResponse response, ReqState rs) throws IOException, ServletException {
        if (Debug.isSet("showResponse")) {
            System.out.println("doGetDDX for dataset: " + rs.getDataSet());
        }
        GuardedDataset ds = null;
        try {
            ds = this.getDataset(rs);
            if (null == ds) {
                return;
            }
            response.setContentType("text/plain");
            response.setHeader("XDODS-Server", this.getServerVersion());
            response.setHeader("Content-Description", "dods-ddx");
            BufferedOutputStream Out = new BufferedOutputStream((OutputStream)response.getOutputStream());
            ServerDDS myDDS = ds.getDDS();
            if (rs.getConstraintExpression().equals("")) {
                myDDS.printXML(Out);
                ((OutputStream)Out).flush();
            } else {
                CEEvaluator ce = new CEEvaluator(myDDS);
                ce.parseConstraint(rs);
                PrintWriter pw = new PrintWriter(new OutputStreamWriter(Out));
                myDDS.printConstrainedXML(pw);
                pw.flush();
            }
            response.setStatus(200);
            if (Debug.isSet("showResponse")) {
                if (rs.getConstraintExpression().equals("")) {
                    System.out.println("Unconstrained DDX=\n");
                    myDDS.printXML(System.out);
                } else {
                    System.out.println("Constrained DDX=\n");
                    myDDS.printConstrainedXML(System.out);
                }
            }
        }
        catch (ParseException pe) {
            this.parseExceptionHandler(pe, response);
        }
        catch (DAP2Exception de) {
            this.dap2ExceptionHandler(de, response);
        }
        catch (IOException pe) {
            this.IOExceptionHandler(pe, response, rs);
        }
        catch (Throwable t) {
            this.anyExceptionHandler(t, response, rs);
        }
        finally {
            if (ds != null) {
                ds.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGetBLOB(HttpServletRequest request, HttpServletResponse response, ReqState rs) throws IOException, ServletException {
        if (Debug.isSet("showResponse")) {
            System.out.println("doGetBLOB For: " + rs.getDataSet());
        }
        GuardedDataset ds = null;
        try {
            BufferedOutputStream bOut;
            ds = this.getDataset(rs);
            if (null == ds) {
                return;
            }
            response.setContentType("application/octet-stream");
            response.setHeader("XDODS-Server", this.getServerVersion());
            response.setHeader("Content-Description", "dods-blob");
            ServletOutputStream sOut = response.getOutputStream();
            DeflaterOutputStream dOut = null;
            if (rs.getAcceptsCompressed() && this.allowDeflate) {
                response.setHeader("Content-Encoding", "deflate");
                dOut = new DeflaterOutputStream((OutputStream)sOut);
                bOut = new BufferedOutputStream(dOut);
            } else {
                bOut = new BufferedOutputStream((OutputStream)sOut);
            }
            ServerDDS myDDS = ds.getDDS();
            CEEvaluator ce = new CEEvaluator(myDDS);
            ce.parseConstraint(rs.getConstraintExpression(), rs.getRequestURL().toString());
            DataOutputStream sink = new DataOutputStream(bOut);
            ce.send(myDDS.getEncodedName(), sink, ds);
            sink.flush();
            if (null != dOut) {
                dOut.finish();
            }
            ((OutputStream)bOut).flush();
            response.setStatus(200);
        }
        catch (ParseException pe) {
            this.parseExceptionHandler(pe, response);
        }
        catch (DAP2Exception de) {
            this.dap2ExceptionHandler(de, response);
        }
        catch (IOException ioe) {
            this.IOExceptionHandler(ioe, response, rs);
        }
        finally {
            if (ds != null) {
                ds.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGetDAP2Data(HttpServletRequest request, HttpServletResponse response, ReqState rs) throws IOException, ServletException {
        if (Debug.isSet("showResponse")) {
            System.out.println("doGetDAP2Data For: " + rs.getDataSet());
        }
        GuardedDataset ds = null;
        try {
            BufferedOutputStream bOut;
            ds = this.getDataset(rs);
            if (null == ds) {
                return;
            }
            response.setContentType("application/octet-stream");
            response.setHeader("XDODS-Server", this.getServerVersion());
            response.setHeader("Content-Description", "dods-data");
            ServletOutputStream sOut = response.getOutputStream();
            DeflaterOutputStream dOut = null;
            if (rs.getAcceptsCompressed() && this.allowDeflate) {
                response.setHeader("Content-Encoding", "deflate");
                dOut = new DeflaterOutputStream((OutputStream)sOut);
                bOut = new BufferedOutputStream(dOut);
            } else {
                bOut = new BufferedOutputStream((OutputStream)sOut);
            }
            ServerDDS myDDS = ds.getDDS();
            CEEvaluator ce = new CEEvaluator(myDDS);
            ce.parseConstraint(rs);
            PrintWriter pw = new PrintWriter(new OutputStreamWriter(bOut));
            myDDS.printConstrained(pw);
            pw.flush();
            ((OutputStream)bOut).write("\nData:\n".getBytes());
            ((OutputStream)bOut).flush();
            DataOutputStream sink = new DataOutputStream(bOut);
            ce.send(myDDS.getEncodedName(), sink, ds);
            sink.flush();
            if (null != dOut) {
                dOut.finish();
            }
            ((OutputStream)bOut).flush();
            response.setStatus(200);
        }
        catch (ParseException pe) {
            this.parseExceptionHandler(pe, response);
        }
        catch (DAP2Exception de) {
            this.dap2ExceptionHandler(de, response);
        }
        catch (IOException ioe) {
            this.IOExceptionHandler(ioe, response, rs);
        }
        finally {
            if (ds != null) {
                ds.release();
            }
        }
    }

    public void doGetDIR(HttpServletRequest request, HttpServletResponse response, ReqState rs) throws IOException, ServletException {
        response.setHeader("XDODS-Server", this.getServerVersion());
        response.setContentType("text/html");
        response.setHeader("Content-Description", "dods-directory");
        try {
            GetDirHandler di = new GetDirHandler();
            di.sendDIR(request, response, rs);
            response.setStatus(200);
        }
        catch (ParseException pe) {
            this.parseExceptionHandler(pe, response);
        }
        catch (DAP2Exception de) {
            this.dap2ExceptionHandler(de, response);
        }
        catch (Throwable t) {
            this.anyExceptionHandler(t, response, rs);
        }
    }

    public void doGetVER(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (Debug.isSet("showResponse")) {
            System.out.println("Sending Version Tag.");
        }
        response.setContentType("text/plain");
        response.setHeader("XDODS-Server", this.getServerVersion());
        response.setHeader("Content-Description", "dods-version");
        PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)response.getOutputStream()));
        pw.println("Server Version: " + this.getServerVersion());
        pw.flush();
        response.setStatus(200);
    }

    public void doGetHELP(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (Debug.isSet("showResponse")) {
            System.out.println("Sending Help Page.");
        }
        response.setContentType("text/html");
        response.setHeader("XDODS-Server", this.getServerVersion());
        response.setHeader("Content-Description", "dods-help");
        PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)response.getOutputStream()));
        this.printHelpPage(pw);
        pw.flush();
        response.setStatus(200);
    }

    public void badURL(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (Debug.isSet("showResponse")) {
            System.out.println("Sending Bad URL Page.");
        }
        response.setContentType("text/html");
        response.setHeader("XDODS-Server", this.getServerVersion());
        response.setHeader("Content-Description", "dods-error");
        PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)response.getOutputStream()));
        this.printBadURLPage(pw);
        this.printHelpPage(pw);
        pw.flush();
        response.setStatus(200);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGetASC(HttpServletRequest request, HttpServletResponse response, ReqState rs) throws Exception {
        if (Debug.isSet("showResponse")) {
            System.out.println("doGetASC For: " + rs.getDataSet());
        }
        GuardedDataset ds = null;
        try {
            ds = this.getDataset(rs);
            if (ds == null) {
                return;
            }
            response.setHeader("XDODS-Server", this.getServerVersion());
            response.setContentType("text/plain");
            response.setHeader("Content-Description", "dods-ascii");
            boolean debug = false;
            if (debug) {
                System.out.println("Sending OPeNDAP ASCII Data For: " + rs + "  CE: '" + rs.getConstraintExpression() + "'");
            }
            ServerDDS dds = ds.getDDS();
            CEEvaluator ce = new CEEvaluator(dds);
            ce.parseConstraint(rs);
            PrintWriter pw = new PrintWriter((OutputStream)response.getOutputStream());
            dds.printConstrained(pw);
            pw.println("---------------------------------------------");
            AsciiWriter writer = new AsciiWriter();
            writer.toASCII(pw, dds, ds);
            pw.flush();
            response.setStatus(200);
        }
        catch (ParseException pe) {
            this.parseExceptionHandler(pe, response);
        }
        catch (DAP2Exception de) {
            this.dap2ExceptionHandler(de, response);
        }
        catch (Throwable t) {
            this.anyExceptionHandler(t, response, rs);
        }
        finally {
            if (ds != null) {
                ds.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGetINFO(HttpServletRequest request, HttpServletResponse response, ReqState rs) throws IOException, ServletException {
        if (Debug.isSet("showResponse")) {
            System.out.println("doGetINFO For: " + rs.getDataSet());
        }
        GuardedDataset ds = null;
        try {
            ds = this.getDataset(rs);
            if (null == ds) {
                return;
            }
            PrintStream pw = new PrintStream((OutputStream)response.getOutputStream());
            response.setHeader("XDODS-Server", this.getServerVersion());
            response.setContentType("text/html");
            response.setHeader("Content-Description", "dods-description");
            GetInfoHandler di = new GetInfoHandler();
            di.sendINFO(pw, ds, rs);
            response.setStatus(200);
        }
        catch (ParseException pe) {
            this.parseExceptionHandler(pe, response);
        }
        catch (DAP2Exception de) {
            this.dap2ExceptionHandler(de, response);
        }
        catch (IOException pe) {
            this.IOExceptionHandler(pe, response, rs);
        }
        catch (Throwable t) {
            this.anyExceptionHandler(t, response, rs);
        }
        finally {
            if (ds != null) {
                ds.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGetHTML(HttpServletRequest request, HttpServletResponse response, ReqState rs) throws IOException, ServletException {
        GuardedDataset ds = null;
        try {
            ds = this.getDataset(rs);
            if (ds == null) {
                return;
            }
            response.setHeader("XDODS-Server", this.getServerVersion());
            response.setContentType("text/html");
            response.setHeader("Content-Description", "dods-form");
            ServerDDS myDDS = ds.getDDS();
            DAS das = ds.getDAS();
            GetHTMLInterfaceHandler di = new GetHTMLInterfaceHandler();
            di.sendDataRequestForm(request, response, rs.getDataSet(), myDDS, das);
            response.setStatus(200);
        }
        catch (ParseException pe) {
            this.parseExceptionHandler(pe, response);
        }
        catch (DAP2Exception de) {
            this.dap2ExceptionHandler(de, response);
        }
        catch (IOException pe) {
            this.IOExceptionHandler(pe, response, rs);
        }
        catch (Throwable t) {
            this.anyExceptionHandler(t, response, rs);
        }
        finally {
            if (ds != null) {
                ds.release();
            }
        }
    }

    public void doGetCatalog(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        response.setHeader("XDODS-Server", this.getServerVersion());
        response.setContentType("text/xml");
        response.setHeader("Content-Description", "dods-catalog");
        PrintWriter pw = new PrintWriter((OutputStream)response.getOutputStream());
        this.printCatalog(request, pw);
        pw.flush();
        response.setStatus(200);
    }

    protected void printCatalog(HttpServletRequest request, PrintWriter os) throws IOException {
        os.println("Catalog not available for this server");
        os.println("Server version = " + this.getServerVersion());
    }

    public void doDebug(HttpServletRequest request, HttpServletResponse response, ReqState rs) throws IOException {
        response.setHeader("XDODS-Server", this.getServerVersion());
        response.setContentType("text/html");
        response.setHeader("Content-Description", "dods_debug");
        PrintStream pw = new PrintStream((OutputStream)response.getOutputStream());
        pw.println("<title>Debugging</title>");
        pw.println("<body><pre>");
        StringTokenizer tz = new StringTokenizer(rs.getConstraintExpression(), "=;");
        while (tz.hasMoreTokens()) {
            String cmd = tz.nextToken();
            pw.println("Cmd= " + cmd);
            if (cmd.equals("help")) {
                pw.println(" help;log;logEnd;logShow");
                pw.println(" showFlags;showInitParameters;showRequest");
                pw.println(" on|off=(flagName)");
                this.doDebugCmd(cmd, tz, pw);
                continue;
            }
            if (cmd.equals("log")) {
                Log.reset();
                pw.println(" logging started");
                continue;
            }
            if (cmd.equals("logEnd")) {
                Log.close();
                pw.println(" logging ended");
                continue;
            }
            if (cmd.equals("logShow")) {
                pw.println(Log.getContents());
                pw.println("-----done logShow");
                continue;
            }
            if (cmd.equals("on")) {
                Debug.set(tz.nextToken(), true);
                continue;
            }
            if (cmd.equals("off")) {
                Debug.set(tz.nextToken(), false);
                continue;
            }
            if (cmd.equals("showFlags")) {
                for (String key : Debug.keySet()) {
                    pw.println("  " + key + " " + Debug.isSet(key));
                }
                continue;
            }
            if (cmd.equals("showInitParameters")) {
                pw.println(rs.toString());
                continue;
            }
            if (cmd.equals("showRequest")) {
                this.probeRequest(pw, request);
                continue;
            }
            if (this.doDebugCmd(cmd, tz, pw)) continue;
            pw.println("  unrecognized command");
        }
        pw.println("--------------------------------------");
        pw.println("Logging is " + (Log.isOn() ? "on" : "off"));
        for (String key : Debug.keySet()) {
            boolean val = Debug.isSet(key);
            if (!val) continue;
            pw.println("  " + key + " " + Debug.isSet(key));
        }
        pw.println("</pre></body>");
        pw.flush();
        response.setStatus(200);
    }

    protected boolean doDebugCmd(String cmd, StringTokenizer tz, PrintStream pw) {
        return false;
    }

    public void doGetSystemProps(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        response.setHeader("XDODS-Server", this.getServerVersion());
        response.setContentType("text/html");
        response.setHeader("Content-Description", "dods-status");
        PrintWriter pw = new PrintWriter((OutputStream)response.getOutputStream());
        pw.println("<html>");
        pw.println("<title>System Properties</title>");
        pw.println("<hr>");
        pw.println("<body><h2>System Properties</h2>");
        pw.println("<h3>Date: " + new Date() + "</h3>");
        Properties sysp = System.getProperties();
        Enumeration<?> e = sysp.propertyNames();
        pw.println("<ul>");
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = System.getProperty(name);
            pw.println("<li>" + name + ": " + value + "</li>");
        }
        pw.println("</ul>");
        pw.println("<h3>Runtime Info:</h3>");
        Runtime rt = Runtime.getRuntime();
        pw.println("JVM Max Memory:   " + (double)(rt.maxMemory() / 1024L) / 1000.0 + " MB (JVM Maximum Allowable Heap)<br>");
        pw.println("JVM Total Memory: " + (double)(rt.totalMemory() / 1024L) / 1000.0 + " MB (JVM Heap size)<br>");
        pw.println("JVM Free Memory:  " + (double)(rt.freeMemory() / 1024L) / 1000.0 + " MB (Unused part of heap)<br>");
        pw.println("JVM Used Memory:  " + (double)((rt.totalMemory() - rt.freeMemory()) / 1024L) / 1000.0 + " MB (Currently active memory)<br>");
        pw.println("<hr>");
        pw.println("</body>");
        pw.println("</html>");
        pw.flush();
        response.setStatus(200);
    }

    public void doGetStatus(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        response.setHeader("XDODS-Server", this.getServerVersion());
        response.setContentType("text/html");
        response.setHeader("Content-Description", "dods-status");
        PrintWriter pw = new PrintWriter((OutputStream)response.getOutputStream());
        pw.println("<title>Server Status</title>");
        pw.println("<body><ul>");
        this.printStatus(pw);
        pw.println("</ul></body>");
        pw.flush();
        response.setStatus(200);
    }

    protected void printStatus(PrintWriter os) throws IOException {
        os.println("<h2>Server version = " + this.getServerVersion() + "</h2>");
        os.println("<h2>Number of Requests Received = " + this.HitCounter + "</h2>");
        if (this.track) {
            int n = this.prArr.size();
            int pending = 0;
            String preqs = "";
            for (int i = 0; i < n; ++i) {
                ReqState rs = (ReqState)this.prArr.get(i);
                RequestDebug reqD = (RequestDebug)rs.getUserObject();
                if (rs == null || reqD.done) continue;
                preqs = preqs + "<pre>-----------------------\n";
                preqs = preqs + "Request[" + reqD.reqno + "](" + reqD.threadDesc + ") is pending.\n";
                preqs = preqs + rs.toString();
                preqs = preqs + "</pre>";
                ++pending;
            }
            os.println("<h2>" + pending + " Pending Request(s)</h2>");
            os.println(preqs);
        }
    }

    public void probeRequest(PrintStream ps, HttpServletRequest request) {
        String s;
        ps.println("####################### PROBE ##################################");
        ps.println("The HttpServletRequest object is actually a: " + request.getClass().getName());
        ps.println("");
        ps.println("HttpServletRequest Interface:");
        ps.println("    getAuthType:           " + request.getAuthType());
        ps.println("    getMethod:             " + request.getMethod());
        ps.println("    getPathInfo:           " + request.getPathInfo());
        ps.println("    getPathTranslated:     " + request.getPathTranslated());
        ps.println("    getRequestURL:         " + request.getRequestURL());
        ps.println("    getQueryString:        " + request.getQueryString());
        ps.println("    getRemoteUser:         " + request.getRemoteUser());
        ps.println("    getRequestedSessionId: " + request.getRequestedSessionId());
        ps.println("    getRequestURI:         " + request.getRequestURI());
        ps.println("    getServletPath:        " + request.getServletPath());
        ps.println("    isRequestedSessionIdFromCookie: " + request.isRequestedSessionIdFromCookie());
        ps.println("    isRequestedSessionIdValid:      " + request.isRequestedSessionIdValid());
        ps.println("    isRequestedSessionIdFromURL:    " + request.isRequestedSessionIdFromURL());
        ps.println("");
        int i = 0;
        Enumeration e = request.getHeaderNames();
        ps.println("    Header Names:");
        while (e.hasMoreElements()) {
            s = (String)e.nextElement();
            ps.print("        Header[" + ++i + "]: " + s);
            ps.println(": " + request.getHeader(s));
        }
        ps.println("");
        ps.println("ServletRequest Interface:");
        ps.println("    getCharacterEncoding:  " + request.getCharacterEncoding());
        ps.println("    getContentType:        " + request.getContentType());
        ps.println("    getContentLength:      " + request.getContentLength());
        ps.println("    getProtocol:           " + request.getProtocol());
        ps.println("    getScheme:             " + request.getScheme());
        ps.println("    getServerName:         " + request.getServerName());
        ps.println("    getServerPort:         " + request.getServerPort());
        ps.println("    getRemoteAddr:         " + request.getRemoteAddr());
        ps.println("    getRemoteHost:         " + request.getRemoteHost());
        ps.println(".............................");
        ps.println("");
        i = 0;
        e = request.getAttributeNames();
        ps.println("    Attribute Names:");
        while (e.hasMoreElements()) {
            s = (String)e.nextElement();
            ps.print("        Attribute[" + ++i + "]: " + s);
            ps.println(" Type: " + request.getAttribute(s));
        }
        ps.println(".............................");
        ps.println("");
        i = 0;
        e = request.getParameterNames();
        ps.println("    Parameter Names:");
        while (e.hasMoreElements()) {
            s = (String)e.nextElement();
            ps.print("        Parameter[" + ++i + "]: " + s);
            ps.println(" Value: " + request.getParameter(s));
        }
        ps.println("- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -");
        ps.println(" . . . . . . . . . Servlet Infomation API  . . . . . . . . . . . . . .");
        ps.println("");
        ps.println("Servlet Context:");
        ps.println("");
        ServletContext scntxt = this.getServletContext();
        i = 0;
        e = scntxt.getAttributeNames();
        ps.println("    Attribute Names:");
        while (e.hasMoreElements()) {
            String s2 = (String)e.nextElement();
            ps.print("        Attribute[" + ++i + "]: " + s2);
            ps.println(" Type: " + scntxt.getAttribute(s2));
        }
        ps.println("    ServletContext.getRealPath(\".\"): " + scntxt.getRealPath("."));
        ps.println("    ServletContext.getMajorVersion(): " + scntxt.getMajorVersion());
        ps.println("    ServletContext.getMinorVersion(): " + scntxt.getMinorVersion());
        ps.println(".............................");
        ps.println("Servlet Config:");
        ps.println("");
        ServletConfig scnfg = this.getServletConfig();
        i = 0;
        e = scnfg.getInitParameterNames();
        ps.println("    InitParameters:");
        while (e.hasMoreElements()) {
            String p = (String)e.nextElement();
            ps.print("        InitParameter[" + i + "]: " + p);
            ps.println(" Value: " + scnfg.getInitParameter(p));
            ++i;
        }
        ps.println("");
        ps.println("######################## END PROBE ###############################");
        ps.println("");
    }

    public String getServerName() {
        String servletName = ((Object)((Object)this)).getClass().getName();
        return servletName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        boolean isDebug = false;
        ReqState rs = null;
        RequestDebug reqD = null;
        try {
            Object ds;
            if (Debug.isSet("probeRequest")) {
                this.probeRequest(System.out, request);
            }
            if ((rs = this.getRequestState(request, response)) != null) {
                ds = rs.getDataSet();
                String suff = rs.getRequestSuffix();
                isDebug = ds != null && ((String)ds).equals("debug") && suff != null && suff.equals("");
            }
            ds = this.syncLock;
            synchronized (ds) {
                if (!isDebug) {
                    long reqno = this.HitCounter++;
                    if (this.track) {
                        reqD = new RequestDebug(reqno, Thread.currentThread().toString());
                        rs.setUserObject(reqD);
                        if (this.prArr == null) {
                            this.prArr = new ArrayList(10000);
                        }
                        this.prArr.add((int)reqno, rs);
                    }
                    if (Debug.isSet("showRequest")) {
                        System.out.println("-------------------------------------------");
                        System.out.println("Server: " + this.getServerName() + "   Request #" + reqno);
                        System.out.println("Client: " + request.getRemoteHost());
                        System.out.println(rs.toString());
                        Log.println("Request dataset: '" + rs.getDataSet() + "' suffix: '" + rs.getRequestSuffix() + "' CE: '" + rs.getConstraintExpression() + "'");
                    }
                }
            }
            if (rs != null) {
                String dataSet = rs.getDataSet();
                String requestSuffix = rs.getRequestSuffix();
                if (dataSet == null) {
                    this.doGetDIR(request, response, rs);
                } else if (dataSet.equals("/")) {
                    this.doGetDIR(request, response, rs);
                } else if (dataSet.equals("")) {
                    this.doGetDIR(request, response, rs);
                } else if (dataSet.equalsIgnoreCase("/version") || dataSet.equalsIgnoreCase("/version/")) {
                    this.doGetVER(request, response);
                } else if (dataSet.equalsIgnoreCase("/help") || dataSet.equalsIgnoreCase("/help/")) {
                    this.doGetHELP(request, response);
                } else if (dataSet.equalsIgnoreCase("/" + requestSuffix)) {
                    this.doGetHELP(request, response);
                } else if (requestSuffix.equalsIgnoreCase("dds")) {
                    this.doGetDDS(request, response, rs);
                } else if (requestSuffix.equalsIgnoreCase("das")) {
                    this.doGetDAS(request, response, rs);
                } else if (requestSuffix.equalsIgnoreCase("ddx")) {
                    this.doGetDDX(request, response, rs);
                } else if (requestSuffix.equalsIgnoreCase("blob")) {
                    this.doGetBLOB(request, response, rs);
                } else if (requestSuffix.equalsIgnoreCase("dods")) {
                    this.doGetDAP2Data(request, response, rs);
                } else if (requestSuffix.equalsIgnoreCase("asc") || requestSuffix.equalsIgnoreCase("ascii")) {
                    this.doGetASC(request, response, rs);
                } else if (requestSuffix.equalsIgnoreCase("info")) {
                    this.doGetINFO(request, response, rs);
                } else if (requestSuffix.equalsIgnoreCase("html") || requestSuffix.equalsIgnoreCase("htm")) {
                    this.doGetHTML(request, response, rs);
                } else if (requestSuffix.equalsIgnoreCase("ver") || requestSuffix.equalsIgnoreCase("version")) {
                    this.doGetVER(request, response);
                } else if (requestSuffix.equalsIgnoreCase("help")) {
                    this.doGetHELP(request, response);
                } else if (requestSuffix.equals("")) {
                    this.badURL(request, response);
                } else {
                    this.badURL(request, response);
                }
            } else {
                this.badURL(request, response);
            }
            if (reqD != null) {
                reqD.done = true;
            }
        }
        catch (Throwable e) {
            this.anyExceptionHandler(e, response, rs);
        }
    }

    protected ReqState getRequestState(HttpServletRequest request, HttpServletResponse response) {
        ReqState rs = null;
        String baseurl = request.getRequestURL().toString();
        baseurl = EscapeStrings.unescapeURL((String)baseurl);
        String query = request.getQueryString();
        query = EscapeStrings.unescapeURLQuery((String)query);
        try {
            rs = new ReqState(request, response, this.getServletConfig(), this.getServerName(), baseurl, query);
        }
        catch (BadURLException bue) {
            rs = null;
        }
        return rs;
    }

    void showMemUsed(String from) {
        long totalMemory = Runtime.getRuntime().totalMemory();
        long freeMemory = Runtime.getRuntime().freeMemory();
        long usedMemory = totalMemory - freeMemory;
        System.out.println("****showMemUsed " + from);
        System.out.println(" totalMemory " + totalMemory);
        System.out.println(" freeMemory " + freeMemory);
        System.out.println(" usedMemory " + usedMemory);
    }

    private void printHelpPage(PrintWriter pw) {
        pw.println("<h3>OPeNDAP Server Help</h3>");
        pw.println("To access most of the features of this OPeNDAP server, append");
        pw.println("one of the following a eight suffixes to a URL: .das, .dds, .dods, .ddx, .blob, .info,");
        pw.println(".ver or .help. Using these suffixes, you can ask this server for:");
        pw.println("<dl>");
        pw.println("<dt> das  </dt> <dd> Dataset Attribute Structure (DAS)</dd>");
        pw.println("<dt> dds  </dt> <dd> Dataset Descriptor Structure (DDS)</dd>");
        pw.println("<dt> dods </dt> <dd> DataDDS object (A constrained DDS populated with data)</dd>");
        pw.println("<dt> ddx  </dt> <dd> XML version of the DDS/DAS</dd>");
        pw.println("<dt> blob </dt> <dd> Serialized binary data content for requested data set, with the constraint expression applied.</dd>");
        pw.println("<dt> info </dt> <dd> info object (attributes, types and other information)</dd>");
        pw.println("<dt> html </dt> <dd> html form for this dataset</dd>");
        pw.println("<dt> ver  </dt> <dd> return the version number of the server</dd>");
        pw.println("<dt> help </dt> <dd> help information (this text)</dd>");
        pw.println("</dl>");
        pw.println("For example, to request the DAS object from the FNOC1 dataset at URI/GSO (a");
        pw.println("test dataset) you would appand `.das' to the URL:");
        pw.println("http://opendap.gso.uri.edu/cgi-bin/nph-nc/data/fnoc1.nc.das.");
        pw.println("<p><b>Note</b>: Many OPeNDAP clients supply these extensions for you so you don't");
        pw.println("need to append them (for example when using interfaces supplied by us or");
        pw.println("software re-linked with a OPeNDAP client-library). Generally, you only need to");
        pw.println("add these if you are typing a URL directly into a WWW browser.");
        pw.println("<p><b>Note</b>: If you would like version information for this server but");
        pw.println("don't know a specific data file or data set name, use `/version' for the");
        pw.println("filename. For example: http://opendap.gso.uri.edu/cgi-bin/nph-nc/version will");
        pw.println("return the version number for the netCDF server used in the first example. ");
        pw.println("<p><b>Suggestion</b>: If you're typing this URL into a WWW browser and");
        pw.println("would like information about the dataset, use the `.info' extension.");
        pw.println("<p>If you'd like to see a data values, use the `.html' extension and submit a");
        pw.println("query using the customized form.");
    }

    private void printBadURLPage(PrintWriter pw) {
        pw.println("<h3>Error in URL</h3>");
        pw.println("The URL extension did not match any that are known by this");
        pw.println("server. Below is a list of the five extensions that are be recognized by");
        pw.println("all OPeNDAP servers. If you think that the server is broken (that the URL you");
        pw.println("submitted should have worked), then please contact the");
        pw.println("OPeNDAP user support coordinator at: ");
        pw.println("<a href=\"mailto:support@unidata.ucar.edu\">support@unidata.ucar.edu</a><p>");
    }

    private class RequestDebug {
        long reqno;
        String threadDesc;
        boolean done = false;

        RequestDebug(long reqno, String threadDesc) {
            this.reqno = reqno;
            this.threadDesc = threadDesc;
        }
    }
}

