/*
 * Decompiled with CFR 0.152.
 */
package opendap.dap.parsers;

import java.io.FileInputStream;
import opendap.Server.ServerDDS;
import opendap.dap.DAS;
import opendap.dap.DefaultFactory;
import opendap.util.Getopts;
import opendap.util.InvalidSwitch;

public class XmlTest {
    public static void main(String[] args) throws Exception {
        boolean validation = false;
        int acount = 0;
        Getopts opts = null;
        try {
            opts = new Getopts("v", args);
            if (opts.getSwitch((Character)new Character((char)'v')).set) {
                validation = true;
            }
        }
        catch (InvalidSwitch e) {
            System.out.println(" ");
            System.out.println(" ");
            System.out.println("Usage: XmlTest [-v] ddxfile1 [ddxfile2] [ddxfile3] ...");
            System.out.println("Uses the DDSXMLParser to parse OPeNDAP DDX files.");
            System.out.println("Successful parsing leads to the display of the DDS, DAS");
            System.out.println("and the original DDX files onto <stdout>.");
            System.out.println("");
            System.out.println("Options:");
            System.out.println("    v   This option causes the XML parser to validate");
            System.out.println("        the DDX document against the OPeNDAP Schema. The");
            System.out.println("        Schema used to validate is the one referenced in ");
            System.out.println("        the DDX file. If the instance is unreachable then");
            System.out.println("        the parse will fail. Without this option the parser");
            System.out.println("        WILL NOT schema validate the document.");
            System.out.println(" ");
            System.out.println(" ");
            System.exit(0);
        }
        if (validation) {
            System.out.println("Parser will validate documents using Schema reference.");
        } else {
            System.out.println("Parser will NOT validate documents.");
        }
        args = opts.argList();
        for (int i = acount; i < args.length; ++i) {
            System.out.println("Parsing File: '" + args[i] + "'");
            FileInputStream fis = new FileInputStream(args[i]);
            DefaultFactory btf = new DefaultFactory();
            ServerDDS dds = new ServerDDS(btf);
            dds.parseXML(fis, validation);
            System.out.println("\n\n\n\nTHE DDS:\n");
            dds.print(System.out);
            System.out.println("\n\nThe DAS, from DDS.printDAS():\n");
            dds.printDAS(System.out);
            System.out.println("\n\nThe DAS object, from DDS.getDAS():\n");
            DAS thisDAS = dds.getDAS();
            thisDAS.print(System.out);
            dds.printXML(System.out);
        }
    }
}

