/*
 * Decompiled with CFR 0.152.
 */
package opendap.dap;

import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import opendap.dap.DefaultFactory;
import opendap.dap.parsers.DapParser;
import opendap.dap.parsers.ParseException;

public class DAP2Exception
extends Exception {
    public static final int UNDEFINED_ERROR = -1;
    public static final int UNKNOWN_ERROR = 0;
    public static final int NO_SUCH_FILE = 1;
    public static final int NO_SUCH_VARIABLE = 2;
    public static final int MALFORMED_EXPR = 3;
    public static final int NO_AUTHORIZATION = 4;
    public static final int CANNOT_READ_FILE = 5;
    public static final int UNDEFINED_PROG_TYPE = -1;
    public static final int NO_PROGRAM = 0;
    public static final int JAVA_PROGRAM = 1;
    public static final int TCL_PROGRAM = 2;
    private int errorCode;
    private String errorMessage;
    private int programType;
    private String programSource;

    public DAP2Exception() {
        super("DAP2Exception");
    }

    public DAP2Exception(String msg) {
        this();
        this.errorCode = 0;
        this.errorMessage = msg;
    }

    public DAP2Exception(int code, String msg) {
        this();
        this.errorCode = code;
        this.errorMessage = msg;
    }

    public DAP2Exception(Exception cause) {
        super(cause);
        this.errorCode = 0;
        this.errorMessage = cause.toString();
    }

    public final int getErrorCode() {
        return this.errorCode;
    }

    public final String getErrorMessage() {
        return this.errorMessage;
    }

    public final int getProgramType() {
        return this.programType;
    }

    public final String getProgramSource() {
        return this.programSource;
    }

    @Override
    public String getMessage() {
        return this.errorMessage;
    }

    public final void setErrorCode(int code) {
        this.errorCode = code;
    }

    public final void setErrorMessage(String msg) {
        this.errorMessage = msg;
    }

    public final void setProgramType(int type) {
        this.programType = type;
    }

    public final void setProgramSource(String source) {
        this.programSource = source;
    }

    public final boolean parse(InputStream stream) {
        DapParser parser = new DapParser(new DefaultFactory());
        try {
            if (parser.errparse(stream, this) != 3) {
                return false;
            }
        }
        catch (ParseException pe) {
            this.initCause(pe);
        }
        return true;
    }

    public void print(PrintWriter os) {
        os.println("Error {");
        os.println("    code = " + this.errorCode + ";");
        if (this.errorMessage != null) {
            os.println("    message = " + this.dumpword(this.errorMessage) + ";");
        }
        if (this.programSource != null) {
            os.println("    program = " + this.dumpword(this.programSource) + ";");
        }
        os.println("};");
    }

    private String dumpword(String word) {
        if (word == null) {
            return "";
        }
        if (word.charAt(0) == '\"') {
            return word;
        }
        return "\"" + word + "\"";
    }

    public final void print(OutputStream os) {
        PrintWriter pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter(os)));
        this.print(pw);
        pw.flush();
    }
}

