/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.widget;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import javax.swing.JButton;
import javax.swing.JFrame;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScheme;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.auth.CredentialsNotAvailableException;
import org.apache.commons.httpclient.auth.CredentialsProvider;
import org.apache.commons.httpclient.auth.RFC2617Scheme;
import ucar.nc2.ui.widget.IndependentDialog;
import ucar.util.prefs.ui.Field;
import ucar.util.prefs.ui.PrefPanel;

public class UrlAuthenticatorDialog
extends Authenticator
implements CredentialsProvider {
    private IndependentDialog dialog;
    private UsernamePasswordCredentials pwa = null;
    private Field.Text serverF;
    private Field.Text realmF;
    private Field.Text userF;
    private Field.Password passwF;
    private boolean debug = false;
    private AuthScope anyscope = new AuthScope(AuthScope.ANY);

    public UrlAuthenticatorDialog(JFrame parent) {
        PrefPanel pp = new PrefPanel("UrlAuthenticatorDialog", null);
        this.serverF = pp.addTextField("server", "Server", "wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww");
        this.realmF = pp.addTextField("realm", "Realm", "");
        this.serverF.setEditable(false);
        this.realmF.setEditable(false);
        this.userF = pp.addTextField("user", "User", "");
        this.passwF = pp.addPasswordField("password", "Password", "");
        pp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UrlAuthenticatorDialog.this.pwa = new UsernamePasswordCredentials(UrlAuthenticatorDialog.this.userF.getText(), new String(UrlAuthenticatorDialog.this.passwF.getPassword()));
                UrlAuthenticatorDialog.this.dialog.setVisible(false);
            }
        });
        JButton cancel = new JButton("Cancel");
        pp.addButton(cancel);
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UrlAuthenticatorDialog.this.pwa = null;
                UrlAuthenticatorDialog.this.dialog.setVisible(false);
            }
        });
        pp.finish();
        this.dialog = new IndependentDialog(parent, true, "HTTP Authentication", pp);
        this.dialog.setLocationRelativeTo(parent);
        this.dialog.setLocation(100, 100);
    }

    public void clear() {
    }

    @Override
    protected PasswordAuthentication getPasswordAuthentication() {
        if (this.debug) {
            System.out.println("site= " + this.getRequestingSite());
            System.out.println("port= " + this.getRequestingPort());
            System.out.println("protocol= " + this.getRequestingProtocol());
            System.out.println("prompt= " + this.getRequestingPrompt());
            System.out.println("scheme= " + this.getRequestingScheme());
        }
        this.serverF.setText(this.getRequestingHost() + ":" + this.getRequestingPort());
        this.realmF.setText(this.getRequestingPrompt());
        this.dialog.setVisible(true);
        if (this.debug && this.pwa != null) {
            System.out.println("user= (" + this.pwa.getUserName() + ")");
            System.out.println("password= (" + new String(this.pwa.getPassword()) + ")");
        }
        return new PasswordAuthentication(this.pwa.getUserName(), this.pwa.getPassword().toCharArray());
    }

    @Override
    public Credentials getCredentials(AuthScheme scheme, String host, int port, boolean proxy) throws CredentialsNotAvailableException {
        if (scheme == null) {
            throw new CredentialsNotAvailableException("Null authentication scheme: ");
        }
        if (!(scheme instanceof RFC2617Scheme)) {
            throw new CredentialsNotAvailableException("Unsupported authentication scheme: " + scheme.getSchemeName());
        }
        if (this.debug) {
            System.out.println(host + ":" + port + " requires authentication with the realm '" + scheme.getRealm() + "'");
        }
        this.serverF.setText(host + ":" + port);
        this.realmF.setText(scheme.getRealm());
        this.dialog.setVisible(true);
        if (this.pwa == null) {
            throw new CredentialsNotAvailableException();
        }
        if (this.debug) {
            System.out.println("user= (" + this.pwa.getUserName() + ")");
            System.out.println("password= (" + new String(this.pwa.getPassword()) + ")");
        }
        return new UsernamePasswordCredentials(this.pwa.getUserName(), new String(this.pwa.getPassword()));
    }
}

