/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import ucar.grib.GribResourceReader;
import ucar.grib.grib1.Grib1Tables;
import ucar.grib.grib1.GribPDSParamTable;
import ucar.grid.GridParameter;
import ucar.nc2.ui.dialog.Grib1TableDialog;
import ucar.nc2.ui.widget.BAMutil;
import ucar.nc2.ui.widget.IndependentWindow;
import ucar.nc2.ui.widget.PopupMenu;
import ucar.nc2.ui.widget.TextHistoryPane;
import ucar.nc2.util.IO;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.ui.BeanTableSorted;

public class Grib1TablesViewer
extends JPanel {
    private PreferencesExt prefs;
    private BeanTableSorted codeTable;
    private BeanTableSorted entryTable;
    private JSplitPane split;
    private JSplitPane split2;
    private TextHistoryPane infoTA;
    private IndependentWindow infoWindow;
    private Grib1TableDialog dialog;

    public Grib1TablesViewer(PreferencesExt prefs, JPanel buttPanel) {
        this.prefs = prefs;
        this.codeTable = new BeanTableSorted(TableBean.class, (PreferencesExt)prefs.node("CodeBean"), false);
        this.codeTable.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                TableBean csb = (TableBean)Grib1TablesViewer.this.codeTable.getSelectedBean();
                Grib1TablesViewer.this.setEntries(csb.table);
            }
        });
        PopupMenu varPopup = new PopupMenu(this.codeTable.getJTable(), "Options");
        varPopup.addAction("Show File contents", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableBean bean = (TableBean)Grib1TablesViewer.this.codeTable.getSelectedBean();
                if (bean == null) {
                    return;
                }
                Grib1TablesViewer.this.showFile(bean);
            }
        });
        this.entryTable = new BeanTableSorted(EntryBean.class, (PreferencesExt)prefs.node("EntryBean"), false);
        this.entryTable.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                EntryBean csb = (EntryBean)Grib1TablesViewer.this.entryTable.getSelectedBean();
            }
        });
        this.infoTA = new TextHistoryPane();
        this.infoWindow = new IndependentWindow("Extra Information", BAMutil.getImage("netcdfUI"), this.infoTA);
        this.infoWindow.setBounds((Rectangle)prefs.getBean("InfoWindowBounds", new Rectangle(300, 300, 800, 600)));
        this.split = new JSplitPane(0, false, this.codeTable, this.entryTable);
        this.split.setDividerLocation(prefs.getInt("splitPos", 500));
        this.setLayout(new BorderLayout());
        this.add((Component)this.split, "Center");
        AbstractButton infoButton = BAMutil.makeButtcon("Information", "Show Table Used", false);
        infoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Grib1TablesViewer.this.dialog == null) {
                    Grib1TablesViewer.this.dialog = new Grib1TableDialog((Frame)null);
                    Grib1TablesViewer.this.dialog.pack();
                }
                Grib1TablesViewer.this.dialog.setVisible(true);
            }
        });
        buttPanel.add(infoButton);
        try {
            GribPDSParamTable[] tables = GribPDSParamTable.getParameterTables();
            ArrayList<TableBean> beans = new ArrayList<TableBean>(tables.length);
            for (GribPDSParamTable t : tables) {
                beans.add(new TableBean(t));
            }
            Collections.sort(beans);
            this.codeTable.setBeans(beans);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void showFile(TableBean bean) {
        InputStream is = GribResourceReader.getInputStream((String)bean.getPath());
        try {
            this.infoTA.setText(IO.readContents(is));
            this.infoWindow.setVisible(true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void save() {
        this.codeTable.saveState(false);
        this.entryTable.saveState(false);
        this.prefs.putBeanObject("InfoWindowBounds", this.infoWindow.getBounds());
        this.prefs.putInt("splitPos", this.split.getDividerLocation());
    }

    public void setEntries(GribPDSParamTable table) {
        Map map = table.getParameters();
        ArrayList params = new ArrayList();
        params.addAll(map.keySet());
        Collections.sort(params);
        ArrayList<EntryBean> beans = new ArrayList<EntryBean>(params.size());
        for (String key : params) {
            beans.add(new EntryBean(key, (GridParameter)map.get(key)));
        }
        this.entryTable.setBeans(beans);
    }

    public class EntryBean {
        GridParameter param;
        String key;

        public EntryBean() {
        }

        public EntryBean(String key, GridParameter param) {
            this.key = key;
            this.param = param;
        }

        public String getKey() {
            return this.key;
        }

        public String getName() {
            return this.param.getName();
        }

        public String getDescription() {
            return this.param.getDescription();
        }

        public String getUnit() {
            return this.param.getUnit();
        }

        public int getNumber() {
            return this.param.getNumber();
        }
    }

    public class TableBean
    implements Comparable<TableBean> {
        GribPDSParamTable table;

        public TableBean() {
        }

        public TableBean(GribPDSParamTable table) {
            this.table = table;
        }

        public int getCenter_id() {
            return this.table.getCenter_id();
        }

        public String getCenter() {
            return Grib1Tables.getCenter_idName((int)this.table.getCenter_id());
        }

        public String getSubCenter() {
            return Grib1Tables.getSubCenter_idName((int)this.table.getCenter_id(), (int)this.table.getSubcenter_id());
        }

        public int getSubcenter_id() {
            return this.table.getSubcenter_id();
        }

        public int getVersionNumber() {
            return this.table.getTable_number();
        }

        public String getPath() {
            return this.table.getPath();
        }

        @Override
        public int compareTo(TableBean o) {
            int ret = this.getCenter_id() - o.getCenter_id();
            if (ret == 0) {
                ret = this.getSubcenter_id() - o.getSubcenter_id();
            }
            if (ret == 0) {
                ret = this.getVersionNumber() - o.getVersionNumber();
            }
            return ret;
        }
    }
}

