/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Formatter;
import java.util.List;
import java.util.StringTokenizer;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordSysBuilderIF;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableEnhanced;
import ucar.nc2.dt.grid.GridCoordSys;
import ucar.nc2.units.DateUnit;
import ucar.nc2.units.SimpleUnit;
import ucar.nc2.units.TimeUnit;
import ucar.unidata.util.Parameter;

public class NetcdfDatasetInfo {
    private NetcdfDataset ds;
    private CoordSysBuilderIF builder;

    public NetcdfDatasetInfo(String location) throws IOException {
        this.ds = NetcdfDataset.openDataset(location, false, null);
        this.builder = this.ds.enhance();
    }

    public void close() throws IOException {
        if (this.ds != null) {
            this.ds.close();
        }
    }

    public String getParseInfo() {
        return this.builder == null ? "" : this.builder.getParseInfo();
    }

    public String getUserAdvice() {
        return this.builder == null ? "" : this.builder.getUserAdvice();
    }

    public String getConventionUsed() {
        return this.builder == null ? "None" : this.builder.getConventionUsed();
    }

    public String writeXML() {
        XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
        return fmt.outputString(this.makeDocument());
    }

    public GridCoordSys getGridCoordSys(VariableEnhanced ve) {
        List<CoordinateSystem> csList = ve.getCoordinateSystems();
        for (CoordinateSystem cs : csList) {
            if (!GridCoordSys.isGridCoordSys(null, cs, ve)) continue;
            return new GridCoordSys(cs, null);
        }
        return null;
    }

    public void writeXML(OutputStream os) throws IOException {
        XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
        fmt.output(this.makeDocument(), os);
    }

    public Document makeDocument() {
        String userAdvice;
        GridCoordSys gcs;
        VariableEnhanced ve;
        Element rootElem = new Element("netcdfDatasetInfo");
        Document doc = new Document(rootElem);
        rootElem.setAttribute("location", this.ds.getLocation());
        rootElem.addContent(new Element("convention").setAttribute("name", this.getConventionUsed()));
        int nDataVariables = 0;
        int nOtherVariables = 0;
        List<CoordinateAxis> axes = this.ds.getCoordinateAxes();
        int nCoordAxes = axes.size();
        for (CoordinateAxis axis : axes) {
            CoordinateAxis1D axis1D;
            Element axisElem = new Element("axis");
            rootElem.addContent(axisElem);
            axisElem.setAttribute("name", axis.getFullName());
            axisElem.setAttribute("decl", this.getDecl(axis));
            if (axis.getAxisType() != null) {
                axisElem.setAttribute("type", axis.getAxisType().toString());
            }
            if (axis.getUnitsString() != null) {
                axisElem.setAttribute("units", axis.getUnitsString());
                axisElem.setAttribute("udunits", this.isUdunits(axis.getUnitsString()));
            }
            if (!(axis instanceof CoordinateAxis1D) || !(axis1D = (CoordinateAxis1D)axis).isRegular()) continue;
            axisElem.setAttribute("regular", ucar.unidata.util.Format.d(axis1D.getIncrement(), 5));
        }
        List<CoordinateSystem> csList = this.ds.getCoordinateSystems();
        for (CoordinateSystem cs : csList) {
            Element csElem;
            if (GridCoordSys.isGridCoordSys(null, cs, null)) {
                GridCoordSys gcs2 = new GridCoordSys(cs, null);
                csElem = new Element("gridCoordSystem");
                csElem.setAttribute("name", cs.getName());
                csElem.setAttribute("horizX", gcs2.getXHorizAxis().getFullName());
                csElem.setAttribute("horizY", gcs2.getYHorizAxis().getFullName());
                if (gcs2.hasVerticalAxis()) {
                    csElem.setAttribute("vertical", gcs2.getVerticalAxis().getFullName());
                }
                if (gcs2.hasTimeAxis()) {
                    csElem.setAttribute("time", cs.getTaxis().getFullName());
                }
            } else {
                csElem = new Element("coordSystem");
                csElem.setAttribute("name", cs.getName());
            }
            List<CoordinateTransform> coordTransforms = cs.getCoordinateTransforms();
            for (CoordinateTransform ct : coordTransforms) {
                Element ctElem = new Element("coordTransform");
                csElem.addContent(ctElem);
                ctElem.setAttribute("name", ct.getName());
                ctElem.setAttribute("type", ct.getTransformType().toString());
            }
            rootElem.addContent(csElem);
        }
        List<CoordinateTransform> coordTransforms = this.ds.getCoordinateTransforms();
        for (CoordinateTransform ct : coordTransforms) {
            Element ctElem = new Element("coordTransform");
            rootElem.addContent(ctElem);
            ctElem.setAttribute("name", ct.getName());
            ctElem.setAttribute("type", ct.getTransformType().toString());
            List<Parameter> params = ct.getParameters();
            for (Parameter pp : params) {
                Element ppElem = new Element("param");
                ctElem.addContent(ppElem);
                ppElem.setAttribute("name", pp.getName());
                ppElem.setAttribute("value", pp.getStringValue());
            }
        }
        for (Variable var : this.ds.getVariables()) {
            ve = (VariableEnhanced)((Object)var);
            if (ve instanceof CoordinateAxis || null == (gcs = this.getGridCoordSys(ve))) continue;
            ++nDataVariables;
            Element gridElem = new Element("grid");
            rootElem.addContent(gridElem);
            gridElem.setAttribute("name", ve.getFullName());
            gridElem.setAttribute("decl", this.getDecl(ve));
            if (ve.getUnitsString() != null) {
                gridElem.setAttribute("units", ve.getUnitsString());
                gridElem.setAttribute("udunits", this.isUdunits(ve.getUnitsString()));
            }
            gridElem.setAttribute("coordSys", gcs.getName());
        }
        for (Variable var : this.ds.getVariables()) {
            ve = (VariableEnhanced)((Object)var);
            if (ve instanceof CoordinateAxis || null != (gcs = this.getGridCoordSys(ve))) continue;
            ++nOtherVariables;
            Element elem = new Element("variable");
            rootElem.addContent(elem);
            elem.setAttribute("name", ve.getFullName());
            elem.setAttribute("decl", this.getDecl(ve));
            if (ve.getUnitsString() != null) {
                elem.setAttribute("units", ve.getUnitsString());
                elem.setAttribute("udunits", this.isUdunits(ve.getUnitsString()));
            }
            elem.setAttribute("coordSys", this.getCoordSys(ve));
        }
        if (nDataVariables > 0) {
            rootElem.addContent(new Element("userAdvice").addContent("Dataset contains useable gridded data."));
            if (nOtherVariables > 0) {
                rootElem.addContent(new Element("userAdvice").addContent("Some variables are not gridded fields; check that is what you expect."));
            }
        } else if (nCoordAxes == 0) {
            rootElem.addContent(new Element("userAdvice").addContent("No Coordinate Axes were found."));
        } else {
            rootElem.addContent(new Element("userAdvice").addContent("No gridded data variables were found."));
        }
        if ((userAdvice = this.getUserAdvice()).length() > 0) {
            StringTokenizer toker = new StringTokenizer(userAdvice, "\n");
            while (toker.hasMoreTokens()) {
                rootElem.addContent(new Element("userAdvice").addContent(toker.nextToken()));
            }
        }
        return doc;
    }

    private String getDecl(VariableEnhanced ve) {
        Formatter sb = new Formatter();
        sb.format("%s ", ve.getDataType().toString());
        ve.getNameAndDimensions(sb, true, true);
        return sb.toString();
    }

    private String getCoordSys(VariableEnhanced ve) {
        List<CoordinateSystem> csList = ve.getCoordinateSystems();
        if (csList.size() == 1) {
            CoordinateSystem cs = csList.get(0);
            return cs.getName();
        }
        if (csList.size() > 1) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < csList.size(); ++i) {
                CoordinateSystem cs = csList.get(i);
                if (i > 0) {
                    sb.append(";");
                }
                sb.append(cs.getName());
            }
            return sb.toString();
        }
        return " ";
    }

    private String isUdunits(String unit) {
        try {
            new DateUnit(unit);
            return "date";
        }
        catch (Exception e) {
            try {
                new TimeUnit(unit);
                return "time";
            }
            catch (Exception e2) {
                SimpleUnit su = SimpleUnit.factory(unit);
                if (null == su) {
                    return "false";
                }
                return su.getCanonicalString();
            }
        }
    }

    public static void main(String[] args) throws IOException {
        String url = "C:/data/badmodels/RUC_CONUS_80km_20051211_1900.nc";
        NetcdfDatasetInfo info = new NetcdfDatasetInfo(url);
        String infoString = info.writeXML();
        System.out.println(infoString);
    }
}

