/*
 * Decompiled with CFR 0.152.
 */
package thredds.ui.datatype.prefs;

import java.text.ParseException;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.JToolTip;
import javax.swing.text.JTextComponent;
import ucar.nc2.ui.widget.MultilineTooltip;
import ucar.nc2.units.DateType;
import ucar.util.prefs.PersistenceManager;
import ucar.util.prefs.ui.Field;
import ucar.util.prefs.ui.FldInputVerifier;

public class DateField
extends Field {
    protected JTextComponent tf;

    public DateField(String name, String label, DateType defValue, PersistenceManager storeData) {
        super(name, label, storeData);
        this.validValue = this.getStoreValue(defValue);
        this.tf = new JTextField(){

            @Override
            public JToolTip createToolTip() {
                return new MultilineTooltip();
            }
        };
        this.tf.setToolTipText("Formats:\n 'present'\n CCYY-MM-DD\n CCYY-MM-DDThh:mm:ss\n udunits date string");
        this.tf.setInputVerifier(new FldInputVerifier(this.tf, this));
        if (this.validValue != null) {
            this.tf.setText(this.validValue.toString());
        }
        this.finish();
    }

    @Override
    public JComponent getEditComponent() {
        return this.tf;
    }

    @Override
    protected boolean _validate(StringBuffer buff) {
        try {
            new DateType(this.tf.getText(), null, null);
            return true;
        }
        catch (ParseException e) {
            if (null != buff) {
                buff.append(this.name).append(": ").append(e.getMessage());
            }
            return false;
        }
    }

    @Override
    protected Object getEditValue() {
        try {
            return new DateType(this.tf.getText(), null, null);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public DateType getDate() {
        return (DateType)this.getValue();
    }

    @Override
    protected void setEditValue(Object value) {
        if (value == null) {
            this.tf.setText("");
        } else {
            this.tf.setText(value.toString());
        }
    }

    @Override
    protected void setStoreValue(Object value) {
        if (this.storeData != null) {
            if (value == null) {
                this.storeData.putObject(this.name, value);
            } else {
                this.storeData.putObject(this.name, new DateType((DateType)value));
            }
        }
    }

    @Override
    protected Object getStoreValue(Object defValue) {
        Object value2;
        Object value = defValue;
        if (this.storeData != null && (value2 = this.storeData.getObject(this.name)) != null) {
            value = value2;
        }
        if (value == null) {
            return null;
        }
        return new DateType((DateType)value);
    }
}

