/*
 * Decompiled with CFR 0.152.
 */
package thredds.crawlabledataset;

import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import thredds.crawlabledataset.CheckableForFileRepresentation;
import thredds.crawlabledataset.CrawlableDataset;
import thredds.crawlabledataset.CrawlableDatasetFilter;

public abstract class PathResolverCrawlableDataset
implements CrawlableDataset {
    final File rootDirFile;
    final String rootDirPath;
    final String rootDirName;

    abstract File resolve(String var1);

    public PathResolverCrawlableDataset(String rootDirectoryPath, Object configObj) {
        if (rootDirectoryPath == null || rootDirectoryPath.equals("")) {
            throw new IllegalArgumentException("Path may not be null or empty.");
        }
        File tmpFile = new File(rootDirectoryPath);
        if (!tmpFile.exists() || !tmpFile.isDirectory()) {
            throw new IllegalArgumentException("Root file [" + tmpFile.getPath() + "] must exist and be a directory");
        }
        this.rootDirFile = tmpFile;
        this.rootDirPath = this.normalizePath(tmpFile.getPath());
        this.rootDirName = this.rootDirPath.substring(this.rootDirPath.lastIndexOf("/") + 1);
    }

    @Override
    public Object getConfigObject() {
        return null;
    }

    @Override
    public String getPath() {
        return this.rootDirPath;
    }

    @Override
    public String getName() {
        return this.rootDirName;
    }

    @Override
    public CrawlableDataset getParentDataset() {
        throw new IllegalStateException("This is a root dataset without parents.");
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public boolean isCollection() {
        return true;
    }

    @Override
    public CrawlableDataset getDescendant(String relativePath) {
        if (relativePath == null || relativePath.equals("")) {
            throw new IllegalArgumentException("Path may not be null or empty.");
        }
        return new NonCollectionCrDs(this.rootDirPath + "/" + relativePath);
    }

    @Override
    public List<CrawlableDataset> listDatasets() throws IOException {
        throw new UnsupportedOperationException("This class does not support crawling the dataset hierarchy.");
    }

    @Override
    public List<CrawlableDataset> listDatasets(CrawlableDatasetFilter filter) throws IOException {
        throw new UnsupportedOperationException("This class does not support crawling the dataset hierarchy.");
    }

    @Override
    public long length() {
        return 0L;
    }

    @Override
    public Date lastModified() {
        return null;
    }

    public String toString() {
        return this.rootDirPath;
    }

    private String normalizePath(String path) {
        return path.replaceAll("\\\\", "/");
    }

    private class NonCollectionCrDs
    implements CrawlableDataset,
    CheckableForFileRepresentation {
        private final String crDsPath;
        private final String crDsName;
        private final File dsFile;

        NonCollectionCrDs(String path) {
            if (path == null || path.equals("")) {
                throw new IllegalArgumentException("Path may not be null or empty.");
            }
            String tmpPath = PathResolverCrawlableDataset.this.normalizePath(path);
            if (!tmpPath.startsWith(PathResolverCrawlableDataset.this.rootDirPath)) {
                throw new IllegalArgumentException("Dataset path [" + tmpPath + "] not descendant of root dataset [" + PathResolverCrawlableDataset.this.rootDirPath + "].");
            }
            String remainingPath = tmpPath.substring(PathResolverCrawlableDataset.this.rootDirPath.length() + 1);
            File tmpFile = PathResolverCrawlableDataset.this.resolve(remainingPath);
            if (!tmpFile.exists()) {
                throw new IllegalArgumentException("Dataset backing file [" + tmpFile.getPath() + "] does not exist.");
            }
            if (tmpFile.exists() && tmpFile.isDirectory()) {
                throw new IllegalArgumentException("Dataset backing file [" + tmpFile.getPath() + "] is a directory.");
            }
            this.crDsPath = tmpPath;
            this.crDsName = this.crDsPath.substring(this.crDsPath.lastIndexOf("/") + 1);
            this.dsFile = tmpFile;
        }

        @Override
        public boolean canRepresentAsFile() {
            return true;
        }

        @Override
        public File getFile() {
            return this.dsFile;
        }

        @Override
        public Object getConfigObject() {
            return null;
        }

        @Override
        public String getPath() {
            return this.crDsPath;
        }

        @Override
        public String getName() {
            return this.crDsName;
        }

        @Override
        public CrawlableDataset getParentDataset() {
            throw new UnsupportedOperationException("This class does not support crawling the dataset hierarchy.");
        }

        @Override
        public boolean exists() {
            return true;
        }

        @Override
        public boolean isCollection() {
            return false;
        }

        @Override
        public CrawlableDataset getDescendant(String relativePath) {
            throw new IllegalStateException("Dataset is not a collection.");
        }

        @Override
        public List<CrawlableDataset> listDatasets() throws IOException {
            throw new IllegalStateException("Dataset is not a collection.");
        }

        @Override
        public List<CrawlableDataset> listDatasets(CrawlableDatasetFilter filter) throws IOException {
            throw new IllegalStateException("Dataset is not a collection.");
        }

        @Override
        public long length() {
            return this.dsFile.length();
        }

        @Override
        public Date lastModified() {
            long lastModDate = this.dsFile.lastModified();
            if (lastModDate == 0L) {
                return null;
            }
            Calendar cal = Calendar.getInstance();
            cal.clear();
            cal.setTimeInMillis(lastModDate);
            return cal.getTime();
        }

        public String toString() {
            return this.getPath();
        }
    }
}

