/*
 * Decompiled with CFR 0.152.
 */
package ucar.jpeg.jj2000.j2k.decoder;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.net.MalformedURLException;
import java.net.URL;
import ucar.jpeg.jj2000.disp.ImgKeyListener;
import ucar.jpeg.jj2000.disp.ImgMouseListener;
import ucar.jpeg.jj2000.disp.ImgScrollPane;
import ucar.jpeg.jj2000.j2k.decoder.Decoder;
import ucar.jpeg.jj2000.j2k.util.ParameterList;

public class SimpleAppletDecoder
extends Applet
implements Runnable {
    private static String[][] pinfo = Decoder.getAllParameters();
    private Decoder dec;
    private ParameterList pl;
    private Thread decThread;
    private boolean decStarted;
    private ImgScrollPane isp;

    @Override
    public void init() {
        URL input;
        String param;
        int i;
        ParameterList defpl = new ParameterList();
        for (i = pinfo.length - 1; i >= 0; --i) {
            if (pinfo[i][3] == null) continue;
            defpl.put(pinfo[i][0], pinfo[i][3]);
        }
        this.pl = new ParameterList(defpl);
        for (i = 0; i < pinfo.length; ++i) {
            param = this.getParameter(pinfo[i][0]);
            if (param == null) continue;
            this.pl.put(pinfo[i][0], param);
        }
        param = this.pl.getParameter("i");
        if (param != null) {
            try {
                input = new URL(this.getDocumentBase(), param);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Malformed URL in parameter 'i'");
            }
        } else {
            throw new IllegalArgumentException("Missing input");
        }
        param = input.toExternalForm();
        this.pl.put("i", param);
        if (this.pl.getParameter("o") != null) {
            throw new IllegalArgumentException("Can not specify output files for applet");
        }
        this.setLayout(new BorderLayout());
        this.isp = new ImgScrollPane(0);
        this.add((Component)this.isp, "Center");
        this.validate();
        this.setVisible(true);
        this.decThread = new Thread(this);
        this.decStarted = false;
    }

    @Override
    public void start() {
        if (this.decStarted) {
            return;
        }
        this.decStarted = true;
        this.decThread.start();
    }

    @Override
    public void stop() {
    }

    @Override
    public void destroy() {
        if (!this.decStarted) {
            return;
        }
        while (this.decThread != null && this.decThread.isAlive()) {
            try {
                Thread.currentThread();
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.decThread = null;
    }

    @Override
    public void run() {
        int status;
        if (this.dec != null) {
            return;
        }
        this.showStatus("Initializing JJ2000 decoder...");
        this.dec = new Decoder(this.pl, this.isp);
        this.dec.setChildProcess(true);
        this.showStatus("Decoding...");
        this.dec.run();
        Image img = this.isp.getImage();
        do {
            if (((status = this.isp.checkImage(img, null)) & 0x40) != 0) {
                this.showStatus("An unknown error occurred while producing the image");
                return;
            }
            if ((status & 0x80) != 0) {
                this.showStatus("Image production was aborted for some unknown reason");
                continue;
            }
            if ((status & 0x20) != 0) {
                this.showStatus("Done.");
                continue;
            }
            try {
                Thread.currentThread();
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        } while ((status & 0xE0) == 0);
        if ((status & 0x40) == 0) {
            ImgMouseListener iml = new ImgMouseListener(this.isp);
            this.isp.addKeyListener(new ImgKeyListener(this.isp, this.dec));
            this.isp.addMouseListener(iml);
            this.isp.addMouseMotionListener(iml);
        }
    }

    @Override
    public String getAppletInfo() {
        return "JJ2000's JPEG 2000 simple applet decoder\nVersion: 5.1\nCopyright:\n\nThis software module was originally developed by Rapha\u00ebl Grosbois and Diego Santa Cruz (Swiss Federal Institute of Technology-EPFL); Joel Askel\u00f6f (Ericsson Radio Systems AB); and Bertrand Berthelot, David Bouchard, F\u00e9lix Henry, Gerard Mozelle and Patrice Onno (Canon Research Centre France S.A) in the course of development of the JPEG 2000 standard as specified by ISO/IEC 15444 (JPEG 2000 Standard). This software module is an implementation of a part of the JPEG 2000 Standard. Swiss Federal Institute of Technology-EPFL, Ericsson Radio Systems AB and Canon Research Centre France S.A (collectively JJ2000 Partners) agree not to assert against ISO/IEC and users of the JPEG 2000 Standard (Users) any of their rights under the copyright, not including other intellectual property rights, for this software module with respect to the usage by ISO/IEC and Users of this software module or modifications thereof for use in hardware or software products claiming conformance to the JPEG 2000 Standard. Those intending to use this software module in hardware or software products are advised that their use may infringe existing patents. The original developers of this software module, JJ2000 Partners and ISO/IEC assume no liability for use of this software module or modifications thereof. No license or right to this software module is granted for non JPEG 2000 Standard conforming products. JJ2000 Partners have full right to use this software module for his/her own purpose, assign or donate this software module to any third party and to inhibit third parties from using this software module for non JPEG 2000 Standard conforming products. This copyright notice must be included in all copies or derivative works of this software module.\n\nCopyright (c) 1999/2000 JJ2000 Partners.\nSend bug reports to: jj2000-bugs@ltssg3.epfl.ch\n";
    }

    @Override
    public String[][] getParameterInfo() {
        return pinfo;
    }
}

