/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib1;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ucar.grib.GribNumbers;
import ucar.grib.NoValidGribException;
import ucar.grib.grib1.Grib1Grid;
import ucar.grib.grib1.Grib1GridDefinitionSection;
import ucar.grib.grib1.Grib1IndicatorSection;
import ucar.grib.grib1.Grib1Product;
import ucar.grib.grib1.Grib1ProductDefinitionSection;
import ucar.grib.grib1.Grib1Record;
import ucar.unidata.io.RandomAccessFile;

public final class Grib1Input {
    private final RandomAccessFile raf;
    private String header = "GRIB1";
    private static final Pattern productID = Pattern.compile("(\\w{6} \\w{4} \\d{6})");
    private final ArrayList<Grib1Record> records = new ArrayList();
    private final ArrayList<Grib1Product> products = new ArrayList();
    private final HashMap<String, Grib1GridDefinitionSection> gdsHM = new HashMap();

    public Grib1Input(RandomAccessFile raf) {
        this.raf = raf;
    }

    public final void scan(boolean getProducts, boolean oneRecord) throws NoValidGribException, IOException {
        long start = System.currentTimeMillis();
        HashMap<String, String> gdsCounter = new HashMap<String, String>();
        Grib1ProductDefinitionSection pds = null;
        Grib1GridDefinitionSection gds = null;
        long pdsOffset = 0L;
        long gdsOffset = 0L;
        while (this.raf.getFilePointer() < this.raf.length()) {
            if (!this.seekHeader(this.raf, this.raf.length())) continue;
            Grib1IndicatorSection is = new Grib1IndicatorSection(this.raf);
            long EOR = this.raf.getFilePointer() + is.getGribLength() - (long)is.getLength();
            if (is.getGribEdition() == 2) {
                this.raf.seek(EOR);
                continue;
            }
            long dataOffset = 0L;
            try {
                int length;
                pdsOffset = this.raf.getFilePointer();
                pds = new Grib1ProductDefinitionSection(this.raf);
                if (pds.getPdsVars().gdsExists()) {
                    gdsOffset = this.raf.getFilePointer();
                    gds = new Grib1GridDefinitionSection(this.raf);
                } else {
                    gdsOffset = -1L;
                    gds = new Grib1Grid(pds);
                }
                dataOffset = pds.getPdsVars().getCenter() == 98 ? ((long)(length = GribNumbers.uint3(this.raf)) + this.raf.getFilePointer() < EOR ? this.raf.getFilePointer() - 3L : this.raf.getFilePointer() - 2L) : this.raf.getFilePointer();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.raf.seek(EOR);
                continue;
            }
            this.raf.seek(EOR);
            if (getProducts) {
                Grib1Product gp = new Grib1Product(this.header, pds, this.getGDSkey(gds, gdsCounter), gds.getGdsKey(), gdsOffset, dataOffset);
                this.products.add(gp);
            } else {
                Grib1Record gr = new Grib1Record(this.header, is, pds, gds, dataOffset, this.raf.getFilePointer());
                this.records.add(gr);
            }
            if (oneRecord) {
                return;
            }
            if (this.raf.getFilePointer() <= this.raf.length()) continue;
            this.raf.seek(0L);
            System.err.println("Grib1Input: possible file corruption");
            return;
        }
    }

    public final int getEdition() throws IOException {
        long length;
        long l = length = this.raf.length() < 25000L ? this.raf.length() : 25000L;
        if (!this.seekHeader(this.raf, length)) {
            return 0;
        }
        Grib1IndicatorSection is = new Grib1IndicatorSection(this.raf);
        return is.getGribEdition();
    }

    private boolean seekHeader(RandomAccessFile raf, long stop) throws IOException {
        StringBuffer hdr = new StringBuffer();
        int match = 0;
        while (raf.getFilePointer() < stop) {
            char c = (char)raf.read();
            hdr.append(c);
            if (c == 'G') {
                match = 1;
                continue;
            }
            if (c == 'R' && match == 1) {
                match = 2;
                continue;
            }
            if (c == 'I' && match == 2) {
                match = 3;
                continue;
            }
            if (c == 'B' && match == 3) {
                match = 4;
                Matcher m = productID.matcher(hdr.toString());
                this.header = m.find() ? m.group(1) : "GRIB1";
                return true;
            }
            match = 0;
        }
        return false;
    }

    private String getGDSkey(Grib1GridDefinitionSection gds, HashMap<String, String> gdsCounter) {
        String key = Integer.toString(gds.getGdsKey());
        if (!this.gdsHM.containsKey(key)) {
            this.gdsHM.put(key, gds);
            gdsCounter.put(key, "1");
        } else {
            int count = Integer.parseInt(gdsCounter.get(key));
            gdsCounter.put(key, Integer.toString(++count));
        }
        return key;
    }

    private void checkGDSkeys(Grib1GridDefinitionSection gds, HashMap gdsCounter) {
    }

    public final ArrayList<Grib1Product> getProducts() {
        return this.products;
    }

    public final ArrayList<Grib1Record> getRecords() {
        return this.records;
    }

    public final HashMap<String, Grib1GridDefinitionSection> getGDSs() {
        return this.gdsHM;
    }
}

