# Unix SMB/CIFS implementation.
#
# Enums and flag types for models.
#
# Copyright (C) Catalyst.Net Ltd. 2023
#
# Written by Rob van der Linde <rob@catalyst.net.nz>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

from enum import IntFlag

from samba.dcerpc.security import (
    KERB_ENCTYPE_FAST_SUPPORTED,
    KERB_ENCTYPE_COMPOUND_IDENTITY_SUPPORTED,
    KERB_ENCTYPE_CLAIMS_SUPPORTED,
    KERB_ENCTYPE_RESOURCE_SID_COMPRESSION_DISABLED
)
from samba.dsdb import (
    ATYPE_SECURITY_GLOBAL_GROUP,
    ATYPE_SECURITY_LOCAL_GROUP,
    ATYPE_NORMAL_ACCOUNT,
    ATYPE_DISTRIBUTION_GLOBAL_GROUP,
    ATYPE_DISTRIBUTION_LOCAL_GROUP,
    ATYPE_WORKSTATION_TRUST,
    ATYPE_INTERDOMAIN_TRUST,
    UF_SCRIPT,
    UF_ACCOUNTDISABLE,
    UF_HOMEDIR_REQUIRED,
    UF_LOCKOUT,
    UF_PASSWD_NOTREQD,
    UF_PASSWD_CANT_CHANGE,
    UF_ENCRYPTED_TEXT_PASSWORD_ALLOWED,
    UF_TEMP_DUPLICATE_ACCOUNT,
    UF_NORMAL_ACCOUNT,
    UF_INTERDOMAIN_TRUST_ACCOUNT,
    UF_WORKSTATION_TRUST_ACCOUNT,
    UF_SERVER_TRUST_ACCOUNT,
    UF_DONT_EXPIRE_PASSWD,
    UF_MNS_LOGON_ACCOUNT,
    UF_SMARTCARD_REQUIRED,
    UF_TRUSTED_FOR_DELEGATION,
    UF_NOT_DELEGATED,
    UF_USE_DES_KEY_ONLY,
    UF_DONT_REQUIRE_PREAUTH,
    UF_PASSWORD_EXPIRED,
    UF_TRUSTED_TO_AUTHENTICATE_FOR_DELEGATION,
    UF_NO_AUTH_DATA_REQUIRED,
    UF_PARTIAL_SECRETS_ACCOUNT,
    UF_USE_AES_KEYS,
    ENC_ALL_TYPES,
    ENC_CRC32,
    ENC_RSA_MD5,
    ENC_RC4_HMAC_MD5,
    ENC_HMAC_SHA1_96_AES128,
    ENC_HMAC_SHA1_96_AES256,
    ENC_HMAC_SHA1_96_AES256_SK,
    GTYPE_DISTRIBUTION_GLOBAL_GROUP,
    GTYPE_DISTRIBUTION_DOMAIN_LOCAL_GROUP,
    GTYPE_DISTRIBUTION_UNIVERSAL_GROUP,
    GTYPE_SECURITY_BUILTIN_LOCAL_GROUP,
    GTYPE_SECURITY_DOMAIN_LOCAL_GROUP,
    GTYPE_SECURITY_GLOBAL_GROUP,
    GTYPE_SECURITY_UNIVERSAL_GROUP,
    SYSTEM_FLAG_CR_NTDS_NC,
    SYSTEM_FLAG_CR_NTDS_DOMAIN,
    SYSTEM_FLAG_CR_NTDS_NOT_GC_REPLICATED,
    SYSTEM_FLAG_ATTR_IS_RDN,
    SYSTEM_FLAG_CONFIG_ALLOW_LIMITED_MOVE,
    SYSTEM_FLAG_CONFIG_ALLOW_MOVE,
    SYSTEM_FLAG_CONFIG_ALLOW_RENAME,
    SYSTEM_FLAG_DISALLOW_DELETE,
    SYSTEM_FLAG_DISALLOW_MOVE_ON_DELETE,
    SYSTEM_FLAG_DOMAIN_DISALLOW_MOVE,
    SYSTEM_FLAG_DOMAIN_DISALLOW_RENAME
)


class AccountType(IntFlag):
    SECURITY_GLOBAL_GROUP = ATYPE_SECURITY_GLOBAL_GROUP
    SECURITY_LOCAL_GROUP = ATYPE_SECURITY_LOCAL_GROUP
    NORMAL_ACCOUNT = ATYPE_NORMAL_ACCOUNT
    DISTRIBUTION_GLOBAL_GROUP = ATYPE_DISTRIBUTION_GLOBAL_GROUP
    DISTRIBUTION_LOCAL_GROUP = ATYPE_DISTRIBUTION_LOCAL_GROUP
    WORKSTATION_TRUST = ATYPE_WORKSTATION_TRUST
    INTERDOMAIN_TRUST = ATYPE_INTERDOMAIN_TRUST


class GroupType(IntFlag):
    DISTRIBUTION_GLOBAL_GROUP = GTYPE_DISTRIBUTION_GLOBAL_GROUP
    DISTRIBUTION_DOMAIN_LOCAL_GROUP = GTYPE_DISTRIBUTION_DOMAIN_LOCAL_GROUP
    DISTRIBUTION_UNIVERSAL_GROUP = GTYPE_DISTRIBUTION_UNIVERSAL_GROUP
    SECURITY_BUILTIN_LOCAL_GROUP = GTYPE_SECURITY_BUILTIN_LOCAL_GROUP
    SECURITY_DOMAIN_LOCAL_GROUP = GTYPE_SECURITY_DOMAIN_LOCAL_GROUP
    SECURITY_GLOBAL_GROUP = GTYPE_SECURITY_GLOBAL_GROUP
    SECURITY_UNIVERSAL_GROUP = GTYPE_SECURITY_UNIVERSAL_GROUP


class SystemFlags(IntFlag):
    CR_NTDS_NC = SYSTEM_FLAG_CR_NTDS_NC
    CR_NTDS_DOMAIN = SYSTEM_FLAG_CR_NTDS_DOMAIN
    CR_NTDS_NOT_GC_REPLICATED = SYSTEM_FLAG_CR_NTDS_NOT_GC_REPLICATED
    ATTR_IS_RDN = SYSTEM_FLAG_ATTR_IS_RDN
    CONFIG_ALLOW_LIMITED_MOVE = SYSTEM_FLAG_CONFIG_ALLOW_LIMITED_MOVE
    CONFIG_ALLOW_MOVE = SYSTEM_FLAG_CONFIG_ALLOW_MOVE
    CONFIG_ALLOW_RENAME = SYSTEM_FLAG_CONFIG_ALLOW_RENAME
    DISALLOW_DELETE = SYSTEM_FLAG_DISALLOW_DELETE
    DISALLOW_MOVE_ON_DELETE = SYSTEM_FLAG_DISALLOW_MOVE_ON_DELETE
    DOMAIN_DISALLOW_MOVE = SYSTEM_FLAG_DOMAIN_DISALLOW_MOVE
    DOMAIN_DISALLOW_RENAME = SYSTEM_FLAG_DOMAIN_DISALLOW_RENAME


class UserAccountControl(IntFlag):
    SCRIPT = UF_SCRIPT
    ACCOUNTDISABLE = UF_ACCOUNTDISABLE
    HOMEDIR_REQUIRED = UF_HOMEDIR_REQUIRED
    LOCKOUT = UF_LOCKOUT
    PASSWD_NOTREQD = UF_PASSWD_NOTREQD
    PASSWD_CANT_CHANGE = UF_PASSWD_CANT_CHANGE
    ENCRYPTED_TEXT_PASSWORD_ALLOWED = UF_ENCRYPTED_TEXT_PASSWORD_ALLOWED
    TEMP_DUPLICATE_ACCOUNT = UF_TEMP_DUPLICATE_ACCOUNT
    NORMAL_ACCOUNT = UF_NORMAL_ACCOUNT
    INTERDOMAIN_TRUST_ACCOUNT = UF_INTERDOMAIN_TRUST_ACCOUNT
    WORKSTATION_TRUST_ACCOUNT = UF_WORKSTATION_TRUST_ACCOUNT
    SERVER_TRUST_ACCOUNT = UF_SERVER_TRUST_ACCOUNT
    DONT_EXPIRE_PASSWD = UF_DONT_EXPIRE_PASSWD
    MNS_LOGON_ACCOUNT = UF_MNS_LOGON_ACCOUNT
    SMARTCARD_REQUIRED = UF_SMARTCARD_REQUIRED
    TRUSTED_FOR_DELEGATION = UF_TRUSTED_FOR_DELEGATION
    NOT_DELEGATED = UF_NOT_DELEGATED
    USE_DES_KEY_ONLY = UF_USE_DES_KEY_ONLY
    DONT_REQ_PREAUTH = UF_DONT_REQUIRE_PREAUTH
    PASSWORD_EXPIRED = UF_PASSWORD_EXPIRED
    TRUSTED_TO_AUTH_FOR_DELEGATION = UF_TRUSTED_TO_AUTHENTICATE_FOR_DELEGATION
    NO_AUTH_DATA_REQUIRED = UF_NO_AUTH_DATA_REQUIRED
    PARTIAL_SECRETS_ACCOUNT = UF_PARTIAL_SECRETS_ACCOUNT
    USE_AES_KEYS = UF_USE_AES_KEYS


class SupportedEncryptionTypes(IntFlag):
    ALL_TYPES = ENC_ALL_TYPES
    CRC32 = ENC_CRC32
    RSA_MD5 = ENC_RSA_MD5
    RC4_HMAC_MD5 = ENC_RC4_HMAC_MD5
    HMAC_SHA1_96_AES128 = ENC_HMAC_SHA1_96_AES128
    HMAC_SHA1_96_AES256 = ENC_HMAC_SHA1_96_AES256
    HMAC_SHA1_96_AES256_SK = ENC_HMAC_SHA1_96_AES256_SK
    FAST_SUPPORTED = KERB_ENCTYPE_FAST_SUPPORTED
    COMPOUND_IDENTITY_SUPPORTED = KERB_ENCTYPE_COMPOUND_IDENTITY_SUPPORTED
    CLAIMS_SUPPORTED = KERB_ENCTYPE_CLAIMS_SUPPORTED
    RESOURCE_SID_COMPRESSION_DISABLED = KERB_ENCTYPE_RESOURCE_SID_COMPRESSION_DISABLED
