# Lepton Code of Conduct

## Conduct

* We are committed to providing a friendly, safe and welcoming
  environment for all, regardless of level of experience or other
  personal characteristics[<sup>1</sup>](#footnote1).

* Please be kind and courteous.  There's no need to be mean or rude.

* Respect that people have differences of opinion and that every
  design or implementation choice carries a trade-off and numerous
  costs.  There is seldom a right answer.

* Please keep unstructured critique to a minimum.  If you have solid
  ideas you want to experiment with, make a fork and see how it works.

* We will exclude you from interaction if you insult, demean or harass
  anyone.  That is not welcome behaviour.  We interpret the term
  "harassment" as included in the definition in the [Citizen Code of
  Conduct](http://citizencodeofconduct.org/); if you have any lack of
  clarity about what might be included in that concept, please read
  their definition.  In particular, we don't tolerate behaviour that
  excludes people in socially marginalized groups.

* Private harrassment is also unacceptable.  No matter who you are, if
  you feel you have been or are being harassed or made uncomfortable
  by a community member, please contact on of the organisation owners
  (@vzh or @peter-b) immediately.  Whether you're a regular
  contributor or a newcomer, we care about making this community a
  safe place for you and we've got your back.

* Likewise any spamming, trolling, flaming, baiting or other
  attention-stealing behaviour is not welcome.

<a anchor="footnote1"><sup>1</sup></a> For example, personal
characteristics might include sex & sexual orientation or gender,
gender identity & expression, disability, personal appearance, body
size, race, ethnicity, age, religion or nationality.

## Moderation

These are the policies for upholding our community's standards of
conduct.

1. Remarks that violate the Lepton standards of conduct, including
hateful, hurtful, oppressive or exclusionary remarks, are not allowed.
(Cursing is allowed, but never targetting another person, and never in
a hateful manner.)

2. Remarks that moderators find inappropriate, whether listed in the
code of conduct or not, are also not allowed.

3. Moderators will first respond to such remarks with a warning.

4. If the warning is unheeded, the user will be "kicked", i.e. kicked
out of the communication channel to cool off.

5. If the user comes back and continues to make trouble, they will be
banned, i.e. excluded indefinitely.

6. Moderators may choose at their discretion to un-ban the user if it
was a first offense and they offer the offended party a genuine
apology.

7. If a moderator bans someone and you think it was unjustified,
please take it up with that moderator, or with a different moderator,
**in private**.  Complains about bans in-channel are not allowed.

8. Moderators are held to a higher standard than other community
members.  If a moderator creates an inappropriate situation, they
should expect less leeway than others.

## Principles

In the Lepton community, we strive to go the extra step to look out
for each other.  Don't just aim to be technically unimpeachable, try
to be your best self.  In particular, avoid flirting with offensive or
sensitive issues, particularly if they're off-topic; this all too
often leads to unnecessary fights, hurt feelings and damaged trust;
worse, it can drive people away from the community entirely.

And if someone takes issue with something you said or did, resist the
urge to be defensive.  Just stop doing what it was they complained
about and apologize.  Even if you feel you were misinterpreted or
unfairly accused, there was probably something you could have
communicated better; remember that it's your responsibility to make
your fellow Lepton users and contributors comfortable.  Everyone wants
to get along, and we are all here first and foremost because we want
to design, use and talk about cool technology.  You will find that
people will be eager to assume good intent and forgive as long as you
earn their trust.

The enforcement policies above apply to all official Lepton venues,
including:

* the [Lepton-EDA](https://gitter.im/Lepton-EDA) Gitter community
* the [lepton-eda](https://github.com/lepton-eda) GitHub organisation

*Adapted from the
[Node.js Policy on Trolling](http://blog.izs.me/post/30036893703/policy-on-trolling)
and the
[Contributor Code of Conduct 1.3.0](http://contributor-covenant.org/version/1/3/0/)
via the
[Rust Code of Conduct](https://www.rust-lang.org/en-US/conduct.html).*