% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/princmp.r
\name{princmp}
\alias{princmp}
\title{princmp}
\usage{
princmp(
  formula,
  data = environment(formula),
  method = c("regular", "sparse"),
  k = min(5, p - 1),
  kapprox = min(5, k),
  cor = TRUE,
  sw = FALSE,
  nvmax = 5
)
}
\arguments{
\item{formula}{a formula with no left hand side, or a numeric matrix}

\item{data}{a data frame or table.  By default variables come from the calling environment.}

\item{method}{specifies whether to use regular or sparse principal components are computed}

\item{k}{the number of components to plot, display, and return}

\item{kapprox}{the number of components to approximate with stepwise regression when \code{sw=TRUE}}

\item{cor}{set to \code{FALSE} to compute PCs on the original data scale, which is useful if all variables have the same units of measurement}

\item{sw}{set to \code{TRUE} to run stepwise regression PC prediction/approximation}

\item{nvmax}{maximum number of predictors to allow in stepwise regression PC approximations}
}
\value{
a list of class \code{princmp} with elements \code{scores}, a k-column matrix with principal component scores, with \code{NA}s when the input data had an \code{NA}, and other components useful for printing and plotting.  If \code{k=1} \code{scores} is a vector.  Other components include \code{vars} (vector of variances explained), \code{method}, \code{k}.
}
\description{
Enhanced Output for Principal and Sparse Principal Components
}
\details{
Expands any categorical predictors into indicator variables, and calls \code{princomp} (if \code{method='regular'} (the default)) or \code{sPCAgrid} in the \code{pcaPP} package (\code{method='sparse'}) to compute lasso-penalized sparse principal components.  By default all variables are first scaled by their standard deviation after observations with any \code{NA}s on any variables in \code{formula} are removed.  Loadings of standardized variables, and if \code{orig=TRUE} loadings on the original data scale are printed.  If \code{pl=TRUE} a scree plot is drawn with text added to indicate cumulative proportions of variance explained.  If \code{sw=TRUE}, the \code{leaps} package \code{regsubsets} function is used to approximate the PCs using forward stepwise regression with the original variables as individual predictors.

A \code{print} method prints the results and a \code{plot} method plots the scree plot of variance explained.
}
\author{
Frank Harrell
}
