% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotCorrM.r
\name{plotCorrM}
\alias{plotCorrM}
\title{plotCorrM}
\usage{
plotCorrM(
  r,
  what = c("plots", "data"),
  type = c("rectangle", "circle"),
  xlab = "",
  ylab = "",
  maxsize = 12,
  xangle = 0
)
}
\arguments{
\item{r}{correlation matrix}

\item{what}{specifies whether to return plots or the data frame used in making the plots}

\item{type}{specifies whether to use bottom-aligned rectangles (the default) or centered circles}

\item{xlab}{x-axis label for correlation matrix}

\item{ylab}{y-axis label for correlation matrix}

\item{maxsize}{maximum circle size if \code{type='circle'}}

\item{xangle}{angle for placing x-axis labels, defaulting to 0.  Consider using \code{xangle=45} when labels are long.}
}
\value{
a list containing two \code{ggplot2} objects if \code{what='plots'}, or a data frame if \code{what='data'}
}
\description{
Plot Correlation Matrix and Correlation vs. Time Gap
}
\details{
Constructs two \code{ggplot2} graphics.  The first is a half matrix of rectangles where the height of the rectangle is proportional to the absolute value of the correlation coefficient, with positive and negative coefficients shown in different colors.  The second graphic is a variogram-like graph of correlation coefficients on the y-axis and absolute time gap on the x-axis, with a \code{loess} smoother added.  The times are obtained from the correlation matrix's row and column names if these are numeric.  If any names are not numeric, the times are taken as the integers 1, 2, 3, ...  The two graphics are \code{ggplotly}-ready if you use \code{plotly::ggplotly(..., tooltip='label')}.
}
\examples{
set.seed(1)
r <- cor(matrix(rnorm(100), ncol=10))
g <- plotCorrM(r)
g[[1]]  # plot matrix
g[[2]]  # plot correlation vs gap time
# ggplotlyr(g[[2]])
# ggplotlyr uses ggplotly with tooltip='label' then removes
# txt: from hover text
}
\author{
Frank Harrell
}
