#!/usr/bin/env perl

##
## Author......: See docs/credits.txt
## License.....: MIT
##

use strict;
use warnings;

use Digest::SHA  qw (sha1_hex sha224_hex);

sub module_constraints { [[0, 256], [0, 0], [0, 55], [0, 0], [-1, -1]] }

sub module_generate_hash
{
  my $word = shift;

  my $digest = sha224_hex (sha1_hex ($word));

  my $hash = sprintf ("%s", $digest);

  return $hash;
}

sub module_verify_hash
{
  my $line = shift;

  my ($digest, $word) = split (':', $line);

  return unless defined $digest;
  return unless defined $word;

  my $word_packed = pack_if_HEX_notation ($word);

  my $new_hash = module_generate_hash ($word_packed);

  return ($new_hash, $word);
}

1;
