/**
 * Author......: See docs/credits.txt
 * License.....: MIT
 */

#ifndef INC_CIPHER_AES_H
#define INC_CIPHER_AES_H

DECLSPEC void aes128_ExpandKey (PRIVATE_AS u32 *ks, PRIVATE_AS const u32 *ukey, SHM_TYPE const u32 *s_te0, SHM_TYPE const u32 *s_te1, SHM_TYPE const u32 *s_te2, SHM_TYPE const u32 *s_te3);
DECLSPEC void aes128_InvertKey (PRIVATE_AS u32 *ks, SHM_TYPE const u32 *s_te1, SHM_TYPE const u32 *s_td0, SHM_TYPE const u32 *s_td1, SHM_TYPE const u32 *s_td2, SHM_TYPE const u32 *s_td3);
DECLSPEC void aes128_set_encrypt_key (PRIVATE_AS u32 *ks, PRIVATE_AS const u32 *ukey, SHM_TYPE u32 *s_te0, SHM_TYPE u32 *s_te1, SHM_TYPE u32 *s_te2, SHM_TYPE u32 *s_te3);
DECLSPEC void aes128_set_decrypt_key (PRIVATE_AS u32 *ks, PRIVATE_AS const u32 *ukey, SHM_TYPE u32 *s_te0, SHM_TYPE u32 *s_te1, SHM_TYPE u32 *s_te2, SHM_TYPE u32 *s_te3, SHM_TYPE u32 *s_td0, SHM_TYPE u32 *s_td1, SHM_TYPE u32 *s_td2, SHM_TYPE u32 *s_td3);
DECLSPEC void aes128_encrypt (PRIVATE_AS const u32 *ks, PRIVATE_AS const u32 *in, PRIVATE_AS u32 *out, SHM_TYPE const u32 *s_te0, SHM_TYPE const u32 *s_te1, SHM_TYPE const u32 *s_te2, SHM_TYPE const u32 *s_te3, SHM_TYPE const u32 *s_te4);
DECLSPEC void aes128_decrypt (PRIVATE_AS const u32 *ks, PRIVATE_AS const u32 *in, PRIVATE_AS u32 *out, SHM_TYPE const u32 *s_td0, SHM_TYPE const u32 *s_td1, SHM_TYPE const u32 *s_td2, SHM_TYPE const u32 *s_td3, SHM_TYPE const u32 *s_td4);
DECLSPEC void aes192_ExpandKey (PRIVATE_AS u32 *ks, PRIVATE_AS const u32 *ukey, SHM_TYPE const u32 *s_te0, SHM_TYPE const u32 *s_te1, SHM_TYPE const u32 *s_te2, SHM_TYPE const u32 *s_te3);
DECLSPEC void aes192_InvertKey (PRIVATE_AS u32 *ks, SHM_TYPE const u32 *s_te1, SHM_TYPE const u32 *s_td0, SHM_TYPE const u32 *s_td1, SHM_TYPE const u32 *s_td2, SHM_TYPE const u32 *s_td3);
DECLSPEC void aes192_set_encrypt_key (PRIVATE_AS u32 *ks, PRIVATE_AS const u32 *ukey, SHM_TYPE u32 *s_te0, SHM_TYPE u32 *s_te1, SHM_TYPE u32 *s_te2, SHM_TYPE u32 *s_te3);
DECLSPEC void aes192_set_decrypt_key (PRIVATE_AS u32 *ks, PRIVATE_AS const u32 *ukey, SHM_TYPE u32 *s_te0, SHM_TYPE u32 *s_te1, SHM_TYPE u32 *s_te2, SHM_TYPE u32 *s_te3, SHM_TYPE u32 *s_td0, SHM_TYPE u32 *s_td1, SHM_TYPE u32 *s_td2, SHM_TYPE u32 *s_td3);
DECLSPEC void aes192_encrypt (PRIVATE_AS const u32 *ks, PRIVATE_AS const u32 *in, PRIVATE_AS u32 *out, SHM_TYPE const u32 *s_te0, SHM_TYPE const u32 *s_te1, SHM_TYPE const u32 *s_te2, SHM_TYPE const u32 *s_te3, SHM_TYPE const u32 *s_te4);
DECLSPEC void aes192_decrypt (PRIVATE_AS const u32 *ks, PRIVATE_AS const u32 *in, PRIVATE_AS u32 *out, SHM_TYPE const u32 *s_td0, SHM_TYPE const u32 *s_td1, SHM_TYPE const u32 *s_td2, SHM_TYPE const u32 *s_td3, SHM_TYPE const u32 *s_td4);
DECLSPEC void aes256_ExpandKey (PRIVATE_AS u32 *ks, PRIVATE_AS const u32 *ukey, SHM_TYPE const u32 *s_te0, SHM_TYPE const u32 *s_te1, SHM_TYPE const u32 *s_te2, SHM_TYPE const u32 *s_te3);
DECLSPEC void aes256_InvertKey (PRIVATE_AS u32 *ks, SHM_TYPE const u32 *s_te1, SHM_TYPE const u32 *s_td0, SHM_TYPE const u32 *s_td1, SHM_TYPE const u32 *s_td2, SHM_TYPE const u32 *s_td3);
DECLSPEC void aes256_set_encrypt_key (PRIVATE_AS u32 *ks, PRIVATE_AS const u32 *ukey, SHM_TYPE u32 *s_te0, SHM_TYPE u32 *s_te1, SHM_TYPE u32 *s_te2, SHM_TYPE u32 *s_te3);
DECLSPEC void aes256_set_decrypt_key (PRIVATE_AS u32 *ks, PRIVATE_AS const u32 *ukey, SHM_TYPE u32 *s_te0, SHM_TYPE u32 *s_te1, SHM_TYPE u32 *s_te2, SHM_TYPE u32 *s_te3, SHM_TYPE u32 *s_td0, SHM_TYPE u32 *s_td1, SHM_TYPE u32 *s_td2, SHM_TYPE u32 *s_td3);
DECLSPEC void aes256_encrypt (PRIVATE_AS const u32 *ks, PRIVATE_AS const u32 *in, PRIVATE_AS u32 *out, SHM_TYPE const u32 *s_te0, SHM_TYPE const u32 *s_te1, SHM_TYPE const u32 *s_te2, SHM_TYPE const u32 *s_te3, SHM_TYPE const u32 *s_te4);
DECLSPEC void aes256_decrypt (PRIVATE_AS const u32 *ks, PRIVATE_AS const u32 *in, PRIVATE_AS u32 *out, SHM_TYPE const u32 *s_td0, SHM_TYPE const u32 *s_td1, SHM_TYPE const u32 *s_td2, SHM_TYPE const u32 *s_td3, SHM_TYPE const u32 *s_td4);
DECLSPEC void AES128_set_encrypt_key (PRIVATE_AS u32 *ks, PRIVATE_AS const u32 *ukey, SHM_TYPE u32 *s_te0, SHM_TYPE u32 *s_te1, SHM_TYPE u32 *s_te2, SHM_TYPE u32 *s_te3);
DECLSPEC void AES128_set_decrypt_key (PRIVATE_AS u32 *ks, PRIVATE_AS const u32 *ukey, SHM_TYPE u32 *s_te0, SHM_TYPE u32 *s_te1, SHM_TYPE u32 *s_te2, SHM_TYPE u32 *s_te3, SHM_TYPE u32 *s_td0, SHM_TYPE u32 *s_td1, SHM_TYPE u32 *s_td2, SHM_TYPE u32 *s_td3);
DECLSPEC void AES128_encrypt (PRIVATE_AS const u32 *ks, PRIVATE_AS const u32 *in, PRIVATE_AS u32 *out, SHM_TYPE u32 *s_te0, SHM_TYPE u32 *s_te1, SHM_TYPE u32 *s_te2, SHM_TYPE u32 *s_te3, SHM_TYPE u32 *s_te4);
DECLSPEC void AES128_decrypt (PRIVATE_AS const u32 *ks, PRIVATE_AS const u32 *in, PRIVATE_AS u32 *out, SHM_TYPE u32 *s_td0, SHM_TYPE u32 *s_td1, SHM_TYPE u32 *s_td2, SHM_TYPE u32 *s_td3, SHM_TYPE u32 *s_td4);
DECLSPEC void AES192_set_encrypt_key (PRIVATE_AS u32 *ks, PRIVATE_AS const u32 *ukey, SHM_TYPE u32 *s_te0, SHM_TYPE u32 *s_te1, SHM_TYPE u32 *s_te2, SHM_TYPE u32 *s_te3);
DECLSPEC void AES192_set_decrypt_key (PRIVATE_AS u32 *ks, PRIVATE_AS const u32 *ukey, SHM_TYPE u32 *s_te0, SHM_TYPE u32 *s_te1, SHM_TYPE u32 *s_te2, SHM_TYPE u32 *s_te3, SHM_TYPE u32 *s_td0, SHM_TYPE u32 *s_td1, SHM_TYPE u32 *s_td2, SHM_TYPE u32 *s_td3);
DECLSPEC void AES192_encrypt (PRIVATE_AS const u32 *ks, PRIVATE_AS const u32 *in, PRIVATE_AS u32 *out, SHM_TYPE u32 *s_te0, SHM_TYPE u32 *s_te1, SHM_TYPE u32 *s_te2, SHM_TYPE u32 *s_te3, SHM_TYPE u32 *s_te4);
DECLSPEC void AES192_decrypt (PRIVATE_AS const u32 *ks, PRIVATE_AS const u32 *in, PRIVATE_AS u32 *out, SHM_TYPE u32 *s_td0, SHM_TYPE u32 *s_td1, SHM_TYPE u32 *s_td2, SHM_TYPE u32 *s_td3, SHM_TYPE u32 *s_td4);
DECLSPEC void AES256_set_encrypt_key (PRIVATE_AS u32 *ks, PRIVATE_AS const u32 *ukey, SHM_TYPE u32 *s_te0, SHM_TYPE u32 *s_te1, SHM_TYPE u32 *s_te2, SHM_TYPE u32 *s_te3);
DECLSPEC void AES256_set_decrypt_key (PRIVATE_AS u32 *ks, PRIVATE_AS const u32 *ukey, SHM_TYPE u32 *s_te0, SHM_TYPE u32 *s_te1, SHM_TYPE u32 *s_te2, SHM_TYPE u32 *s_te3, SHM_TYPE u32 *s_td0, SHM_TYPE u32 *s_td1, SHM_TYPE u32 *s_td2, SHM_TYPE u32 *s_td3);
DECLSPEC void AES256_encrypt (PRIVATE_AS const u32 *ks, PRIVATE_AS const u32 *in, PRIVATE_AS u32 *out, SHM_TYPE u32 *s_te0, SHM_TYPE u32 *s_te1, SHM_TYPE u32 *s_te2, SHM_TYPE u32 *s_te3, SHM_TYPE u32 *s_te4);
DECLSPEC void AES256_decrypt (PRIVATE_AS const u32 *ks, PRIVATE_AS const u32 *in, PRIVATE_AS u32 *out, SHM_TYPE u32 *s_td0, SHM_TYPE u32 *s_td1, SHM_TYPE u32 *s_td2, SHM_TYPE u32 *s_td3, SHM_TYPE u32 *s_td4);

#endif // INC_CIPHER_AES_H
