#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2025 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Old Skies
# send your bug reports to vv221@dotslashplay.it
###

script_version=20250611.2

PLAYIT_COMPATIBILITY_LEVEL='2.32'

GAME_ID='old-skies'
GAME_NAME='Old Skies'

ARCHIVE_BASE_0_NAME='old_skies_v2_0a_82221.sh'
ARCHIVE_BASE_0_MD5='ccc4e578bf71a86a70dca8b4c12bab73'
ARCHIVE_BASE_0_SIZE='4406691'
ARCHIVE_BASE_0_VERSION='2.0a-gog82221'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/old_skies'

## Optional icons pack
ARCHIVE_OPTIONAL_ICONS_NAME='old-skies_icons.tar.xz'
ARCHIVE_OPTIONAL_ICONS_MD5='6994d258c4a03bc48a91b89e515dca9c'
ARCHIVE_OPTIONAL_ICONS_URL='https://downloads.dotslashplay.it/games/old-skies/'
CONTENT_ICONS_PATH='.'
CONTENT_ICONS_FILES='
16x16
32x32
48x48
64x64
128x128
256x256'

CONTENT_PATH_DEFAULT='data/noarch/game'
CONTENT_LIBS_BIN_AGS_RELATIVE_PATH='lib64'
CONTENT_LIBS_BIN_AGS_FILES='
alleg-sdl2digi.so
libagscontrollerpulp.so
libagsshell.so'
CONTENT_GAME_MAIN_FILES='
OldSkies.ags
acsetup.cfg
vernum.osk
winsetup
*.vox'
CONTENT_GAME_BIN_AGS_FILES='
ags64'
CONTENT_DOC_MAIN_FILES='
licenses'

APP_MAIN_ICON='../support/icon.png'

## Dedicated Old Skies support is not available from ScummVM 2.9.1.
APP_SCUMMVM_SCUMMID='ags:ags'

## With ScummVM 2.9.1 animation is slowed down,
## support for the shipped engine is provided as a workaround.
APP_AGS_EXE='ags64'

PACKAGES_LIST='
PKG_MAIN
PKG_BIN_SCUMMVM
PKG_BIN_AGS'

PKG_MAIN_DEPENDENCIES_SIBLINGS='
PKG_BIN'

PKG_BIN_ID="${GAME_ID}-bin"
PKG_BIN_PROVIDES="
$PKG_BIN_ID"

PKG_BIN_SCUMMVM_ID="${PKG_BIN_ID}-scummvm"
PKG_BIN_SCUMMVM_PROVIDES="$PKG_BIN_PROVIDES"
PKG_BIN_SCUMMVM_DESCRIPTION='Run with ScummVM'

PKG_BIN_AGS_ID="${PKG_BIN_ID}-ags"
PKG_BIN_AGS_PROVIDES="$PKG_BIN_PROVIDES"
PKG_BIN_AGS_DESCRIPTION='Run with shipped AGS binaries'
PKG_BIN_AGS_ARCH='64'
PKG_BIN_AGS_DEPENDENCIES_LIBRARIES='
alleg-alsadigi.so
alleg-alsamidi.so
libaldmb.so.1
liballeg.so.4.4
libc.so.6
libdl.so.2
libdumb.so.1
libgcc_s.so.1
libm.so.6
libogg.so.0
libpthread.so.0
librt.so.1
libSDL2-2.0.so.0
libstdc++.so.6
libtheora.so.0
libvorbis.so.0'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_MAIN' 'APP_MAIN'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN_SCUMMVM' 'APP_SCUMMVM'
launchers_generation 'PKG_BIN_AGS' 'APP_AGS'

# Build packages

packages_generation
printf '\n'
printf 'ScummVM:'
print_instructions 'PKG_MAIN' 'PKG_BIN_SCUMMVM'
printf 'Adventure Game Studio:'
print_instructions 'PKG_MAIN' 'PKG_BIN_AGS'

# Clean up

working_directory_cleanup

exit 0
