#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2021 Mopi
# SPDX-FileCopyrightText: © 2024 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Broken Sword 3
# send your bug reports to bugs@dotslashplay.it
###

script_version=20240822.1

PLAYIT_COMPATIBILITY_LEVEL='2.30'

GAME_ID='broken-sword-3'
GAME_NAME='Broken Sword 3: The Sleeping Dragon'

ARCHIVE_BASE_0_NAME='setup_broken_sword_3_-_the_sleeping_dragon_1.0_(19115).exe'
ARCHIVE_BASE_0_MD5='e53f974fa1042cb65a8f5fd9d2ee3b58'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_PART1_NAME='setup_broken_sword_3_-_the_sleeping_dragon_1.0_(19115)-1.bin'
ARCHIVE_BASE_0_PART1_MD5='3901d740c9071b43eae5b5e3566ef4c6'
ARCHIVE_BASE_0_SIZE='1900000'
ARCHIVE_BASE_0_VERSION='1.0-gog19115'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/broken_sword_3__the_sleeping_dragon'

CONTENT_PATH_DEFAULT='.'
CONTENT_GAME_BIN_FILES='
binkw32.dll
bstsd.exe'
CONTENT_GAME_DATA_FILES='
data
data.pak'
CONTENT_DOC_DATA_FILES='
manual.pdf
readme.txt'

USER_PERSISTENT_DIRECTORIES='
saves'

APP_MAIN_EXE='bstsd.exe'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
