=begin JA

= gtool の変数 - netCDF との対比

# * 豊田 英司 (toyoda), 森川 靖大 (morikawa)
#   * $Id: lib-gtoolvar2.rd,v 1.1 2008-09-23 09:55:27 morikawa Exp $

=end JA

=begin JA

== netCDF の復習

gtool 変数の概念は netCDF に依存しているわけではありませんが、netCDF 
ファイル形式を使うことを前提として設計され、またその設計にあたっては 
netCDF に深い影響を受けました。では、netCDF のデータはどういうものでしょ
うか。

* ひとつの netCDF ファイルはデータセットと呼ばれます。データセットには
  任意個の変数、任意個の次元、任意個の大域属性を作ることができます。

* 変数とはあらかじめ決められた名前、次元、型を持った多次元配列です。変
  数には任意個の属性を作ることができます。

* 次元とは配列添字に名前を与えるもので、名前と長さを持ちます。長さは固
  定長と不定長がありますが、ひとつのデータセットに作ることのできる不定
  長次元は最大で1つに制限されています。

* 属性は名前と型と長さを持った1次元配列です。文字型1次元配列は文字列と
  解される慣例です。

* 型は char, byte, short, int, float, double のいずれかです。これは典
  型的な 32bit機における C の型と同じ意味を持ちます。ただし、byte は 
  char と同じ大きさの整数で、char は文字型です。

ということがいえます。

次元は属性も格子点の位置情報も持つことができませんが、次元と同名の変数
を作って格納する慣用が広く行われています。これを((*次元変数*))といいます。

データ型の変換はライブラリが担当します。つまり、データセットにおける型
と異なるアプリケーションの内部的な変数に入出力しようとするときには、数
値によって正しく変換が行われます。ただし文字型と数値型は相互に変換でき
ません。


== gtool 変数における界面簡素化

gtool の変数は netCDF の変数にほぼ対応するものですが、以下のような整理
が行なわれています。これは最初はアプリケーションプログラムとの界面を簡
素化するためでしたが、結果的に論理モデルの抽出に寄与していると考えてい
ます。

=== ファイルの消去

構造のフラット化のために、ファイルという概念が消去されました。変数は変
数名だけではなく、その前にファイル名（ネットワークへの拡張を考慮し URL 
を用いるのを本則とする）を連結した ((*変数 URL*)) という文字列で識別さ
れます。

NetCDF ユーザはファイルを開き、そのファイルから変数名を検索して変数を
参照しますが、gtool ユーザは変数 URL を使って変数を開き、直接これを参
照します。

ファイルの消去にともない、大域属性という概念も消去されます。実際にはデー
タ互換性のため大域属性を設けることがあるのですが、この属性は gtool で
は配下の変数すべてに共有されているものとみなします。

=== 次元と変数の統合

NetCDF 次元を作るたびに必ず同名の次元変数を作成するという表現は無駄で
す。そこで、次元と次元変数を同一視することにしました。

NetCDF では変数は次元を持つといいましたが、gtool では「ある変数は他の
変数の次元である」という関係としてとらえます。

=== 属性の型を統合

属性は型を持たないことにしました。netCDF では文字型属性と数値型属性の
自動変換がなく、たとえば任意の型の属性を文字列として解釈しようとすると
（解釈は一義的に定まり運用上も要請があるものと思われるにもかかわらず）
大変なコードを書かなければなりません。それはライブラリでやろうというわ
けです。

gtool4 NetCDF 規約に基づくデータ
では属性には型がないものとみなします。実際の外部表現では書き込
みを行なったときに最適な型を選択し、入力時はあらゆる外部表現を目的の型
に自動的に変換します。


== 万物は変数

前のページに書いたように、gtool のデータ構造は変数（多次元配列）と変数
の属性だけに単純化されています。ここでもう一度おさらいしましょう。

* 万物は変数である。gtool の扱うすべてのデータは変数とみなされる。

* 変数は任意次元配列の本体と属性からなる。次元数は 0 以上であり、0次元
  変数をスカラともいう。

* 変数には明確な型がない。外部表現は多様である可能性があるが、それらを
  意識せずとも数値型として入出力できる。

* 属性には型がない。文字列、整数列、実数列として入出力できる。

* n 次元の変数には n 個の次元変数と呼ばれる他の変数が所属する。

* 次元変数は1次元であり、自分自身の次元変数である。

NetCDF に限らず、このようなインターフェイスを実現できるファイル形式で
あれば gtool5 は直接読み書きできるようにすることができます。

=end JA


=begin HTMLJA
<div align="left">
 <p align="left"><a href="lib-gtoolvar1.htm">前のページ</a>
</div>

<hr />
<small>
  $Id: lib-gtoolvar2.rd,v 1.1 2008-09-23 09:55:27 morikawa Exp $
</small>
=end HTMLJA
